/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.models.IModelListener;
import org.eclipse.mtj.ui.internal.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.editors.jad.form.pages.MidletType;
import org.eclipse.mtj.ui.internal.editors.jad.form.pages.MidletTypeDetailsPage;
import org.eclipse.mtj.ui.internal.editors.jad.form.pages.MidletsModel;
import org.eclipse.mtj.ui.internal.forms.blocks.DetailPage;
import org.eclipse.mtj.ui.internal.forms.blocks.MasterLabelProvider;
import org.eclipse.mtj.ui.internal.forms.blocks.NamedObject;
import org.eclipse.mtj.ui.internal.forms.blocks.ScrolledPropertiesBlock;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MidletsEditorPage
extends AbstractJADEditorPage
implements IModelListener {
    public static final String MIDLET_PREFIX = "MIDlet-";
    public static final String MIDLETS_PAGEID = "midlets";
    private Button add;
    private ScrolledPropertiesBlock block;
    private Button down;
    private int midletcount = 0;
    private MidletsModel model;
    private Button remove;
    private int storedMidletCount;
    private Button up;
    List<DetailPage> list = new ArrayList<DetailPage>();

    public MidletsEditorPage() {
        super(MIDLETS_PAGEID, MTJUIMessages.MidletsEditorPage_title);
        this.model = new MidletsModel(null);
        this.model.addModelListener(this);
    }

    public MidletsEditorPage(JADFormEditor jADFormEditor, String string) {
        super(jADFormEditor, MIDLETS_PAGEID, string);
        this.model = new MidletsModel(null);
        this.model.addModelListener(this);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        Object[] objectArray = this.model.getContents();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            manifestPreferenceStore.setValue(MIDLET_PREFIX + (n2 + 1), ((MidletType)objectArray[n2]).toString());
            ++n2;
        }
        while (n2 < this.storedMidletCount) {
            manifestPreferenceStore.setToDefault(MIDLET_PREFIX + (n2 + 1));
            ++n2;
        }
        this.midletcount = n;
        this.storedMidletCount = n;
        this.setDirty(false);
    }

    public void editorInputChanged() {
        if (this.model != null) {
            this.model.clear();
        }
        this.midletcount = 0;
        this.updateMidletProperties();
        if (this.block != null) {
            this.block.refresh();
        }
    }

    public String getTitle() {
        return MTJUIMessages.MidletsEditorPage_title;
    }

    public boolean isManagingProperty(String string) {
        boolean bl = string.startsWith(MIDLET_PREFIX);
        if (bl) {
            String string2 = string.substring(MIDLET_PREFIX.length());
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public void modelChanged(Object[] objectArray, String string, String string2) {
        this.block.refresh();
        this.setDirty(true);
    }

    public void setFocus() {
    }

    private void addMouseListenersToButtons() {
        this.add.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                MidletsEditorPage.this.midletcount = MidletsEditorPage.this.model.getContents().length + 1;
                String string = MidletsEditorPage.MIDLET_PREFIX + String.valueOf(MidletsEditorPage.this.midletcount);
                MidletType midletType = new MidletType(string, string, "", "");
                MidletsEditorPage.this.model.add(new NamedObject[]{midletType}, true);
                MidletsEditorPage.this.remove.setEnabled(true);
                if (MidletsEditorPage.this.midletcount > 1) {
                    MidletsEditorPage.this.up.setEnabled(true);
                    MidletsEditorPage.this.down.setEnabled(true);
                }
                MidletsEditorPage.this.block.setCurrentSelectedItem((ISelection)new StructuredSelection((Object)midletType));
                MidletsEditorPage.this.block.refresh();
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.remove.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem();
                if (iStructuredSelection.size() == 1) {
                    MidletType midletType = (MidletType)iStructuredSelection.getFirstElement();
                    MidletsEditorPage.this.model.remove(new MidletType[]{midletType}, true);
                    MidletsEditorPage.this.midletcount = MidletsEditorPage.this.model.getContents().length;
                    if (MidletsEditorPage.this.midletcount == 0) {
                        MidletsEditorPage.this.remove.setEnabled(false);
                    }
                    if (MidletsEditorPage.this.midletcount > 1) {
                        MidletsEditorPage.this.up.setEnabled(true);
                        MidletsEditorPage.this.down.setEnabled(true);
                    }
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.up.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                IStructuredSelection iStructuredSelection;
                if (MidletsEditorPage.this.up.isEnabled() && (iStructuredSelection = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem()).size() == 1) {
                    MidletType midletType = (MidletType)iStructuredSelection.getFirstElement();
                    MidletsEditorPage.this.model.reorder(midletType, MidletsModel.Direction.UP);
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.down.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                IStructuredSelection iStructuredSelection;
                if (MidletsEditorPage.this.down.isEnabled() && (iStructuredSelection = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem()).size() == 1) {
                    MidletType midletType = (MidletType)iStructuredSelection.getFirstElement();
                    MidletsEditorPage.this.model.reorder(midletType, MidletsModel.Direction.DOWN);
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
    }

    private void updateMidletProperties() {
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        ArrayList<MidletType> arrayList = new ArrayList<MidletType>();
        int n = 1;
        while (n < 1000) {
            String string = MIDLET_PREFIX + n;
            if (!manifestPreferenceStore.contains(string)) break;
            String string2 = manifestPreferenceStore.getString(string);
            MidletType midletType = new MidletType(string, string2);
            midletType.setName(midletType.getMidletName(), false);
            arrayList.add(midletType);
            ++this.storedMidletCount;
            ++n;
        }
        this.midletcount = this.storedMidletCount;
        if (!arrayList.isEmpty()) {
            this.model.add(arrayList.toArray(new NamedObject[0]), false);
        }
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        this.list.add(new DetailPage(MidletType.class, new MidletTypeDetailsPage(this.getJavaProject())));
        this.block = new ScrolledPropertiesBlock(this, new MasterContentProvider(), new MidletMasterLabelProvider(), this.list);
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(this.getTitle());
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        this.createErrorMessageHandler(iManagedForm);
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action(MTJUIMessages.MidletsEditorPage_help_action){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                }
            };
            action.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            iToolBarManager.add((IAction)action);
        }
        scrolledForm.updateToolBar();
        this.block.createContent(iManagedForm);
        this.add = this.block.getButtonBarBlock().getButton(0);
        this.add.setEnabled(true);
        this.remove = this.block.getButtonBarBlock().getButton(1);
        this.up = this.block.getButtonBarBlock().getButton(2);
        this.down = this.block.getButtonBarBlock().getButton(3);
        this.addMouseListenersToButtons();
        if (this.midletcount > 0) {
            this.remove.setEnabled(true);
            if (this.midletcount > 1) {
                this.up.setEnabled(true);
                this.down.setEnabled(true);
            }
        }
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/midlets.html";
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setDirty(false);
        this.updateMidletProperties();
    }

    class MasterContentProvider
    implements IStructuredContentProvider {
        MasterContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return MidletsEditorPage.this.model.getContents();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class MidletMasterLabelProvider
    extends MasterLabelProvider {
        MidletMasterLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return MTJUIPluginImages.DESC_MIDLET_ICON.createImage();
        }

        public String getColumnText(Object object, int n) {
            return ((MidletType)object).getName();
        }
    }
}

