/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.preprocess.DeviceSymbolDefinitionSetFactory;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.preferences.SymbolDefinitionsImportWizardPage;
import org.eclipse.swt.widgets.Shell;

public class SymbolDefinitionsImportWizard
extends Wizard {
    private String importDirectory = null;
    private SymbolDefinitionsImportWizardPage wizardPage;

    public SymbolDefinitionsImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(MTJUIMessages.SymbolDefinitionsImportWizardPage_title);
    }

    public void addPages() {
        this.wizardPage = new SymbolDefinitionsImportWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        switch (this.wizardPage.getImportType()) {
            case 0: {
                try {
                    this.getContainer().run(true, true, this.getProcessImportFromAntennaJarFile());
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                break;
            }
            case 1: {
                this.importDirectory = this.wizardPage.getDirectory();
                try {
                    this.getContainer().run(true, true, this.getProcessImportFromXMLFiles());
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                break;
            }
        }
        return true;
    }

    private IRunnableWithProgress getProcessImportFromAntennaJarFile() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                block16: {
                    ZipFile zipFile = null;
                    try {
                        try {
                            IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getCorePreferenceStore();
                            String string = iPreferenceStore.getString("antenna_jar");
                            InputStream inputStream = null;
                            InputStream inputStream2 = null;
                            zipFile = new JarFile(new File(string));
                            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                            while (enumeration.hasMoreElements()) {
                                JarEntry jarEntry = enumeration.nextElement();
                                if (jarEntry.getName().toLowerCase().equals("devices.xml")) {
                                    inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                                }
                                if (!jarEntry.getName().toLowerCase().equals("groups.xml")) continue;
                                inputStream2 = ((JarFile)zipFile).getInputStream(jarEntry);
                            }
                            if (inputStream != null && inputStream2 != null) {
                                try {
                                    DeviceSymbolDefinitionSetFactory.importFromJ2MEPolishFormat((IProgressMonitor)iProgressMonitor, inputStream, inputStream2);
                                }
                                catch (Exception exception) {
                                    SymbolDefinitionsImportWizard.this.handleException(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_errorDuringImportSymbolDefinitionSet, exception);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            try {
                                zipFile.close();
                            }
                            catch (Exception exception) {}
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            zipFile.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    private IRunnableWithProgress getProcessImportFromXMLFiles() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                block20: {
                    InputStream inputStream = null;
                    InputStream inputStream2 = null;
                    try {
                        try {
                            inputStream = new FileInputStream(new File(String.valueOf(SymbolDefinitionsImportWizard.this.importDirectory) + File.separator + "devices.xml"));
                            inputStream2 = new FileInputStream(new File(String.valueOf(SymbolDefinitionsImportWizard.this.importDirectory) + File.separator + "groups.xml"));
                            if (inputStream != null && inputStream2 != null) {
                                try {
                                    DeviceSymbolDefinitionSetFactory.importFromJ2MEPolishFormat((IProgressMonitor)iProgressMonitor, (InputStream)inputStream, (InputStream)inputStream2);
                                }
                                catch (Exception exception) {
                                    SymbolDefinitionsImportWizard.this.handleException(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_errorDuringImportSymbolDefinitionSet, exception);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                            try {
                                inputStream2.close();
                            }
                            catch (Exception exception) {}
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                        try {
                            inputStream2.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        inputStream2.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    private void handleException(String string, Throwable throwable) {
        MTJCorePlugin.log((int)2, (String)string, (Throwable)throwable);
        MessageDialog.openError((Shell)this.getShell(), (String)MTJUIMessages.SymbolDefinitionsImportWizardPage_error, (String)string);
    }
}

