/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.device.IDevice2;
import org.eclipse.mtj.core.model.device.impl.AbstractDevice;
import org.eclipse.mtj.core.model.device.launch.properties.LaunchTemplateProperties;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;

public class UEIDevice
extends AbstractDevice
implements IDevice2 {
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof UEIDevice) {
            bl = this.equals((UEIDevice)((Object)object));
        }
        return bl;
    }

    public boolean equals(UEIDevice uEIDevice) {
        return super.equals((AbstractDevice)uEIDevice) && this.launchCommandTemplate.equals(uEIDevice.launchCommandTemplate);
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        String string;
        boolean bl = Platform.getOS().equals("win32");
        IMidletSuiteProject iMidletSuiteProject = launchEnvironment.getMidletSuite();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl2 = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(LaunchTemplateProperties.EXECUTABLE.toString(), bl ? this.executable.getName() : this.executable.getAbsolutePath());
        hashMap.put(LaunchTemplateProperties.DEVICE.toString(), this.getName());
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put(LaunchTemplateProperties.DEBUGPORT.toString(), Integer.toString(launchEnvironment.getDebugListenerPort()));
        }
        if (!bl2) {
            string = this.getProjectClasspathString(launchEnvironment.getMidletSuite(), file, iProgressMonitor);
            hashMap.put(LaunchTemplateProperties.CLASSPATH.toString(), string);
        }
        this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.VERBOSE.toString(), iLaunchConfiguration, "mtj.verbosity_options");
        this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.HEAPSIZE.toString(), iLaunchConfiguration, "mtj.heap_size");
        string = iLaunchConfiguration.getAttribute("mtj.security_domain", "None");
        if (!string.equals("None")) {
            hashMap.put(LaunchTemplateProperties.SECURITYDOMAIN.toString(), string);
        }
        String string2 = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
        hashMap.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), string2);
        if (bl2) {
            hashMap.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(iLaunchConfiguration));
        } else if (this.shouldDoOTA(iLaunchConfiguration)) {
            object = this.getOTAURL(iLaunchConfiguration, iMidletSuiteProject);
            hashMap.put(LaunchTemplateProperties.OTAURL.toString(), object);
        } else {
            object = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor);
            if (((File)object).exists()) {
                hashMap.put(LaunchTemplateProperties.JADFILE.toString(), ((File)object).toString());
            }
            this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.TARGET.toString(), iLaunchConfiguration, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
        }
        object = ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
        return bl ? "cmd /c " + (String)object : object;
    }

    public File getWorkingDirectory() {
        return this.executable.getParentFile();
    }

    public int hashCode() {
        return this.classpath.hashCode() ^ this.executable.hashCode() ^ this.name.hashCode() ^ this.launchCommandTemplate.hashCode() ^ this.groupName.hashCode();
    }
}

