/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei.internal;

import java.io.File;
import java.util.Properties;
import org.eclipse.mtj.core.importer.JavadocDetector;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.toolkit.uei.Messages;
import org.eclipse.mtj.toolkit.uei.UEIDevice;
import org.eclipse.mtj.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.toolkit.uei.internal.properties.UEIDeviceDefinition;
import org.eclipse.mtj.toolkit.uei.model.properties.DeviceSpecificProperties;

public final class UEIDeviceInternal
extends UEIDevice {
    public UEIDeviceInternal(String string, String string2, String string3, Properties properties, UEIDeviceDefinition uEIDeviceDefinition, File file, IPreverifier iPreverifier) throws IllegalArgumentException {
        if (properties == null) {
            throw new IllegalArgumentException(Messages.UEIDevice_null_properties);
        }
        if (uEIDeviceDefinition == null) {
            throw new IllegalArgumentException(Messages.UEIDevice_null_definition);
        }
        this.setName(string);
        this.setDescription(string3);
        this.setGroupName(string2);
        this.setDeviceProperties(properties);
        this.setClasspath(this.getBootClasspath(properties));
        this.setProtectionDomains(this.getProtectionDomains(properties));
        this.setExecutable(file);
        this.setPreverifier(iPreverifier);
        this.setDebugServer(uEIDeviceDefinition.isDebugServer());
        this.setLaunchCommandTemplate(uEIDeviceDefinition.getLaunchTemplate());
        this.setBundle(UeiPlugin.getDefault().getBundle().getSymbolicName());
    }

    private Classpath getBootClasspath(Properties properties) {
        Classpath classpath = new Classpath();
        String string = properties.getProperty(DeviceSpecificProperties.BOOTCLASSPATH.toString(), "");
        String[] stringArray = string.split(",");
        JavadocDetector javadocDetector = new JavadocDetector().addJavadocSearchStrategy((JavadocDetector.IJavadocSearchStrategy)new JavadocDetector.GenericLocalFSSearch());
        LibraryImporter libraryImporter = new LibraryImporter();
        libraryImporter.setJavadocDetector(javadocDetector);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            File file = new File(string2);
            if (file.exists()) {
                classpath.addEntry(libraryImporter.createLibraryFor(file));
            }
            ++n2;
        }
        return classpath;
    }

    private String[] getProtectionDomains(Properties properties) {
        String string = properties.getProperty(DeviceSpecificProperties.SECURITY_DOMAINS.toString(), "");
        return string.split(",");
    }
}

