/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.context;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.IBaseModel;
import org.eclipse.mtj.core.model.IEditable;
import org.eclipse.mtj.core.model.IModelChangeProvider;
import org.eclipse.mtj.core.model.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.util.PropertiesUtil;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJStorageDocumentProvider;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputContext {
    private IDocumentProvider fDocumentProvider;
    private MTJFormEditor fEditor;
    private IEditorInput fEditorInput;
    private IElementStateListener fElementListener;
    private boolean fIsSourceMode;
    private IBaseModel fModel;
    private IModelChangedListener fModelListener;
    private boolean fMustSynchronize;
    private boolean fPrimary;
    private boolean fValidated;
    protected ArrayList<TextEdit> fEditOperations = new ArrayList();

    protected static boolean covers(TextEdit textEdit, TextEdit textEdit2) {
        if (textEdit.getLength() == 0) {
            return false;
        }
        int n = textEdit.getOffset();
        int n2 = textEdit.getExclusiveEnd();
        if (textEdit2.getLength() == 0) {
            int n3 = textEdit2.getOffset();
            return n < n3 && n3 < n2;
        }
        int n4 = textEdit2.getOffset();
        int n5 = textEdit2.getExclusiveEnd();
        return n <= n4 && n5 <= n2;
    }

    protected static void insert(TextEdit textEdit, TextEdit textEdit2) {
        TextEdit[] textEditArray;
        if (!textEdit.hasChildren()) {
            textEdit.addChild(textEdit2);
            if (textEdit2 instanceof MoveSourceEdit) {
                textEdit.addChild((TextEdit)((MoveSourceEdit)textEdit2).getTargetEdit());
            }
            return;
        }
        TextEdit[] textEditArray2 = textEditArray = textEdit.getChildren();
        int n = textEditArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit textEdit3 = textEditArray2[n2];
            if (InputContext.covers(textEdit3, textEdit2)) {
                InputContext.insert(textEdit3, textEdit2);
                return;
            }
            ++n2;
        }
        int n3 = textEditArray.length - 1;
        while (n3 >= 0) {
            TextEdit textEdit4 = textEditArray[n3];
            if (InputContext.covers(textEdit2, textEdit4)) {
                textEdit.removeChild(n3);
                textEdit2.addChild(textEdit4);
            }
            --n3;
        }
        textEdit.addChild(textEdit2);
        if (textEdit2 instanceof MoveSourceEdit) {
            textEdit.addChild((TextEdit)((MoveSourceEdit)textEdit2).getTargetEdit());
        }
    }

    public InputContext(MTJFormEditor mTJFormEditor, IEditorInput iEditorInput, boolean bl) {
        this.fEditor = mTJFormEditor;
        this.fEditorInput = iEditorInput;
        this.setPrimary(bl);
    }

    public void dispose() {
        IAnnotationModel iAnnotationModel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput);
        if (iAnnotationModel != null) {
            iAnnotationModel.disconnect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        }
        this.fDocumentProvider.removeElementStateListener(this.fElementListener);
        this.fDocumentProvider.disconnect((Object)this.fEditorInput);
        if (this.fModelListener != null && this.fModel instanceof IModelChangeProvider) {
            ((IModelChangeProvider)this.fModel).removeModelChangedListener(this.fModelListener);
        }
        if (this.fModel != null) {
            this.fModel.dispose();
        }
    }

    public void doRevert() {
        this.fMustSynchronize = true;
        this.synchronizeModelIfNeeded();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            IDocument iDocument = this.fDocumentProvider.getDocument((Object)this.fEditorInput);
            this.fDocumentProvider.aboutToChange((Object)this.fEditorInput);
            this.flushModel(iDocument);
            this.fDocumentProvider.saveDocument(iProgressMonitor, (Object)this.fEditorInput, iDocument, true);
            this.fDocumentProvider.changed((Object)this.fEditorInput);
            this.fValidated = false;
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (Throwable)coreException);
        }
    }

    public void doSaveAs(IProgressMonitor iProgressMonitor) throws Exception {
        Object object;
        Shell shell = this.getEditor().getSite().getShell();
        SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
        IFile iFile = null;
        if (this.fEditorInput instanceof IFileEditorInput) {
            iFile = ((IFileEditorInput)this.fEditorInput).getFile();
            saveAsDialog.setOriginalFile(iFile);
        }
        saveAsDialog.create();
        if (this.fDocumentProvider.isDeleted((Object)this.fEditorInput) && iFile != null) {
            object = NLS.bind((String)MTJUIMessages.InputContext_doSaveAs_fileNotExist, (Object)iFile.getName());
            saveAsDialog.setErrorMessage(null);
            saveAsDialog.setMessage((String)object, 2);
        }
        if (saveAsDialog.open() == 0) {
            object = saveAsDialog.getResult();
            this.handleSaveAs(iProgressMonitor, (IPath)object);
        }
    }

    public void flushEditorInput() {
        if (this.fEditOperations.size() > 0) {
            IDocument iDocument = this.fDocumentProvider.getDocument((Object)this.fEditorInput);
            this.fDocumentProvider.aboutToChange((Object)this.fEditorInput);
            this.flushModel(iDocument);
            this.fDocumentProvider.changed((Object)this.fEditorInput);
            this.fValidated = false;
        } else if (this.fModel instanceof IEditable && ((IEditable)this.fModel).isDirty()) {
            ((IEditable)this.fModel).setDirty(false);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        return this.fDocumentProvider;
    }

    public MTJFormEditor getEditor() {
        return this.fEditor;
    }

    public abstract String getId();

    public IEditorInput getInput() {
        return this.fEditorInput;
    }

    public String getLineDelimiter() {
        IDocument iDocument;
        if (this.fDocumentProvider != null && (iDocument = this.fDocumentProvider.getDocument((Object)this.fEditorInput)) != null) {
            return TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        }
        return System.getProperty("line.separator");
    }

    public IBaseModel getModel() {
        return this.fModel;
    }

    public boolean isInSourceMode() {
        return this.fIsSourceMode;
    }

    public boolean isModelCorrect() {
        this.synchronizeModelIfNeeded();
        return this.fModel != null ? this.fModel.isValid() : false;
    }

    public boolean isPrimary() {
        return this.fPrimary;
    }

    public boolean isValidated() {
        return this.fValidated;
    }

    public boolean matches(IResource iResource) {
        IFileEditorInput iFileEditorInput;
        IFile iFile;
        return this.fEditorInput instanceof IFileEditorInput && (iFile = (iFileEditorInput = (IFileEditorInput)this.fEditorInput).getFile()).equals((Object)iResource);
    }

    public boolean mustSave() {
        if (!this.fIsSourceMode && this.fModel instanceof IEditable && ((IEditable)this.fModel).isDirty()) {
            return true;
        }
        return this.fEditOperations.size() > 0 || this.fDocumentProvider.canSaveDocument((Object)this.fEditorInput);
    }

    public void setPrimary(boolean bl) {
        this.fPrimary = bl;
    }

    public boolean setSourceEditingMode(boolean bl) {
        this.fIsSourceMode = bl;
        if (bl) {
            this.flushModel(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
            this.fMustSynchronize = true;
            return true;
        }
        return this.synchronizeModelIfNeeded();
    }

    public void setValidated(boolean bl) {
        this.fValidated = bl;
    }

    public synchronized boolean validateEdit() {
        IFile iFile;
        if (!this.fValidated && this.fEditorInput instanceof IFileEditorInput && (iFile = ((IFileEditorInput)this.fEditorInput).getFile()).isReadOnly()) {
            Shell shell = this.fEditor.getEditorSite().getShell();
            IStatus iStatus = MTJUIPlugin.getWorkspace().validateEdit(new IFile[]{iFile}, (Object)shell);
            this.fValidated = true;
            if (iStatus.getSeverity() != 0) {
                ErrorDialog.openError((Shell)shell, (String)this.fEditor.getTitle(), null, (IStatus)iStatus);
            }
            return iStatus.getSeverity() == 0;
        }
        return true;
    }

    private IDocumentProvider createDocumentProvider(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IFileEditorInput) {
            return new ForwardingDocumentProvider(this.getPartitionName(), this.getDocumentSetupParticipant(), MTJUIPlugin.getDefault().getTextFileDocumentProvider());
        }
        return new MTJStorageDocumentProvider(this.getDocumentSetupParticipant());
    }

    private WorkspaceModifyOperation createWorkspaceModifyOperation(final IEditorInput iEditorInput) {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                InputContext.this.fDocumentProvider.saveDocument(iProgressMonitor, (Object)iEditorInput, InputContext.this.fDocumentProvider.getDocument((Object)InputContext.this.fEditorInput), true);
            }
        };
        return workspaceModifyOperation;
    }

    private void deinitializeDocumentProvider() {
        IAnnotationModel iAnnotationModel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput);
        if (iAnnotationModel != null) {
            iAnnotationModel.disconnect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        }
        this.fDocumentProvider.removeElementStateListener(this.fElementListener);
        this.fDocumentProvider.disconnect((Object)this.fEditorInput);
    }

    private void handleSaveAs(IProgressMonitor iProgressMonitor, IPath iPath) throws Exception, CoreException, InterruptedException, InvocationTargetException {
        if (iPath == null) {
            iProgressMonitor.setCanceled(true);
            throw new Exception(MTJUIMessages.InputContext_saveAs_noLocation);
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IFile iFile = iWorkspace.getRoot().getFile(iPath);
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        this.fDocumentProvider.aboutToChange((Object)fileEditorInput);
        this.flushModel(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        try {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)this.createWorkspaceModifyOperation((IEditorInput)fileEditorInput));
                iProgressMonitor.setCanceled(false);
                this.updateInput((IEditorInput)fileEditorInput);
            }
            catch (InterruptedException interruptedException) {
                iProgressMonitor.setCanceled(true);
                throw interruptedException;
            }
            catch (InvocationTargetException invocationTargetException) {
                iProgressMonitor.setCanceled(true);
                throw invocationTargetException;
            }
        }
        finally {
            this.fDocumentProvider.changed((Object)fileEditorInput);
        }
    }

    private void initializeDocumentProvider() throws CoreException {
        this.fDocumentProvider.connect((Object)this.fEditorInput);
        IAnnotationModel iAnnotationModel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput);
        if (iAnnotationModel != null) {
            iAnnotationModel.connect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        }
        this.fDocumentProvider.addElementStateListener(this.fElementListener);
    }

    private boolean synchronizeModelIfNeeded() {
        if (this.fMustSynchronize) {
            boolean bl = this.synchronizeModel(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
            this.fMustSynchronize = false;
            return bl;
        }
        return true;
    }

    private void updateInput(IEditorInput iEditorInput) throws CoreException {
        this.deinitializeDocumentProvider();
        this.fEditorInput = iEditorInput;
        this.initializeDocumentProvider();
    }

    protected abstract void addTextEditOperation(ArrayList<TextEdit> var1, IModelChangedEvent var2);

    protected void create() {
        this.fDocumentProvider = this.createDocumentProvider(this.fEditorInput);
        try {
            IAnnotationModel iAnnotationModel;
            this.fDocumentProvider.connect((Object)this.fEditorInput);
            this.fModel = this.createModel(this.fEditorInput);
            if (this.fModel instanceof IModelChangeProvider) {
                this.fModelListener = new IModelChangedListener(){

                    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
                        if (iModelChangedEvent.getChangeType() != 99) {
                            IModelChangeProvider iModelChangeProvider;
                            if (!InputContext.this.fEditor.getLastDirtyState()) {
                                InputContext.this.fEditor.fireSaveNeeded(InputContext.this.fEditorInput, true);
                            }
                            if ((iModelChangeProvider = iModelChangedEvent.getChangeProvider()) instanceof IEditingModel && ((IEditingModel)iModelChangeProvider).isDirty()) {
                                InputContext.this.addTextEditOperation(InputContext.this.fEditOperations, iModelChangedEvent);
                            }
                        }
                    }
                };
                ((IModelChangeProvider)this.fModel).addModelChangedListener(this.fModelListener);
            }
            if ((iAnnotationModel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput)) != null) {
                iAnnotationModel.connect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
            }
            this.fElementListener = new ElementListener();
            this.fDocumentProvider.addElementStateListener(this.fElementListener);
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (Throwable)coreException);
        }
    }

    protected abstract IBaseModel createModel(IEditorInput var1) throws CoreException;

    protected void flushModel(IDocument iDocument) {
        boolean bl = true;
        if (this.fEditOperations.size() > 0) {
            try {
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                if (this.isNewlineNeeded(iDocument)) {
                    InputContext.insert((TextEdit)multiTextEdit, (TextEdit)new InsertEdit(iDocument.getLength(), TextUtilities.getDefaultLineDelimiter((IDocument)iDocument)));
                }
                int n = 0;
                while (n < this.fEditOperations.size()) {
                    InputContext.insert((TextEdit)multiTextEdit, this.fEditOperations.get(n));
                    ++n;
                }
                if (this.fModel instanceof IEditingModel) {
                    ((IEditingModel)this.fModel).setStale(true);
                }
                multiTextEdit.apply(iDocument);
                this.fEditOperations.clear();
            }
            catch (MalformedTreeException malformedTreeException) {
                MTJCorePlugin.log((int)4, (Throwable)malformedTreeException);
                bl = false;
            }
            catch (BadLocationException badLocationException) {
                MTJCorePlugin.log((int)4, (Throwable)badLocationException);
                bl = false;
            }
        }
        if (bl && this.fModel instanceof IEditable) {
            ((IEditable)this.fModel).setDirty(false);
        }
    }

    protected abstract String getDefaultCharset();

    protected IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new IDocumentSetupParticipant(){

            public void setup(IDocument iDocument) {
            }
        };
    }

    protected abstract String getPartitionName();

    protected boolean isNewlineNeeded(IDocument iDocument) throws BadLocationException {
        return PropertiesUtil.isNewlineNeeded((IDocument)iDocument);
    }

    protected boolean synchronizeModel(IDocument iDocument) {
        return true;
    }

    class ElementListener
    implements IElementStateListener {
        ElementListener() {
        }

        public void elementContentAboutToBeReplaced(Object object) {
        }

        public void elementContentReplaced(Object object) {
            if (object != null && object.equals(InputContext.this.fEditorInput)) {
                InputContext.this.doRevert();
            }
        }

        public void elementDeleted(Object object) {
            if (object != null && object.equals(InputContext.this.fEditorInput)) {
                InputContext.this.dispose();
            }
        }

        public void elementDirtyStateChanged(Object object, boolean bl) {
            if (object != null && object.equals(InputContext.this.fEditorInput)) {
                InputContext.this.fMustSynchronize = true;
            }
        }

        public void elementMoved(Object object, Object object2) {
            if (object != null && object.equals(InputContext.this.fEditorInput)) {
                InputContext.this.dispose();
                InputContext.this.fEditor.close(true);
            }
        }
    }
}

