/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.MultiSourceEditor;
import org.eclipse.mtj.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.mtj.internal.ui.editor.context.InputContextManager;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nFormOutlinePage;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nInputContext;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nInputContextManager;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nUtil;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.L10nSourcePage;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.LocalizationPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;

public class LocalizationDataEditor
extends MultiSourceEditor {
    public boolean canCut(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                if (!(e instanceof L10nObject) || !((L10nObject)e).canBeRemoved()) continue;
                return this.canCopy(iSelection);
            }
        }
        return false;
    }

    public void contextRemoved(InputContext inputContext) {
        this.close(false);
    }

    public void editorContextAdded(InputContext inputContext) {
        this.addSourcePage(inputContext.getId());
    }

    protected void pageChange(int n) {
        L10nModel l10nModel;
        super.pageChange(n);
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage instanceof LocalizationPage && (l10nModel = (L10nModel)this.inputContextManager.findContext("l10n-context").getModel()) != null) {
            this.updateMessageManager(l10nModel.getLocales());
        }
    }

    public ISelection getSelection() {
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage != null && iFormPage instanceof LocalizationPage) {
            return ((LocalizationPage)iFormPage).getSelection();
        }
        return super.getSelection();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        try {
            L10nModel l10nModel = (L10nModel)this.inputContextManager.findContext("l10n-context").getModel();
            l10nModel.validate();
            L10nApi.syncronizeApi((L10nModel)l10nModel);
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (Throwable)coreException);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void monitoredFileAdded(IFile iFile) {
    }

    public boolean monitoredFileRemoved(IFile iFile) {
        return true;
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new LocalizationPage(this));
        }
        catch (PartInitException partInitException) {
            MTJCorePlugin.log((int)4, (Throwable)partInitException);
        }
        this.addSourcePage("l10n-context");
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new L10nFormOutlinePage(this);
    }

    protected InputContextManager createInputContextManager() {
        return new L10nInputContextManager(this);
    }

    protected void createResourceContexts(InputContextManager inputContextManager, IFileEditorInput iFileEditorInput) {
        inputContextManager.putContext((IEditorInput)iFileEditorInput, new L10nInputContext(this, (IEditorInput)iFileEditorInput, true));
        inputContextManager.monitorFile(iFileEditorInput.getFile());
    }

    protected MTJSourcePage createSourcePage(MTJFormEditor mTJFormEditor, String string, String string2, String string3) {
        return new L10nSourcePage(mTJFormEditor, string, string2);
    }

    protected void createStorageContexts(InputContextManager inputContextManager, IStorageEditorInput iStorageEditorInput) {
        inputContextManager.putContext((IEditorInput)iStorageEditorInput, new L10nInputContext(this, (IEditorInput)iStorageEditorInput, true));
    }

    protected void createSystemFileContexts(InputContextManager inputContextManager, SystemFileEditorInput systemFileEditorInput) {
        File file = (File)systemFileEditorInput.getAdapter(File.class);
        if (file != null) {
            SystemFileEditorInput systemFileEditorInput2 = new SystemFileEditorInput(file);
            inputContextManager.putContext((IEditorInput)systemFileEditorInput2, new L10nInputContext(this, (IEditorInput)systemFileEditorInput2, true));
        }
    }

    protected String getEditorID() {
        return "org.eclipse.mtj.ui.editor.LocalizationDataEditor";
    }

    protected InputContext getInputContext(Object object) {
        return this.inputContextManager.findContext("l10n-context");
    }

    public void updateMessageManager(L10nLocales l10nLocales) {
        IMessageManager iMessageManager = this.getActivePageInstance().getManagedForm().getMessageManager();
        iMessageManager.removeAllMessages();
        this.displayLocaleKeysConflict(iMessageManager, l10nLocales);
        this.displayLocaleNameError(iMessageManager, l10nLocales);
    }

    private void displayLocaleKeysConflict(IMessageManager iMessageManager, L10nLocales l10nLocales) {
        List<L10nLocale> list = L10nUtil.findConflictedLocales(l10nLocales);
        for (L10nLocale l10nLocale : list) {
            String string = NLS.bind((String)"The locale {0} has duplicated keys.", (Object)l10nLocale.getName());
            iMessageManager.addMessage((Object)l10nLocale, string, null, 3);
        }
    }

    private void displayLocaleNameError(IMessageManager iMessageManager, L10nLocales l10nLocales) {
        IDocumentElementNode[] iDocumentElementNodeArray;
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = l10nLocales.getChildNodes();
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            L10nLocale l10nLocale = (L10nLocale)iDocumentElementNode;
            if (l10nLocale.getStatus().getSeverity() == 4) {
                iMessageManager.addMessage((Object)l10nLocale, l10nLocale.getStatus().getMessage(), null, 3);
            }
            ++n2;
        }
    }
}

