/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SymbolDefinitionsImportWizardPage
extends WizardPage {
    public static final int IMPORT_FROM_ANTENNA_JAR = 0;
    public static final int IMPORT_J2MEPOLISH_FORMAT = 1;
    public static final int IMPORT_MTJ_FORMAT = 2;
    public static final String NAME = "symbolDefinitionsImportPage";
    private static final String KEY_WIDTH = "dialogWidth";
    private static final String KEY_HEIGHT = "dialogHeight";
    private Button[] importTypeRadios;
    private Label importFileLabel;
    private Text importDirectory;
    private Button importFileBrowseButton;
    private String antennaFile;

    public SymbolDefinitionsImportWizardPage() {
        super(NAME, MTJUIMessages.SymbolDefinitionsImportWizardPage_title, null);
        this.setPageComplete(true);
        this.setDescription(MTJUIMessages.SymbolDefinitionsImportWizardPage_description);
    }

    private void addChooseFileControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.importFileLabel = new Label(composite2, 0);
        this.importFileLabel.setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_specifyDirectory);
        this.importDirectory = new Text(composite2, 2048);
        this.importDirectory.setLayoutData((Object)new GridData(768));
        this.importDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SymbolDefinitionsImportWizardPage.this.updateFinishButton();
            }
        });
        this.importFileBrowseButton = new Button(composite2, 8);
        this.importFileBrowseButton.setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_browse);
        this.importFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsImportWizardPage.this.handleBrowseButton();
            }
        });
    }

    private void addImportSelectorControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_from);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.importTypeRadios = new Button[2];
        this.importTypeRadios[0] = new Button((Composite)group, 16);
        this.importTypeRadios[0].setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_importFromAntennaJarFile);
        this.importTypeRadios[1] = new Button((Composite)group, 16);
        this.importTypeRadios[1].setText(MTJUIMessages.SymbolDefinitionsImportWizardPage_importFromXMLFiles);
        this.importTypeRadios[0].setSelection(true);
        this.importTypeRadios[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.getSource()).getSelection()) {
                    SymbolDefinitionsImportWizardPage.this.updateControlEnable(true);
                } else {
                    SymbolDefinitionsImportWizardPage.this.updateControlEnable(false);
                }
                SymbolDefinitionsImportWizardPage.this.updateFinishButton();
            }
        });
        this.addChooseFileControl((Composite)group);
        this.updateControlEnable(false);
        this.updateFinishButton();
    }

    public void createControl(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                SymbolDefinitionsImportWizardPage.this.storeSize();
            }
        });
        this.setControl((Control)composite2);
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getCorePreferenceStore();
        this.antennaFile = iPreferenceStore.getString("antenna_jar");
        this.addImportSelectorControls(composite2);
        Point point = this.retrieveSize();
        if (point != null) {
            composite2.setSize(point);
        }
    }

    public String getDirectory() {
        return this.importDirectory.getText();
    }

    public int getImportType() {
        if (this.importTypeRadios[0].getSelection()) {
            return 0;
        }
        if (this.importTypeRadios[1].getSelection()) {
            return 1;
        }
        return 2;
    }

    private void handleBrowseButton() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        String string = directoryDialog.open();
        if (string != null) {
            this.importDirectory.setText(string);
            this.updateFinishButton();
        }
    }

    private Point retrieveSize() {
        Point point = null;
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null && iDialogSettings.get(KEY_WIDTH) != null) {
            point = new Point(iDialogSettings.getInt(KEY_WIDTH), iDialogSettings.getInt(KEY_HEIGHT));
        }
        return point;
    }

    private void storeSize() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        Point point = this.getControl().getSize();
        if (iDialogSettings != null) {
            iDialogSettings.put(KEY_WIDTH, point.x);
            iDialogSettings.put(KEY_HEIGHT, point.y);
        }
    }

    private void updateControlEnable(boolean bl) {
        this.importFileLabel.setEnabled(bl);
        this.importFileBrowseButton.setEnabled(bl);
        this.importDirectory.setEnabled(bl);
    }

    public void updateFinishButton() {
        String string;
        if (this.importTypeRadios[0].getSelection()) {
            if (!new File(this.antennaFile).exists()) {
                this.setPageComplete(false);
                this.setErrorMessage(MTJUIMessages.SymbolDefinitionsImportWizardPage_error_antennaLibraryIsNotSpecified);
                return;
            }
        } else if (!(!this.importTypeRadios[1].getSelection() || new File(String.valueOf(string = this.importDirectory.getText().trim()) + File.separator + "devices.xml").exists() && new File(String.valueOf(string) + File.separator + "groups.xml").exists())) {
            this.setPageComplete(false);
            this.setErrorMessage(NLS.bind((String)MTJUIMessages.SymbolDefinitionsImportWizardPage_error_directoryDoesNotContaintFiles, (Object[])new Object[]{"devices.xml", "groups.xml"}));
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

