/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core.api;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.internal.jmunit.core.api.AbstractTestWriter;
import org.eclipse.osgi.util.NLS;

public class TestSuiteWriter
extends AbstractTestWriter {
    private String suiteName;

    public TestSuiteWriter(IType iType, String string) throws JavaModelException {
        super(iType);
        this.suiteName = string;
    }

    public void updateSetupSuiteMethod(String[] iBuffer, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.type.getCompilationUnit();
        Document document = new Document(iCompilationUnit.getBuffer().getContents());
        IMethod iMethod = this.type.getMethod("setupSuite", new String[0]);
        try {
            if (iMethod != null) {
                ISourceRange iSourceRange = iMethod.getSourceRange();
                StringBuffer stringBuffer = new StringBuffer(document.get(iSourceRange.getOffset(), iSourceRange.getLength()));
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(this.delimiter);
                IBuffer iBuffer2 = iBuffer;
                int n = ((String[])iBuffer2).length;
                int n2 = 0;
                while (n2 < n) {
                    String string = iBuffer2[n2];
                    stringBuffer2.append(NLS.bind((String)"add(new {0}());", (Object)string));
                    stringBuffer2.append(this.delimiter);
                    ++n2;
                }
                int n3 = stringBuffer.indexOf("JMUnit-BEGIN") + "JMUnit-BEGIN".length();
                n2 = stringBuffer.indexOf("//", n3);
                stringBuffer.replace(n3, n2, stringBuffer2.toString());
                document.replace(iSourceRange.getOffset(), iSourceRange.getLength(), stringBuffer.toString());
                String string = Utils.codeFormat((IJavaProject)iCompilationUnit.getJavaProject(), (String)document.get(), (int)8, (int)0, (String)this.delimiter);
                iBuffer2 = iCompilationUnit.getBuffer();
                iBuffer2.replace(0, iBuffer2.getLength(), string);
                iCompilationUnit.save((IProgressMonitor)new NullProgressMonitor(), true);
            }
        }
        catch (BadLocationException badLocationException) {
            MTJCorePlugin.log((int)4, (Throwable)badLocationException);
        }
    }

    public void writeCode(String[] stringArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.writeConstructor(iProgressMonitor);
        this.writeSuiteSetup(stringArray, iProgressMonitor);
    }

    private IMethod writeConstructor(IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"TestSuite Class constructor initializes the test suite."};
        this.writeMethodComment(stringBuffer, stringArray, this.delimiter);
        String string = NLS.bind((String)"public {0}()", (Object)this.type.getElementName());
        String[] stringArray2 = new String[]{NLS.bind((String)"super(\"{0}\");", (Object)this.suiteName), "this.setupSuite();"};
        this.writeMethodDeclaration(stringBuffer, string, stringArray2, this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }

    private IMethod writeSuiteSetup(String[] stringArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = new String[]{"This method adds all suite test cases to be run."};
        this.writeMethodComment(stringBuffer, stringArray2, this.delimiter);
        String string = "private void setupSuite()";
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("//JMUnit-BEGIN");
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray3[n2];
            linkedList.add(NLS.bind((String)"add(new {0}());", (Object)string2));
            ++n2;
        }
        linkedList.add("//JMUnit-END");
        this.writeMethodDeclaration(stringBuffer, string, linkedList.toArray(new String[linkedList.size()]), this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }
}

