/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.launching.StackTraceEntry;
import org.eclipse.mtj.core.internal.launching.StackTraceParserException;
import org.eclipse.mtj.core.internal.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StackTraceParser {
    protected IJavaProject project;

    public StackTraceParser(IJavaProject iJavaProject) {
        this.project = iJavaProject;
    }

    public abstract Stack<StackTraceEntry> parseStackTrace(Stack<StackTraceEntry> var1) throws StackTraceParserException;

    protected File getSourceFile(String string) throws StackTraceParserException {
        File file = null;
        try {
            ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
            arrayList.add(this.project);
            arrayList.addAll((Collection)Arrays.asList(Utils.getRequiredProjects(this.project)));
            for (IJavaProject iJavaProject : arrayList) {
                String[] stringArray = Utils.getJavaProjectSourceDirectories(iJavaProject);
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = iJavaProject.getProject().getLocation().append(stringArray[n]).toFile();
                    file = this.findClassFile(file2, string);
                    if (file != null) break;
                    ++n;
                }
                if (file == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            MTJCorePlugin.log(4, exception.getMessage(), exception);
        }
        return file;
    }

    private File findClassFile(File file, String string) {
        File file2 = null;
        int n = string.indexOf("$");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(".")) >= 0) {
            String string2 = string.substring(0, n);
            String[] stringArray = string2.split(".");
            int n2 = 0;
            while (n2 < stringArray.length) {
                file2 = new File(file, stringArray[n2]);
                if (file2.exists()) {
                    file = file2;
                }
                ++n2;
            }
        } else {
            file2 = new File(file, String.valueOf(string) + ".java");
        }
        if (file2 != null && !file2.exists()) {
            file2 = null;
        }
        return file2;
    }
}

