/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.configuration.Configurations;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.symbol.Symbol;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSet;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationsUtils {
    public static boolean configsContentsEquals(Configurations configurations, Configurations configurations2) {
        if (configurations.size() != configurations2.size()) {
            return false;
        }
        for (Configuration configuration : configurations) {
            int n = configurations2.indexOf(configuration);
            if (n < 0) {
                return false;
            }
            Configuration configuration2 = (Configuration)configurations2.get(n);
            if (!ConfigurationsUtils.deviceEquals(configuration, configuration2)) {
                return false;
            }
            if (!ConfigurationsUtils.workspaceSymbolsetsEquals(configuration.getWorkspaceScopeSymbolSets(), configuration2.getWorkspaceScopeSymbolSets())) {
                return false;
            }
            if (ConfigurationsUtils.symbolSetEquals(configuration, configuration2)) continue;
            return false;
        }
        return true;
    }

    public static boolean configurationsEuqals(Configurations configurations, Configurations configurations2) {
        if (!ConfigurationsUtils.configsContentsEquals(configurations, configurations2)) {
            return false;
        }
        return configurations.getActiveConfiguration().equals(configurations2.getActiveConfiguration());
    }

    private static boolean deviceEquals(Configuration configuration, Configuration configuration2) {
        return configuration.getDevice() == configuration2.getDevice();
    }

    public static boolean isConfigsDirty(IMidletSuiteProject iMidletSuiteProject) {
        Configurations configurations;
        Configurations configurations2 = iMidletSuiteProject.getConfigurations();
        boolean bl = !ConfigurationsUtils.configurationsEuqals(configurations2, configurations = new MetaData(iMidletSuiteProject.getProject()).getConfigurations());
        return bl;
    }

    public static boolean isOnlyActiveConfigDirty(IMidletSuiteProject iMidletSuiteProject) {
        Configurations configurations = iMidletSuiteProject.getConfigurations();
        Configurations configurations2 = new MetaData(iMidletSuiteProject.getProject()).getConfigurations();
        boolean bl = ConfigurationsUtils.configsContentsEquals(configurations, configurations2);
        return bl;
    }

    private static boolean symbolSetEquals(Configuration configuration, Configuration configuration2) {
        SymbolSet symbolSet;
        SymbolSet symbolSet2 = configuration.getSymbolSet();
        if (!symbolSet2.equals(symbolSet = configuration2.getSymbolSet())) {
            return false;
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>(symbolSet2);
        ArrayList<Symbol> arrayList2 = new ArrayList<Symbol>(symbolSet);
        for (Symbol symbol : arrayList) {
            int n = arrayList2.indexOf(symbol);
            if (n < 0) {
                return false;
            }
            Symbol symbol2 = (Symbol)arrayList2.get(n);
            if (symbol.getValue().equals(symbol2.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean workspaceSymbolsetsEquals(List<SymbolDefinitionSet> list, List<SymbolDefinitionSet> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null && list2 != null) {
            return false;
        }
        if (list != null && list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (SymbolDefinitionSet symbolDefinitionSet : list) {
            if (list2.contains(symbolDefinitionSet)) continue;
            return false;
        }
        return true;
    }
}

