/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.project;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCoreErrors;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.signing.Base64EncDec;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.configuration.Configurations;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.symbol.Symbol;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSet;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSetFactory;
import org.eclipse.mtj.core.model.project.impl.MidletSuiteProject;
import org.eclipse.mtj.core.model.sign.ISignatureProperties;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.signing.SignatureProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData {
    public static final String METADATA_FILE = ".mtj";
    private static final String ELEM_ROOT_NAME = "mtjMetadata";
    private static final String ATTR_JAD_FILE = "jad";
    private static final String ELEM_SIGNING = "signing";
    private static final String ATTR_SIGN_PROJECT = "signProject";
    private static final String ELEM_KEYSTORE = "keystore";
    private static final String ELEM_ALIAS = "alias";
    private static final String ELEM_PROVIDER = "provider";
    private static final String ELEM_KEYSTORETYPE = "keystoreType";
    private static final String ELEM_PASSWORDS = "passwords";
    private static final String ATTR_STOREPASSWORDS = "storePasswords";
    private static final String ELEM_PWD_KEYSTORE = "keystore";
    private static final String ELEM_PWD_KEY = "key";
    private static final String ELEM_DEVICE = "device";
    private static final String ATTR_DEVICEGROUP = "group";
    private static final String ATTR_DEVICENAME = "name";
    private static final String ELEM_CONFIGURATIONS = "configurations";
    private static final String CRYPTO_ALGORITHM = "PBEWithMD5AndTripleDES";
    private static final String CRYPTO_PASS = "MTJ";
    private static final byte[] CRYPTO_SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    private static final int CRYPTO_ITERATION_COUNT = 10;
    private static final String KEYRING_URL_BASE = "http://projects.mtj/";
    private static final String KEYRING_REALM = "projects";
    private static final String KEYRING_SCHEME = "MTJ";
    private static final String KEYRING_KEYSTOREPASS_KEY = "KeystorePass";
    private static final String KEYRING_KEYPASS_KEY = "KeyPass";
    private IProject project;
    private Version version;
    private IDevice device;
    private String jadFileName;
    private SignatureProperties signatureProps;
    private Configurations configurations;
    private Element rootXmlElement;

    public MetaData(IProject iProject) {
        this.project = iProject;
        try {
            this.loadMetaData();
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log(4, "loadMetaData() failed", coreException);
            this.initializeToDefaults();
        }
    }

    public MetaData(MidletSuiteProject midletSuiteProject) {
        this(midletSuiteProject.getJavaProject().getProject());
    }

    private Cipher createCipher(int n) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec("MTJ".toCharArray());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(CRYPTO_ALGORITHM, "SunJCE");
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(CRYPTO_SALT, 10);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm(), "SunJCE");
        cipher.init(n, (Key)secretKey, pBEParameterSpec);
        return cipher;
    }

    private String decodePassword(Element element, String string) {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, string);
        if (element2 == null) {
            return null;
        }
        String string2 = XMLUtils.getElementText(element2);
        byte[] byArray = Base64EncDec.decode(string2);
        if (byArray == null) {
            return null;
        }
        try {
            byte[] byArray2 = null;
            Cipher cipher = this.createCipher(2);
            byArray2 = cipher.doFinal(byArray);
            return new String(byArray2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (GeneralSecurityException generalSecurityException) {}
        return null;
    }

    private String encodePassword(String string) {
        if (string == null) {
            return "";
        }
        try {
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = null;
            Cipher cipher = this.createCipher(1);
            byArray2 = cipher.doFinal(byArray);
            return Base64EncDec.encode(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (GeneralSecurityException generalSecurityException) {}
        return "";
    }

    public Configurations getConfigurations() {
        return this.configurations;
    }

    public IDevice getDevice() {
        return this.device;
    }

    public String getJadFileName() {
        return this.jadFileName;
    }

    private URL getKeyringURL() throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(KEYRING_URL_BASE);
        String string = this.project.getName();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isLetterOrDigit(c) || c == '.') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('%');
                String string2 = Integer.toHexString(c);
                if ((string2.length() & 1) != 0) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            }
            ++n2;
        }
        URL uRL = null;
        try {
            uRL = new URL(stringBuffer.toString());
        }
        catch (Exception exception) {
            MTJCoreErrors.throwCoreExceptionError(90002, exception);
        }
        return uRL;
    }

    public ISignatureProperties getSignatureProperties() throws CoreException {
        return this.signatureProps;
    }

    private IFile getStoreFile() {
        IFile iFile = null;
        if (this.project != null) {
            iFile = this.project.getFile(METADATA_FILE);
        }
        return iFile;
    }

    private IFile getStoreIFile() {
        return this.project.getFile(METADATA_FILE);
    }

    public Version getVersion() {
        return this.version;
    }

    private void initializeToDefaults() {
        this.signatureProps = new SignatureProperties();
        this.configurations = new Configurations();
    }

    private void loadConfigsCompatibly(Element element) throws PersistenceException {
        this.loadDevice(element);
        Element element2 = XMLUtils.getFirstElementWithTagName(element, ELEM_CONFIGURATIONS);
        this.configurations = element2 != null ? new Configurations(element2) : new Configurations();
        if (this.configurations.isEmpty() && this.device != null) {
            this.setDeviceIntoActiveConfig(this.device);
        }
    }

    private void loadConfigurations(Element element) throws PersistenceException {
        this.loadConfigsCompatibly(element);
        Configuration configuration = this.configurations.getActiveConfiguration();
        if (configuration != null) {
            this.device = this.configurations.getActiveConfiguration().getDevice();
        }
    }

    private void loadDevice(Element element) throws PersistenceException {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, ELEM_DEVICE);
        if (element2 != null) {
            String string = element2.getAttribute(ATTR_DEVICEGROUP);
            String string2 = element2.getAttribute(ATTR_DEVICENAME);
            this.device = DeviceRegistry.singleton.getDevice(string, string2);
        }
    }

    private void loadMetaData() throws CoreException {
        boolean bl = false;
        this.loadMetaDataFromFile();
        if (this.signatureProps == null) {
            this.signatureProps = new SignatureProperties();
            this.signatureProps.clear();
            bl = true;
        }
    }

    private void loadMetaDataFromFile() throws CoreException {
        IFile iFile = this.getStoreFile();
        if (iFile != null && iFile.exists()) {
            try {
                File file = iFile.getLocation().toFile();
                Document document = XMLUtils.readDocument(file);
                if (document == null) {
                    return;
                }
                this.rootXmlElement = document.getDocumentElement();
                if (!this.rootXmlElement.getNodeName().equals(ELEM_ROOT_NAME)) {
                    return;
                }
                this.version = XMLUtils.getVersion(document);
                this.jadFileName = this.rootXmlElement.getAttribute(ATTR_JAD_FILE);
                this.loadDevice(this.rootXmlElement);
                this.loadConfigurations(this.rootXmlElement);
                this.loadSignatureProperties(this.rootXmlElement);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                MTJCorePlugin.throwCoreException(2, 99999, parserConfigurationException);
            }
            catch (SAXException sAXException) {
                MTJCorePlugin.throwCoreException(2, 99999, sAXException);
            }
            catch (IOException iOException) {
                MTJCorePlugin.throwCoreException(2, 99999, iOException);
            }
            catch (PersistenceException persistenceException) {
                MTJCorePlugin.throwCoreException(2, 99999, persistenceException);
            }
        } else {
            this.initializeToDefaults();
        }
    }

    private void loadSignatureProperties(Element element) throws CoreException {
        SignatureProperties signatureProperties = new SignatureProperties();
        Element element2 = XMLUtils.getFirstElementWithTagName(element, ELEM_SIGNING);
        if (element2 == null) {
            return;
        }
        String string = element2.getAttribute(ATTR_SIGN_PROJECT);
        if (string == null) {
            return;
        }
        if (!Boolean.valueOf(string).booleanValue()) {
            signatureProperties.setSignProject(false);
            this.signatureProps = signatureProperties;
            return;
        }
        signatureProperties.setSignProject(true);
        Element element3 = XMLUtils.getFirstElementWithTagName(element2, "keystore");
        if (element3 == null) {
            return;
        }
        signatureProperties.setKeyStoreDisplayPath(XMLUtils.getElementText(element3));
        element3 = XMLUtils.getFirstElementWithTagName(element2, ELEM_ALIAS);
        if (element3 == null) {
            return;
        }
        signatureProperties.setKeyAlias(XMLUtils.getElementText(element3));
        element3 = XMLUtils.getFirstElementWithTagName(element2, ELEM_PROVIDER);
        if (element3 != null) {
            signatureProperties.setKeyStoreProvider(XMLUtils.getElementText(element3));
        }
        if ((element3 = XMLUtils.getFirstElementWithTagName(element2, ELEM_KEYSTORETYPE)) != null) {
            signatureProperties.setKeyStoreType(XMLUtils.getElementText(element3));
        }
        if ((element3 = XMLUtils.getFirstElementWithTagName(element2, ELEM_PASSWORDS)) != null) {
            string = element3.getAttribute(ATTR_STOREPASSWORDS);
            int n = 0;
            if (string != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (Exception exception) {}
            }
            switch (n) {
                case 1: {
                    signatureProperties.setPasswordStorageMethod(n);
                    Map map = Platform.getAuthorizationInfo((URL)this.getKeyringURL(), (String)KEYRING_REALM, (String)"MTJ");
                    if (map == null) break;
                    signatureProperties.setKeyStorePassword((String)map.get(KEYRING_KEYSTOREPASS_KEY));
                    signatureProperties.setKeyPassword((String)map.get(KEYRING_KEYPASS_KEY));
                    break;
                }
                case 2: {
                    signatureProperties.setPasswordStorageMethod(n);
                    signatureProperties.setKeyStorePassword(this.decodePassword(element3, "keystore"));
                    signatureProperties.setKeyPassword(this.decodePassword(element3, ELEM_PWD_KEY));
                    break;
                }
                default: {
                    signatureProperties.setPasswordStorageMethod(0);
                    signatureProperties.setKeyStorePassword(null);
                    signatureProperties.setKeyPassword(null);
                }
            }
        }
        this.signatureProps = signatureProperties;
    }

    private void removeChildXmlElement(Element element, String string) {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, string);
        if (element2 != null) {
            element2.getParentNode().removeChild(element2);
        }
    }

    private void saveConfigurations(Element element) {
        if (this.configurations == null) {
            return;
        }
        this.removeChildXmlElement(element, ELEM_CONFIGURATIONS);
        Element element2 = XMLUtils.createChild(element, ELEM_CONFIGURATIONS);
        for (Configuration configuration : this.configurations) {
            Element element3 = XMLUtils.createChild(element2, "configuration");
            element3.setAttribute(ATTR_DEVICENAME, configuration.getName());
            element3.setAttribute("active", String.valueOf(configuration.isActive()));
            this.saveDevice(element3, configuration.getDevice());
            this.saveSymbolSet(element3, configuration.getSymbolSet());
            this.saveWorkspaceSymbolSets(element3, configuration.getWorkspaceScopeSymbolSets());
        }
    }

    private void saveDevice(Element element, IDevice iDevice) {
        if (iDevice == null) {
            return;
        }
        this.removeChildXmlElement(element, ELEM_DEVICE);
        Element element2 = XMLUtils.createChild(element, ELEM_DEVICE);
        element2.setAttribute(ATTR_DEVICEGROUP, iDevice.getGroupName());
        element2.setAttribute(ATTR_DEVICENAME, iDevice.getName());
    }

    public void saveMetaData() throws CoreException {
        IFile iFile = this.getStoreFile();
        if (iFile == null) {
            MTJCorePlugin.log(2, "saveMetaData failed due to null store file");
        } else {
            if (iFile.exists() && iFile.isReadOnly()) {
                ResourceAttributes resourceAttributes = iFile.getResourceAttributes();
                resourceAttributes.setReadOnly(false);
                iFile.setResourceAttributes(resourceAttributes);
            }
            this.saveMetaDataToFile(iFile);
        }
    }

    public void saveMetaDataToFile(IFile iFile) throws CoreException {
        try {
            String string = MTJCorePlugin.getPluginVersion();
            Version version = new Version(string);
            if (this.rootXmlElement == null) {
                this.rootXmlElement = XMLUtils.createRootElement(ELEM_ROOT_NAME, version);
            } else {
                this.rootXmlElement.setAttribute("version", version.toString());
            }
            if (this.jadFileName != null) {
                this.rootXmlElement.setAttribute(ATTR_JAD_FILE, this.jadFileName);
            }
            this.saveDevice(this.rootXmlElement, this.device);
            this.saveSignatureProps(this.rootXmlElement);
            this.saveConfigurations(this.rootXmlElement);
            File file = iFile.getLocation().toFile();
            XMLUtils.writeDocument(file, this.rootXmlElement.getOwnerDocument());
            this.version = version;
            this.getStoreIFile().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MTJCorePlugin.throwCoreException(2, 99999, parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            MTJCorePlugin.throwCoreException(2, 99999, transformerException);
        }
        catch (IOException iOException) {
            MTJCorePlugin.throwCoreException(2, 99999, iOException);
        }
    }

    private void saveSignatureProps(Element element) throws CoreException {
        this.removeChildXmlElement(element, ELEM_SIGNING);
        Element element2 = XMLUtils.createChild(element, ELEM_SIGNING);
        boolean bl = this.signatureProps.getSignProject();
        element2.setAttribute(ATTR_SIGN_PROJECT, Boolean.toString(bl));
        if (bl) {
            XMLUtils.createTextElement(element2, "keystore", this.signatureProps.getKeyStoreDisplayPath());
            XMLUtils.createTextElement(element2, ELEM_ALIAS, this.signatureProps.getKeyAlias());
            XMLUtils.createTextElement(element2, ELEM_PROVIDER, this.signatureProps.getKeyStoreProvider());
            XMLUtils.createTextElement(element2, ELEM_KEYSTORETYPE, this.signatureProps.getKeyStoreType());
            Element element3 = XMLUtils.createChild(element2, ELEM_PASSWORDS);
            element3.setAttribute(ATTR_STOREPASSWORDS, Integer.toString(this.signatureProps.getPasswordStorageMethod()));
            Platform.flushAuthorizationInfo((URL)this.getKeyringURL(), (String)KEYRING_REALM, (String)"MTJ");
            switch (this.signatureProps.getPasswordStorageMethod()) {
                case 2: {
                    XMLUtils.createTextElement(element3, "keystore", this.encodePassword(this.signatureProps.getKeyStorePassword()));
                    XMLUtils.createTextElement(element3, ELEM_PWD_KEY, this.encodePassword(this.signatureProps.getKeyPassword()));
                    break;
                }
                case 1: {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(KEYRING_KEYSTOREPASS_KEY, this.signatureProps.getKeyStorePassword());
                    hashMap.put(KEYRING_KEYPASS_KEY, this.signatureProps.getKeyPassword());
                    Platform.addAuthorizationInfo((URL)this.getKeyringURL(), (String)KEYRING_REALM, (String)"MTJ", hashMap);
                    break;
                }
            }
        }
    }

    private void saveSymbol(Element element, Symbol symbol) {
        Element element2 = XMLUtils.createChild(element, "symbol");
        element2.setAttribute(ATTR_DEVICENAME, symbol.getName());
        element2.setAttribute("value", symbol.getValue());
    }

    private void saveSymbolSet(Element element, SymbolSet symbolSet) {
        if (symbolSet == null) {
            return;
        }
        Element element2 = XMLUtils.createChild(element, "symbolSet");
        for (Symbol symbol : symbolSet) {
            this.saveSymbol(element2, symbol);
        }
    }

    private void saveWorkspaceSymbolSets(Element element, List<SymbolDefinitionSet> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SymbolDefinitionSet symbolDefinitionSet : list) {
            Element element2 = XMLUtils.createChild(element, "workspaceSymbolSet");
            element2.setAttribute(ATTR_DEVICENAME, symbolDefinitionSet.getName());
        }
    }

    public void setConfigurations(Configurations configurations) {
        this.configurations = configurations;
    }

    public void setDevice(IDevice iDevice) {
        this.device = iDevice;
        this.setDeviceIntoActiveConfig(iDevice);
    }

    private void setDeviceIntoActiveConfig(IDevice iDevice) {
        Configuration configuration = this.configurations.getActiveConfiguration();
        if (configuration != null) {
            configuration.setDevice(iDevice);
            return;
        }
        if (configuration == null && !this.configurations.isEmpty()) {
            configuration = (Configuration)this.configurations.get(0);
        }
        if (configuration == null) {
            configuration = new Configuration(iDevice.getName());
            configuration.setSymbolSet(SymbolSetFactory.createSymbolSet(iDevice));
        }
        configuration.setActive(true);
        configuration.setDevice(iDevice);
        this.configurations.add(configuration);
    }

    public void setJadFileName(String string) {
        this.jadFileName = string.replace(' ', '_');
    }

    public void setSignatureProperties(ISignatureProperties iSignatureProperties) {
        if (this.signatureProps == null) {
            this.signatureProps = new SignatureProperties();
        }
        this.signatureProps.copy(iSignatureProperties);
    }
}

