/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.motorola.impl;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.device.impl.AbstractDevice;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class MotorolaDevice
extends AbstractDevice {
    private File propertiesFile;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        boolean bl;
        IMidletSuiteProject iMidletSuiteProject = launchEnvironment.getMidletSuite();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl2 = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("executable", this.executable.getPath());
        hashMap.put("device", this.getName());
        hashMap.put("devicePropsFile", this.propertiesFile.getPath());
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put("debugPort", new Integer(launchEnvironment.getDebugListenerPort()).toString());
        }
        if (!(bl = this.shouldDirectLaunchJAD(iLaunchConfiguration))) {
            object = this.getProjectClasspathString(iMidletSuiteProject, file, iProgressMonitor);
            hashMap.put("classpath", object);
        }
        this.addLaunchConfigurationValue(hashMap, "verbose", iLaunchConfiguration, "mtj.verbosity_options");
        this.addLaunchConfigurationValue(hashMap, "heapsize", iLaunchConfiguration, "mtj.heap_size");
        if (bl) {
            hashMap.put("jadfile", this.getSpecifiedJadURL(iLaunchConfiguration));
        } else if (!this.shouldDoOTA(iLaunchConfiguration) && ((File)(object = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor))).exists()) {
            hashMap.put("jadfile", ((File)object).toString());
        }
        object = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
        hashMap.put("userSpecifiedArguments", object);
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        this.propertiesFile = new File(iPersistenceProvider.loadString("propertiesFile"));
    }

    public void setPropertiesFile(File file) {
        this.propertiesFile = file;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeString("propertiesFile", this.propertiesFile.toString());
    }
}

