/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.util.Stack;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.launching.StackTraceEntry;
import org.eclipse.mtj.core.internal.launching.StackTraceParser;
import org.eclipse.mtj.core.internal.launching.StackTraceParserException;
import org.eclipse.mtj.ui.internal.launching.MTJConsoleHyperLink;
import org.eclipse.mtj.ui.internal.launching.MTJConsoleLineTracker;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public abstract class StackTraceMatcher
implements IPatternMatchListener {
    protected MTJConsoleLineTracker tracker;
    protected StackTraceParser parser;

    public StackTraceMatcher(MTJConsoleLineTracker mTJConsoleLineTracker, StackTraceParser stackTraceParser) {
        this.tracker = mTJConsoleLineTracker;
        this.parser = stackTraceParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchFound(PatternMatchEvent patternMatchEvent) {
        try {
            StackTraceEntry stackTraceEntry;
            IConsole iConsole;
            Stack<StackTraceEntry> stack = new Stack<StackTraceEntry>();
            String string = this.tracker.getConsole().getDocument().get(patternMatchEvent.getOffset(), patternMatchEvent.getLength());
            String[] stringArray = string.split(System.getProperty("line.separator"));
            IConsole iConsole2 = this.tracker.getCachedTrace();
            int n = 0;
            while (n < stringArray.length) {
                iConsole = iConsole2;
                synchronized (iConsole) {
                    stackTraceEntry = (StackTraceEntry)iConsole2.get(stringArray[n]);
                    if (stackTraceEntry == null) {
                        stackTraceEntry = new StackTraceEntry(stringArray[n]);
                        iConsole2.put(stringArray[n], stackTraceEntry);
                    }
                    stack.push(stackTraceEntry);
                }
                ++n;
            }
            Stack stack2 = this.parser.parseStackTrace(stack);
            iConsole = this.tracker.getConsole();
            while (!stack2.isEmpty()) {
                stackTraceEntry = (StackTraceEntry)stack2.pop();
                for (IRegion iRegion : stackTraceEntry.getRegions()) {
                    MTJConsoleHyperLink mTJConsoleHyperLink = new MTJConsoleHyperLink(stackTraceEntry);
                    iConsole.addLink((IHyperlink)mTJConsoleHyperLink, iRegion.getOffset(), iRegion.getLength());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            MTJCorePlugin.log((int)4, (String)badLocationException.getMessage(), (Throwable)badLocationException);
        }
        catch (StackTraceParserException stackTraceParserException) {
            MTJCorePlugin.log((int)4, (String)stackTraceParserException.getMessage(), (Throwable)stackTraceParserException);
        }
    }

    public abstract String getPattern();

    public void connect(TextConsole textConsole) {
    }

    public void disconnect() {
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return null;
    }
}

