/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.statusHandlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.ui.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class DebuggerSettingCheckHandler
implements IStatusHandler {
    public static final boolean CORRECT_SUSPENDONCOMPILEERR_SETTING = false;
    public static final boolean CORRECT_SUSPENDONUNCAUGHTEXP_SETTING = false;
    public static final int MIN_DEBUGGERTIMEOUT_SETTING = 15000;
    public static final String PREF_DEBUGSETTING_WARNING = "org.eclipse.mtj.ui.debugSettingWarning";

    public void configDebuggerSetting() {
        boolean bl;
        IStatus iStatus = this.debugSettingSatisfied();
        if (iStatus.isOK()) {
            return;
        }
        String string = PREF_DEBUGSETTING_WARNING;
        String string2 = MTJUIPlugin.getDefault().getPreferenceStore().getString(string);
        if ("neverWarning".equals(string2)) {
            return;
        }
        Shell shell = this.getShell();
        ErrorDialogWithToggle errorDialogWithToggle = new ErrorDialogWithToggle(shell, MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_title, null, iStatus, string, MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_toggleMessage, MTJUIPlugin.getDefault().getPreferenceStore());
        errorDialogWithToggle.open();
        boolean bl2 = bl = errorDialogWithToggle.getReturnCode() == 2;
        if (bl) {
            JDIDebugModel.getPreferences().setValue(JDIDebugModel.PREF_REQUEST_TIMEOUT, 15000);
            JavaDebugUtils.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS, false);
            JavaDebugUtils.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS, false);
        }
    }

    public Object handleStatus(IStatus iStatus, Object object) throws CoreException {
        this.configDebuggerSetting();
        return Boolean.TRUE;
    }

    private IStatus debugSettingSatisfied() {
        boolean bl = JavaDebugUtils.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS);
        boolean bl2 = JavaDebugUtils.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS);
        int n = JDIDebugModel.getPreferences().getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT);
        if (!bl && !bl2 && n >= 15000) {
            return new Status(0, "org.eclipse.mtj.ui", "");
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.mtj.ui", 2, MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_warningMessage, null);
        if (bl) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.mtj.ui", MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_suspendOnUnCaughtExpWarning));
        }
        if (bl2) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.mtj.ui", MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_suspendOnCompileErrWarning));
        }
        if (n < 15000) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.mtj.ui", NLS.bind((String)MTJUIMessages.DebuggerSettingCheckHandler_debugWarning_reqestTimeoutWarning, (Object[])new Integer[]{15000})));
        }
        return multiStatus;
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow iWorkbenchWindow = MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            shell = iWorkbenchWindow.getShell();
        }
        return shell;
    }

    class ErrorDialogWithToggle
    extends ErrorDialog {
        public static final String NO_WARING = "neverWarning";
        private String fPreferenceKey;
        private Button fToggleButton;
        private String fToggleMessage;
        private boolean toggleState;
        IPreferenceStore prefStore;

        public ErrorDialogWithToggle(Shell shell, String string, String string2, IStatus iStatus, String string3, String string4, IPreferenceStore iPreferenceStore) {
            super(shell, string, string2, iStatus, 7);
            this.fPreferenceKey = null;
            this.fToggleButton = null;
            this.fToggleMessage = null;
            this.prefStore = null;
            this.prefStore = iPreferenceStore;
            this.fPreferenceKey = string3;
            this.fToggleMessage = string4;
        }

        private Button createCheckButton(Composite composite, String string) {
            final Button button = new Button(composite, 16416);
            button.setText(string);
            GridData gridData = new GridData(0);
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 2;
            button.setLayoutData((Object)gridData);
            button.setFont(composite.getFont());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ErrorDialogWithToggle.this.toggleState = button.getSelection();
                }
            });
            return button;
        }

        protected void buttonPressed(int n) {
            if (n != 13) {
                if (this.toggleState && this.prefStore != null && this.fPreferenceKey != null) {
                    this.prefStore.setValue(this.fPreferenceKey, NO_WARING);
                }
                this.setReturnCode(n);
                this.close();
            }
            super.buttonPressed(n);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(composite, 3, IDialogConstants.NO_LABEL, true);
            this.createDetailsButton(composite);
            this.getButton(2).setFocus();
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            composite2.setFont(composite.getFont());
            this.setToggleButton(this.createCheckButton(composite2, this.fToggleMessage));
            ErrorDialogWithToggle.applyDialogFont((Control)composite2);
            return composite2;
        }

        protected Button getToggleButton() {
            return this.fToggleButton;
        }

        protected void setToggleButton(Button button) {
            this.fToggleButton = button;
        }
    }
}

