/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MTJCoreStrings;
import org.eclipse.osgi.util.NLS;

public class MTJCoreErrors {
    public static final String MESSAGE_PREFIX = "MTJCoreError.";
    public static final int CORE_ERROR_BASE = 10000;
    public static final int SIGNING_BAD_KEYSTORE_OR_PASSWORD = 10001;
    public static final int SIGNING_KEYSTORE_TYPE_NOT_AVAILABLE = 10002;
    public static final int SIGNING_PROVIDER_NOT_CONFIGURED = 10003;
    public static final int SIGNING_MISSING_KEYSTORE_INTEGRITY_ALGORITHM = 10004;
    public static final int SIGNING_COULDNT_LOAD_CERTIFICATE = 10005;
    public static final int SIGNING_KEY_NOT_FOUND = 10006;
    public static final int SIGNING_INVALID_KEY_PASSWORD = 10007;
    public static final int SIGNING_BAD_KEY_TYPE = 10008;
    public static final int SIGNING_INVALID_CERTIFICATE_CHAIN = 10009;
    public static final int SIGNING_MISSING_CERTIFICATES = 10010;
    public static final int SIGNING_INVALID_KEY = 10011;
    public static final int SIGNING_NO_SUCH_ALGORITHM = 10012;
    public static final int SIGNING_SIGNATURE_EXCEPTION = 10013;
    public static final int SIGNING_CERTIFICATE_ENCODING = 10014;
    public static final int CORE_WARNING_BASE = 20000;
    public static final int CORE_INTERNAL_BASE = 90000;
    public static final int SIGNING_INTERNAL_MISSING_KEYCHAINSET = 90001;
    public static final int SIGNING_INTERNAL_UNABLE_TO_BUILD_KEYRING_URL = 90002;

    public static final String getErrorMessage(int n) {
        String string = MTJCoreStrings.getBundleString(MESSAGE_PREFIX + n);
        if (string == null) {
            string = n < 90000 ? MTJCoreStrings.getString("MTJCoreError.Default") : MTJCoreStrings.getString("MTJCoreError.InternalTemplate");
        }
        String string2 = NLS.bind((String)string, (Object[])new Integer[]{n});
        return string2;
    }

    public static void throwCoreExceptionError(int n) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.core", n, MTJCoreErrors.getErrorMessage(n), null);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreExceptionError(int n, Throwable throwable) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.core", n, MTJCoreErrors.getErrorMessage(n), throwable);
        throw new CoreException((IStatus)status);
    }
}

