/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.preprocessor.symbol;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.preprocessor.symbol.Symbol;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSet;

public class SymbolSetFactory {
    public static final String PROP_UEI_VERSION = "uei.version";
    public static final String PROP_UEI_ARGUMENTS = "uei.arguments";
    public static final String PROP_DEVICE_LIST = "device.list";
    public static final String PROP_SECURITY_DOMAINS = "security.domains";
    public static final String PROP_BOOTCLASSPATH = "bootclasspath";
    public static final String PROP_APIS = "apis";
    public static final String PROP_DESCRIPTION = "description";
    private static List<String> excludedProperties = new ArrayList<String>();

    static {
        excludedProperties.add(PROP_UEI_VERSION);
        excludedProperties.add(PROP_UEI_ARGUMENTS);
        excludedProperties.add(PROP_DEVICE_LIST);
        excludedProperties.add(PROP_SECURITY_DOMAINS);
        excludedProperties.add(PROP_BOOTCLASSPATH);
        excludedProperties.add(PROP_APIS);
        excludedProperties.add(PROP_DESCRIPTION);
    }

    private static void addLibrarySymbols(SymbolSet symbolSet, IDevice iDevice) {
        if (iDevice == null) {
            return;
        }
        ILibrary[] iLibraryArray = iDevice.getClasspath().getEntries();
        if (iLibraryArray != null) {
            ILibrary[] iLibraryArray2 = iLibraryArray;
            int n = iLibraryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILibrary iLibrary = iLibraryArray2[n2];
                String string = iLibrary.getAPIs()[0].getIdentifier().replace(' ', '_');
                string = SymbolSetFactory.replaceFirstNonLetterChar(string);
                String string2 = iLibrary.getAPIs()[0].getVersion().toString();
                symbolSet.add(new Symbol(string, string2));
                ++n2;
            }
        }
    }

    public static SymbolSet createSymbolSet(IDevice iDevice) {
        SymbolSet symbolSet = new SymbolSet();
        SymbolSetFactory.populateSymbolSetFromProperties(symbolSet, iDevice);
        SymbolSetFactory.addLibrarySymbols(symbolSet, iDevice);
        return symbolSet;
    }

    private static void populateSymbolSetFromProperties(SymbolSet symbolSet, IDevice iDevice) {
        if (iDevice == null) {
            return;
        }
        Properties properties = iDevice.getDeviceProperties();
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String string = String.valueOf(entry.getKey());
            if (excludedProperties.contains(string)) continue;
            string = SymbolSetFactory.replaceFirstNonLetterChar(string);
            String string2 = String.valueOf(entry.getValue());
            symbolSet.add(new Symbol(string, string2));
        }
    }

    public static String replaceFirstNonLetterChar(String string) {
        string = string.replaceFirst("^[^a-zA-Z].+", "a_" + string);
        return string;
    }
}

