/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.microemu;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.library.api.API;
import org.eclipse.mtj.core.sdk.device.midp.library.api.APIType;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.toolkit.microemu.Activator;
import org.eclipse.mtj.internal.toolkit.microemu.Messages;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDevice;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDeviceSkin;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuLaunchTemplateProperties;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroEmuDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final MicroEmuDeviceSkin[] EMULATOR_DEVICE_SKINS = new MicroEmuDeviceSkin[]{new MicroEmuDeviceSkin("microemulator.jar", "org/microemu/device/default/device.xml", "Default device"), new MicroEmuDeviceSkin("devices/microemu-device-large.jar", "org/microemu/device/large/device.xml", "Large Device"), new MicroEmuDeviceSkin("devices/microemu-device-minimum.jar", "org/microemu/device/minimum/device.xml", "Minimum device")};
    private static final String EMULATOR_JAR_NAME = "microemulator.jar";
    private static final String MAIN_CLASS_NAME = "org.microemu.app.Main";
    private static final String PROPS_FILE = "microemu.properties";

    public List<IDevice> importDevices(File file, IProgressMonitor iProgressMonitor) {
        ArrayList<IMIDPDevice> arrayList = null;
        try {
            File file2 = new File(file, EMULATOR_JAR_NAME);
            if (file2.exists() && this.hasMainClassAttribute(file2, MAIN_CLASS_NAME)) {
                arrayList = new ArrayList<IMIDPDevice>();
                MicroEmuDeviceSkin[] microEmuDeviceSkinArray = EMULATOR_DEVICE_SKINS;
                int n = EMULATOR_DEVICE_SKINS.length;
                int n2 = 0;
                while (n2 < n) {
                    MicroEmuDeviceSkin microEmuDeviceSkin = microEmuDeviceSkinArray[n2];
                    IMIDPDevice iMIDPDevice = this.createDevice(file2, microEmuDeviceSkin);
                    arrayList.add(iMIDPDevice);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            MTJCore.log((int)2, (String)Messages.MicroEmuDeviceImporter_import_error, (Throwable)exception);
        }
        return arrayList;
    }

    private void addDeviceLibraries(File file, IDeviceClasspath iDeviceClasspath, ILibraryImporter iLibraryImporter) {
        String[] stringArray;
        String string = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(MicroEmuLaunchTemplateProperties.TOOLKITROOT.toString(), file.getParent());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray2 = stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            ILibrary iLibrary = iLibraryImporter.createLibraryFor(new File(string2));
            API aPI = iLibrary.getAPI(APIType.UNKNOWN);
            if (aPI != null) {
                if (aPI.getIdentifier().equalsIgnoreCase("cldcapi11.jar")) {
                    aPI.setIdentifier("CLDC");
                    aPI.setType(APIType.CONFIGURATION);
                    aPI.setName("Connected Limited Device Configuration");
                    aPI.setVersion(new Version("1.1"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("midpapi20.jar")) {
                    aPI.setIdentifier("MIDP");
                    aPI.setType(APIType.PROFILE);
                    aPI.setName("Mobile Information Device Profile");
                    aPI.setVersion(new Version("2.0"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("microemu-jsr-75.jar")) {
                    aPI.setIdentifier("JSR 75");
                    aPI.setType(APIType.OPTIONAL);
                    aPI.setName("PDA Optional Packages for the J2ME Platform");
                    aPI.setVersion(new Version("1.0"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("microemu-jsr-82.jar")) {
                    aPI.setIdentifier("JSR 82");
                    aPI.setType(APIType.OPTIONAL);
                    aPI.setName("Java APIs for Bluetooth");
                    aPI.setVersion(new Version("1.1"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("microemu-jsr-120.jar")) {
                    aPI.setIdentifier("JSR 120");
                    aPI.setType(APIType.OPTIONAL);
                    aPI.setName("Wireless Messaging API");
                    aPI.setVersion(new Version("1.0"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("microemu-jsr-135.jar")) {
                    aPI.setIdentifier("JSR 135");
                    aPI.setType(APIType.OPTIONAL);
                    aPI.setName("Mobile Media API");
                    aPI.setVersion(new Version("1.0"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("microemu-nokiaui.jar")) {
                    aPI.setIdentifier("Nokia UI");
                    aPI.setType(APIType.OPTIONAL);
                    aPI.setName("Nokia UI API");
                    aPI.setVersion(new Version("1.1"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("microemu-siemensapi.jar")) {
                    aPI.setIdentifier("Siemens API");
                    aPI.setType(APIType.OPTIONAL);
                    aPI.setName("Siemens API");
                    aPI.setVersion(new Version("1.0"));
                }
                iDeviceClasspath.addEntry(iLibrary);
            }
            ++n2;
        }
    }

    private IMIDPDevice createDevice(File file, MicroEmuDeviceSkin microEmuDeviceSkin) {
        MicroEmuDevice microEmuDevice = new MicroEmuDevice();
        microEmuDevice.setBundle(Activator.getDefault().getBundle().getSymbolicName());
        microEmuDevice.setClasspath(this.getDeviceClasspath(file));
        microEmuDevice.setDebugServer(this.isDebugServer());
        microEmuDevice.setDescription("Microemulator Device");
        microEmuDevice.setDeviceProperties(new Properties());
        microEmuDevice.setGroupName("Microemulator");
        microEmuDevice.setName(microEmuDeviceSkin.getName());
        microEmuDevice.setPreverifier(this.getPreverifier(file));
        microEmuDevice.setProtectionDomains(new String[0]);
        microEmuDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        microEmuDevice.setRoot(file.getParentFile());
        microEmuDevice.setSkin(microEmuDeviceSkin);
        return microEmuDevice;
    }

    private IDeviceClasspath getDeviceClasspath(File file) {
        IDeviceClasspath iDeviceClasspath = MTJCore.createNewDeviceClasspath();
        this.addDeviceLibraries(file, iDeviceClasspath, MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei"));
        return iDeviceClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return Activator.getDefault().getBundle().getEntry(PROPS_FILE);
    }
}

