/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.core.IMTJCoreConstants;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.IDeviceFinder;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrarySpecification;
import org.eclipse.mtj.core.symbol.ISymbolSetFactory;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistry;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.PreprocessedProjectMigrationRunnable;
import org.eclipse.mtj.internal.core.build.preprocessor.PreprocessedSourceMapper;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapper;
import org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapperAccess;
import org.eclipse.mtj.internal.core.project.UnknownMetaData;
import org.eclipse.mtj.internal.core.project.midp.MetaData;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.sdk.device.DeviceFinder;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.Library;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.LibrarySpecification;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.UEILibraryImporter;
import org.eclipse.mtj.internal.core.symbol.SymbolSetFactory;
import org.eclipse.mtj.internal.core.symbol.SymbolSetRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class MTJCore
extends Plugin
implements IMTJCoreConstants {
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.mtj.core", 0, Messages.MTJCore_OK_STATUS_msg, null);
    private static MTJCore plugin;
    private static final IStatus PROMPTER_STATUS;

    static {
        PROMPTER_STATUS = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    }

    public static ILibrarySpecification createLibrarySpecification(String string, String string2, Version version) {
        return new LibrarySpecification(string, string2, version);
    }

    public static IDeviceClasspath createNewDeviceClasspath() {
        return new DeviceClasspath();
    }

    public static ILibrary createNewLibrary() {
        return new Library();
    }

    public static IPreverifier createPreverifier(String string, Object object) throws CoreException {
        IPreverifier iPreverifier = null;
        if (string.equals("org.eclipse.mtj.preverifier.standard") && object instanceof File) {
            iPreverifier = StandardPreverifierFactory.createPreverifier((File)object);
        }
        return iPreverifier;
    }

    public static ISymbolSetRegistry getSymbolSetRegistry() {
        return SymbolSetRegistry.getInstance();
    }

    public static IDeviceFinder getDeviceFinder() {
        return DeviceFinder.getInstance();
    }

    public static ISymbolSetFactory getSymbolSetFactory() {
        return SymbolSetFactory.getInstance();
    }

    public static MTJCore getDefault() {
        return plugin;
    }

    public static String getDeploymentDirectoryName() {
        return MTJCore.getDefault().getPluginPreferences().getString("deployment_dir");
    }

    public static IDeviceRegistry getDeviceRegistry() {
        return DeviceRegistry.getInstance();
    }

    public static ILibraryImporter getLibraryImporter(String string) {
        UEILibraryImporter uEILibraryImporter = null;
        if (string.equals("org.eclipse.mtj.libraryimporter.uei")) {
            uEILibraryImporter = new UEILibraryImporter();
        }
        return uEILibraryImporter;
    }

    public static IMetaData getMetaData(IProject iProject, ProjectType projectType) {
        switch (projectType) {
            case MIDLET_SUITE: {
                return new MetaData(iProject);
            }
        }
        return new UnknownMetaData();
    }

    public static String getPluginVersion() {
        Bundle bundle = MTJCore.getDefault().getBundle();
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public static File getProguardJarFile() {
        String string = MTJCore.getDefault().getPluginPreferences().getString("proguard_dir");
        File file = new File(string);
        File file2 = new File(file, "lib");
        File file3 = new File(file2, "proguard.jar");
        return file3;
    }

    public static boolean getProjectBooleanPreference(IProject iProject, String string) {
        IScopeContext[] iScopeContextArray = new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        return iPreferencesService.getBoolean("org.eclipse.mtj.core", string, false, iScopeContextArray);
    }

    public static IEclipsePreferences getProjectPreferences(IProject iProject) {
        ProjectScope projectScope = new ProjectScope(iProject);
        return projectScope.getNode("org.eclipse.mtj.core");
    }

    public static String getProjectStringPreference(IProject iProject, String string) {
        IScopeContext[] iScopeContextArray = new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        return iPreferencesService.getString("org.eclipse.mtj.core", string, null, iScopeContextArray);
    }

    public static InputStream getResourceAsStream(IPath iPath) {
        InputStream inputStream = null;
        URL uRL = FileLocator.find((Bundle)MTJCore.getDefault().getBundle(), (IPath)iPath, null);
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return inputStream;
    }

    public static String getResourcesDirectoryName() {
        return MTJCore.getDefault().getPluginPreferences().getString("resources_dir");
    }

    public static String getVerifiedOutputDirectoryName() {
        return MTJCore.getDefault().getPluginPreferences().getString("verified_dir");
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(int n, String string) {
        MTJCore.log(n, string, null);
    }

    public static void log(int n, String string, Throwable throwable) {
        if (string == null) {
            string = throwable.getMessage();
        }
        if (string == null) {
            string = Messages.MTJCore_no_message;
        }
        MTJCore mTJCore = MTJCore.getDefault();
        String string2 = "org.eclipse.mtj.core";
        Status status = new Status(n, string2, 0, string, throwable);
        mTJCore.getLog().log((IStatus)status);
    }

    public static void log(int n, Throwable throwable) {
        MTJCore.log(n, throwable.getMessage(), throwable);
    }

    public static IStatus newStatus(int n, int n2, String string) {
        return MTJCore.newStatus(n, n2, string, null);
    }

    public static IStatus newStatus(int n, int n2, String string, Throwable throwable) {
        return new Status(n, "org.eclipse.mtj.core", n2, string, throwable);
    }

    public static void setResourcesAsDerived(IContainer iContainer) throws CoreException {
        if (iContainer.exists()) {
            IResource[] iResourceArray;
            iContainer.setDerived(true);
            IResource[] iResourceArray2 = iResourceArray = iContainer.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                if (iResource instanceof IContainer) {
                    MTJCore.setResourcesAsDerived((IContainer)iResource);
                } else {
                    iResource.setDerived(true);
                }
                ++n2;
            }
        }
    }

    public static Object statusPrompt(IStatus iStatus, Object object) throws CoreException {
        Object object2 = null;
        IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(PROMPTER_STATUS);
        if (iStatusHandler == null) {
            throw new CoreException(iStatus);
        }
        object2 = iStatusHandler.handleStatus(iStatus, object);
        return object2;
    }

    public static void throwCoreException(int n, int n2, String string) throws CoreException {
        if (string == null) {
            string = Messages.MTJCore_no_message2;
        }
        Status status = new Status(n, "org.eclipse.mtj.core", n2, string, null);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreException(int n, int n2, Throwable throwable) throws CoreException {
        String string = null;
        if (throwable != null) {
            string = throwable.getMessage();
        }
        if (string == null) {
            string = Messages.MTJCore_no_message2;
        }
        Status status = new Status(n, "org.eclipse.mtj.core", n2, string, throwable);
        throw new CoreException((IStatus)status);
    }

    public MTJCore() {
        if (plugin == null) {
            plugin = this;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                switch (iResourceChangeEvent.getType()) {
                    case 4: {
                        IProject iProject;
                        IMTJProject iMTJProject;
                        IResource iResource = iResourceChangeEvent.getResource();
                        if (!(iResource instanceof IProject) || (iMTJProject = MidletSuiteFactory.getMidletSuiteProject((iProject = (IProject)iResource).getName())) == null) break;
                        MidletSuiteFactory.removeMidletSuiteProject(iMTJProject.getJavaProject());
                    }
                }
            }
        });
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        SourceMapperAccess.setSourceMapper((SourceMapper)new PreprocessedSourceMapper());
        new MigrationJob().schedule(5000L);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
    }

    private void doMigration(IProgressMonitor iProgressMonitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new PreprocessedProjectMigrationRunnable(), iProgressMonitor);
    }

    private class MigrationJob
    extends Job {
        MigrationJob() {
            super(Messages.MTJCore_MigrationJob_title);
            this.setPriority(20);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            IStatus iStatus = null;
            try {
                MTJCore.this.doMigration(iProgressMonitor);
                iStatus = OK_STATUS;
            }
            catch (CoreException coreException) {
                iStatus = coreException.getStatus();
            }
            return iStatus;
        }
    }
}

