/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.sdk.device.midp.library.api;

import java.net.URL;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.midp.library.api.APIType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class API
implements IPersistable {
    private String identifier;
    private String name;
    private String primaryMatchableClass;
    private boolean registered;
    private URL[] skeletonReplacements;
    private APIType type = APIType.UNKNOWN;
    private Version version;

    public boolean equals(Object object) {
        return object instanceof API && this.equalsAPI((API)object);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryMatchableClass() {
        return this.primaryMatchableClass;
    }

    public URL[] getSkeletonReplacements() {
        return this.skeletonReplacements;
    }

    public APIType getType() {
        return this.type;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.identifier.hashCode() ^ this.type.hashCode() ^ this.version.hashCode();
    }

    public boolean isConfiguration() {
        return this.type == APIType.CONFIGURATION;
    }

    public boolean isProfile() {
        return this.type == APIType.PROFILE;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.identifier = iPersistenceProvider.loadString("identifier");
        this.version = new Version(iPersistenceProvider.loadString("version"));
        this.registered = iPersistenceProvider.loadBoolean("registered");
        this.name = iPersistenceProvider.loadString("name");
        int n = iPersistenceProvider.loadInteger("type");
        this.type = APIType.typeForCode(n);
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPrimaryMatchableClass(String string) {
        this.primaryMatchableClass = string;
    }

    public void setRegistered(boolean bl) {
        this.registered = bl;
    }

    public void setSkeletonReplacements(URL[] uRLArray) {
        this.skeletonReplacements = uRLArray;
    }

    public void setType(APIType aPIType) {
        this.type = aPIType;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString("identifier", this.identifier);
        iPersistenceProvider.storeString("name", this.name);
        iPersistenceProvider.storeInteger("type", this.type.getTypeCode());
        iPersistenceProvider.storeString("version", NLS.bind((String)"{0}.{1}", (Object[])new Object[]{this.version.getMajor(), this.version.getMinor()}));
        iPersistenceProvider.storeBoolean("registered", this.registered);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.identifier);
        stringBuffer.append("-").append(NLS.bind((String)"{0}.{1}", (Object[])new Object[]{this.version.getMajor(), this.version.getMinor()}));
        return stringBuffer.toString();
    }

    private boolean equalsAPI(API aPI) {
        return this.identifier.equals(aPI.identifier) && this.type.equals(aPI.type) && this.version.equals((Object)aPI.version);
    }
}

