/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.api.API;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.osgi.framework.Version;

public class PreferenceAccessor {
    public static final PreferenceAccessor instance = new PreferenceAccessor();
    public static final String MULTI_VALUE_SEPARATOR = "|";
    private IEclipsePreferences defaultPreferences = new DefaultScope().getNode("org.eclipse.mtj.core");
    private IEclipsePreferences instancePreferences = new InstanceScope().getNode("org.eclipse.mtj.core");

    private PreferenceAccessor() {
    }

    public boolean getAutoversionPackage(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "pkg_use_project", "pkg_autoversion");
        return iEclipsePreferences.getBoolean("pkg_autoversion", false);
    }

    public String[] getDefaultProguardKeepExpressions() {
        String string = this.getPreferences().getDefaultString("proguard_keep");
        return this.getProguardKeepExpressions(string);
    }

    public String getDefaultProguardOptions() {
        return this.getPreferences().getDefaultString("proguard_options");
    }

    public String[] getExcludedManifestProperties(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "pkg_use_project", "pkg_excluded_props");
        String string = iEclipsePreferences.get("pkg_excluded_props", "MIDlet-Jar-URL|MIDlet-Jar-Size");
        return this.parseMultiValuedPreferenceValue(string);
    }

    public String[] getMultiValuedPreference(String string) {
        Preferences preferences = MTJCore.getDefault().getPluginPreferences();
        String string2 = preferences.getString(string);
        return this.parseMultiValuedPreferenceValue(string2);
    }

    public String getPreprecessorDebuglevel(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "preprocess_use_project", "preprocess_debuglevel");
        String string = iEclipsePreferences.get("preprocess_debuglevel", "debug");
        return string;
    }

    public Version getPreverificationConfigurationVersion(IProject iProject) throws CoreException {
        Version version = null;
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "pkg_use_project", "preverify_config_location");
        String string = iEclipsePreferences.get("preverify_config_location", "platform");
        if ("jad".equals(string)) {
            IApplicationDescriptor iApplicationDescriptor = iMidletSuiteProject.getApplicationDescriptor();
            version = iApplicationDescriptor.getConfigurationSpecificationVersion();
        } else if ("platform".equals(string)) {
            version = new Version("1.0");
            IMIDPDevice iMIDPDevice = (IMIDPDevice)iMidletSuiteProject.getMTJRuntime().getActiveMTJRuntime().getDevice();
            if (iMIDPDevice != null) {
                ILibrary iLibrary = iMIDPDevice.getConfigurationLibrary();
                API aPI = null;
                if (iLibrary != null && (aPI = iLibrary.getConfiguration()) != null) {
                    version = aPI.getVersion();
                }
            }
        } else {
            String[] stringArray;
            String string2 = iEclipsePreferences.get("preverify_config_value", "");
            if (string2.startsWith("CLDC") && (stringArray = string2.split("-")).length == 2) {
                string2 = stringArray[1];
            }
            version = new Version(string2);
        }
        if (version == null) {
            version = new Version("1.0");
        }
        return version;
    }

    public String[] getProguardKeepExpressions(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "obfuscate_use_project", "proguard_keep");
        String string = iEclipsePreferences.get("proguard_keep", "public class * extends javax.microedition.midlet.MIDlet");
        return this.parseMultiValuedPreferenceValue(string);
    }

    public String getSpecifiedProguardOptions(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "obfuscate_use_project", "proguard_options");
        return iEclipsePreferences.get("proguard_options", "-dontusemixedcaseclassnames -dontnote -defaultpackage ''");
    }

    public boolean isUseSpecifiedProguardOptions(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "obfuscate_use_project", "proguard_use_specified");
        return iEclipsePreferences.getBoolean("proguard_use_specified", false);
    }

    public String[] parseMultiValuedPreferenceValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, MULTI_VALUE_SEPARATOR);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    private Preferences getPreferences() {
        return MTJCore.getDefault().getPluginPreferences();
    }

    private String[] getProguardKeepExpressions(String string) {
        return this.getMultiValuedPreference(string);
    }

    private IEclipsePreferences getProjectPreferences(IProject iProject, String string, String string2) {
        ProjectScope projectScope = new ProjectScope(iProject);
        IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.eclipse.mtj.core");
        boolean bl = iEclipsePreferences.getBoolean(string, false);
        IEclipsePreferences iEclipsePreferences2 = iEclipsePreferences = bl ? iEclipsePreferences : this.instancePreferences;
        if (iEclipsePreferences.get(string2, null) == null) {
            iEclipsePreferences = this.defaultPreferences;
        }
        return iEclipsePreferences;
    }
}

