/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preprocessor;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.MTJCore;

public class PreprocessedProjectClasspathContainer
implements IClasspathContainer {
    private IProject project;
    private IJavaProject javaProject;

    public PreprocessedProjectClasspathContainer(IJavaProject iJavaProject) {
        this.project = iJavaProject.getProject();
        this.javaProject = iJavaProject;
    }

    public IClasspathEntry[] getClasspathEntries() {
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] iClasspathEntryArray = this.javaProject.getResolvedClasspath(true);
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                if (iClasspathEntryArray[n].getEntryKind() != 3) {
                    arrayList.add(iClasspathEntryArray[n]);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            MTJCore.log(4, coreException.getMessage(), coreException);
        }
        return arrayList.toArray(new IClasspathEntry[arrayList.size()]);
    }

    public String getDescription() {
        return "Preprocessed Project [ " + this.project.getName() + " ]";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.project.getFullPath();
    }
}

