/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletDefinition;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationUtils;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuildInfo;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuilderMessages;
import org.eclipse.mtj.internal.core.build.preverifier.builder.ResourceDeltaBuilder;
import org.eclipse.mtj.internal.core.packaging.midp.DeployedJADWriter;
import org.eclipse.mtj.internal.core.packaging.midp.ObfuscatorTool;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.AbstractClasspathEntryVisitor;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class PreverificationBuilder
extends IncrementalProjectBuilder {
    public static final String ARG_DO_OBFUSCATION = "_do_obfuscation";
    public static final String ARG_DO_PACKAGE = "_do_package";
    public static final String ARG_UPDATE_VERSION = "_update_version";
    private static BuildLoggingConfiguration buildLoggingConfig = BuildLoggingConfiguration.getInstance();
    private static BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    private static Map<IProject, de.schlichtherle.io.File> runtimeJars = new HashMap<IProject, de.schlichtherle.io.File>(5);

    public static void cleanProject(IProject iProject, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
        IFolder iFolder;
        IFolder iFolder2;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_0, (Object)iProject));
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        BuildInfo buildInfo = new BuildInfo(15, new HashMap(), iJavaProject);
        IFolder iFolder3 = iProject.getFolder(MTJCore.getVerifiedOutputDirectoryName());
        if (iFolder3.exists()) {
            Utils.clearContainer((IContainer)iFolder3, iProgressMonitor);
            iFolder3.delete(true, iProgressMonitor);
        }
        if ((iFolder2 = iProject.getFolder(".mtj.tmp").getFolder("runtime")).exists()) {
            Utils.clearContainer((IContainer)iFolder2, iProgressMonitor);
            iFolder2.delete(true, iProgressMonitor);
        }
        IFolder iFolder4 = buildInfo.getVerifiedClassesFolder(iProgressMonitor);
        Utils.clearContainer((IContainer)iFolder4, iProgressMonitor);
        IFolder iFolder5 = buildInfo.getVerifiedLibsFolder(iProgressMonitor);
        Utils.clearContainer((IContainer)iFolder5, iProgressMonitor);
        IFolder iFolder6 = buildInfo.getRuntimeFolder(iProgressMonitor);
        if (iFolder6.exists()) {
            PreverificationBuilder.deleteRuntimeJar(iProject, iProgressMonitor);
            Utils.clearContainer((IContainer)iFolder6, iProgressMonitor);
        }
        if (bl && (iFolder = PreverificationBuilder.getDeploymentFolder(iProject, iProgressMonitor)).exists()) {
            Utils.clearContainer((IContainer)iFolder, iProgressMonitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_1, (Object)iProject));
        }
    }

    public static de.schlichtherle.io.File getRuntimeJar(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        de.schlichtherle.io.File file;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_2, (Object)iProject));
        }
        if ((file = runtimeJars.get(iProject)) == null || !file.exists()) {
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                consoleProxy.traceln(BuilderMessages.PreverificationBuilder_3);
            }
            IFolder iFolder = iProject.getFolder(".mtj.tmp");
            IFolder iFolder2 = iFolder.getFolder("emulation");
            PreverificationBuilder.createFolders(iFolder2, iProgressMonitor);
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
            file = new de.schlichtherle.io.File(iFolder2.getLocation().toFile(), iMidletSuiteProject.getJarFilename());
            file.mkdir();
            iFolder2.refreshLocal(1, iProgressMonitor);
            runtimeJars.put(iProject, file);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_4, (Object)iProject));
        }
        return file;
    }

    private static void deleteRuntimeJar(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        de.schlichtherle.io.File file;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_5, (Object)iProject));
        }
        if ((file = runtimeJars.remove(iProject)) != null && file.exists()) {
            try {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_6, (Object)file));
                }
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                file.deleteAll();
                file.delete();
                IFolder iFolder = iProject.getFolder(".mtj.tmp");
                IFolder iFolder2 = iFolder.getFolder("emulation");
                iFolder2.refreshLocal(1, iProgressMonitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                throw coreException;
            }
            catch (ArchiveException archiveException) {
                archiveException.printStackTrace();
                MTJCore.throwCoreException(4, -999, archiveException);
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_7, (Object)iProject));
        }
    }

    private static IFolder getDeploymentFolder(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        String string;
        IFolder iFolder;
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        String string2 = MTJCore.getDeploymentDirectoryName();
        Path path = new Path(string2);
        IFolder iFolder2 = iProject.getFolder((IPath)path);
        iFolder2.refreshLocal(2, iProgressMonitor);
        if (!iFolder2.exists()) {
            iFolder2.create(false, true, iProgressMonitor);
        }
        if (!(iFolder = iFolder2.getFolder(string = iMidletSuiteProject.getMTJRuntime().getActiveMTJRuntime().getName())).exists()) {
            iFolder.create(false, true, iProgressMonitor);
        }
        return iFolder;
    }

    static void createFolders(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_8, (Object)iFolder));
        }
        while (!iFolder.exists()) {
            if (iFolder.getParent().getType() == 2) {
                PreverificationBuilder.createFolders((IFolder)iFolder.getParent(), iProgressMonitor);
            }
            iFolder.create(true, true, iProgressMonitor);
            iFolder.setDerived(true);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_9, (Object)iFolder));
        }
    }

    static void generateDeployedManifest(IMidletSuiteProject iMidletSuiteProject, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        IMidletDefinition iMidletDefinition2;
        Object object2;
        String[] stringArray;
        IProject iProject = iMidletSuiteProject.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_10, (Object)iProject));
        }
        if (!iMidletSuiteProject.getApplicationDescriptorFile().exists()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_11, (Object)iMidletSuiteProject.getApplicationDescriptorFile().getName()));
            return;
        }
        IApplicationDescriptor iApplicationDescriptor = iMidletSuiteProject.getApplicationDescriptor();
        Properties properties = iApplicationDescriptor.getManifestProperties();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_12);
        }
        String[] object32 = stringArray = PreferenceAccessor.instance.getExcludedManifestProperties(iProject);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object32[n2];
            if (properties.containsKey(object2)) {
                properties.remove(object2);
            }
            ++n2;
        }
        object2 = new Manifest();
        Attributes attributes = ((Manifest)object2).getMainAttributes();
        attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), BuilderMessages.PreverificationBuilder_13);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_14);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            try {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_15, (Object[])new Object[]{entry.getKey(), entry.getValue()}));
                }
                attributes.putValue((String)entry.getKey(), (String)entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_16, (Object)illegalArgumentException));
                }
                Status status = new Status(4, "org.eclipse.mtj.core", -999, NLS.bind((String)BuilderMessages.PreverificationBuilder_17, (Object)illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
                throw new CoreException((IStatus)status);
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_18);
        }
        for (IMidletDefinition iMidletDefinition2 : iApplicationDescriptor.getMidletDefinitions()) {
            object = "MIDlet-" + iMidletDefinition2.getNumber();
            String string = iMidletDefinition2.toString();
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_19, (Object[])new Object[]{object, string}));
            }
            attributes.putValue((String)object, string);
        }
        iMidletDefinition2 = null;
        object = new de.schlichtherle.io.File((File)PreverificationBuilder.getRuntimeJar(iProject, iProgressMonitor), "META-INF/MANIFEST.MF");
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_20, (Object)object));
        }
        try {
            try {
                iMidletDefinition2 = new FileOutputStream((File)object);
                ((Manifest)object2).write((OutputStream)((Object)iMidletDefinition2));
            }
            catch (IOException iOException) {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_21, (Object)iOException));
                }
                Status status = new Status(4, "org.eclipse.mtj.core", -999, NLS.bind((String)BuilderMessages.PreverificationBuilder_22, (Object)iOException.getMessage()), (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (iMidletDefinition2 != null) {
                try {
                    iMidletDefinition2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (iMidletDefinition2 != null) {
            try {
                iMidletDefinition2.close();
            }
            catch (IOException iOException) {}
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_23, (Object)iMidletSuiteProject.getProject()));
        }
    }

    private void clearPreprocessorMarkers() throws CoreException {
        this.getProject().deleteMarkers("org.eclipse.mtj.core.problem", false, 0);
    }

    private void copyRuntimeJarToDeploymentFolder(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        block18: {
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                consoleProxy.traceln(BuilderMessages.PreverificationBuilder_24);
            }
            FileInputStream fileInputStream = null;
            try {
                try {
                    de.schlichtherle.io.File file = PreverificationBuilder.getRuntimeJar(this.getProject(), iProgressMonitor);
                    fileInputStream = new FileInputStream((File)file);
                    IFolder iFolder = this.getDeploymentFolder(buildInfo, iProgressMonitor);
                    IFile iFile = iFolder.getFile(file.getName());
                    if (iFile.exists()) {
                        iFile.setContents((InputStream)fileInputStream, true, false, iProgressMonitor);
                    } else {
                        iFile.create((InputStream)fileInputStream, true, iProgressMonitor);
                    }
                    this.writeJADFile(buildInfo, new de.schlichtherle.io.File(iFile.getLocation().toFile()), iFolder, false, iProgressMonitor);
                }
                catch (IOException iOException) {
                    MTJCore.throwCoreException(4, 999, iOException);
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_25);
        }
    }

    private void createNoPreverifierFoundMarker() throws CoreException {
        final IProject iProject = this.getProject();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iProject.createMarker("org.eclipse.mtj.core.problem");
                iMarker.setAttribute("message", (Object)BuilderMessages.PreverificationBuilder_PreverifierNotFoundErrorMessage);
                iMarker.setAttribute("severity", 2);
            }
        };
        iProject.getWorkspace().run(iWorkspaceRunnable, null);
    }

    private void doObfuscation(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_26);
        }
        final StringBuffer stringBuffer = new StringBuffer();
        de.schlichtherle.io.File file = buildInfo.getRuntimeJarFile(iProgressMonitor);
        consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_27) + file);
        Path path = new Path(file.getAbsolutePath());
        String string = path.lastSegment();
        string = string.substring(0, string.length() - 4);
        IFolder iFolder = this.getDeploymentFolder(buildInfo, iProgressMonitor);
        IFile iFile = iFolder.getFile(String.valueOf(string) + "_obf.jar");
        IFile iFile2 = iFolder.getFile(path.lastSegment());
        consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_29) + iFile.getLocation().toFile());
        ObfuscatorTool obfuscatorTool = new ObfuscatorTool(buildInfo.getMidletSuite(), (File)file, iFile.getLocation().toFile());
        ILaunch iLaunch = obfuscatorTool.launch(iProgressMonitor);
        StringBuffer stringBuffer2 = new StringBuffer();
        IProcess[] iProcessArray = iLaunch.getProcesses();
        if (iProcessArray != null && iProcessArray.length > 0) {
            IProcess iProcess = iProcessArray[0];
            IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
            if (buildLoggingConfig.isObfuscationOutputEnabled()) {
                consoleProxy.traceln(BuilderMessages.PreverificationBuilder_30);
                consoleProxy.addConsoleStreamListener(IBuildConsoleProxy.Stream.ERROR, iStreamsProxy.getErrorStreamMonitor());
                consoleProxy.addConsoleStreamListener(IBuildConsoleProxy.Stream.OUTPUT, iStreamsProxy.getOutputStreamMonitor());
            }
            iStreamsProxy.getErrorStreamMonitor().addListener(new IStreamListener(){

                public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
                    stringBuffer.append(string);
                }
            });
            while (!iProgressMonitor.isCanceled() && !iProcess.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (buildLoggingConfig.isObfuscationOutputEnabled()) {
                consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_31) + iProcess.getExitValue());
            }
            if (stringBuffer2.length() > 0) {
                MTJCore.log(1, stringBuffer2.toString());
            }
            boolean bl = true;
            if (stringBuffer.length() > 0) {
                String string2 = stringBuffer.toString();
                Status status = new Status(4, "org.eclipse.mtj.core", 101, string2, null);
                Boolean bl2 = (Boolean)MTJCore.statusPrompt((IStatus)status, (Object)this);
                boolean bl3 = bl = bl2 != null ? bl2 : false;
            }
            if (bl) {
                this.doPostObfuscationPreverification(buildInfo, iFile, iFile2, iProgressMonitor);
            }
        }
        this.writeJADFile(buildInfo, new de.schlichtherle.io.File(iFile2.getLocation().toFile()), iFolder, false, iProgressMonitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_32);
        }
    }

    private void doPostObfuscationPreverification(BuildInfo buildInfo, IFile iFile, IFile iFile2, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_33);
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_34) + iFile.getLocation().toFile());
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_35) + iFile2.getLocation().toFile());
        }
        try {
            IFolder iFolder = (IFolder)iFile.getParent();
            IFolder iFolder2 = iFolder.getFolder("temp");
            if (!iFolder2.exists()) {
                iFolder2.create(true, true, iProgressMonitor);
            }
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_37) + iFolder2.getLocation().toFile());
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(iFile.getLocation().toFile());
            IPreverificationError[] iPreverificationErrorArray = buildInfo.getMidletSuite().preverifyJarFile((File)file, iFolder2, iProgressMonitor);
            iFolder2.refreshLocal(1, iProgressMonitor);
            if (iPreverificationErrorArray.length > 0) {
                consoleProxy.traceln(String.valueOf(iPreverificationErrorArray.length) + BuilderMessages.PreverificationBuilder_38);
                this.handlePreverificationErrors(iPreverificationErrorArray);
            }
            IFile iFile3 = this.getJarFile(buildInfo, iFolder, false);
            IFile iFile4 = iFolder2.getFile(iFile.getName());
            Utils.copyFile(iFile4, iFile3);
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_39) + iFile4 + BuilderMessages.PreverificationBuilder_40 + iFile3.getLocation().toFile());
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_41) + iFile4.getLocation().toFile());
            iFile4.delete(true, iProgressMonitor);
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_42) + iFolder2.getLocation().toFile());
            iFolder2.delete(true, iProgressMonitor);
        }
        catch (IOException iOException) {
            MTJCore.throwCoreException(4, 999, iOException);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_43);
        }
    }

    private IFolder getDeploymentFolder(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        return PreverificationBuilder.getDeploymentFolder(buildInfo.getMidletSuite().getProject(), iProgressMonitor);
    }

    private IFile getJarFile(BuildInfo buildInfo, IFolder iFolder, boolean bl) {
        String string = buildInfo.getMidletSuite().getJarFilename();
        if (bl) {
            int n = string.length();
            string = String.valueOf(string.substring(0, n - 4)) + "_base.jar";
        }
        return iFolder.getFile(string);
    }

    private IJavaProject[] getRequiredProjects(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        RequiredProjectsCPEntryVisitor requiredProjectsCPEntryVisitor = new RequiredProjectsCPEntryVisitor();
        requiredProjectsCPEntryVisitor.getRunner().run(iJavaProject, requiredProjectsCPEntryVisitor, iProgressMonitor);
        ArrayList<IJavaProject> arrayList = requiredProjectsCPEntryVisitor.getRequiredProjects();
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    private void handlePreverificationErrors(IPreverificationError[] iPreverificationErrorArray) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer(BuilderMessages.PreverificationBuilder_45);
        int n = 0;
        while (n < iPreverificationErrorArray.length) {
            if (n != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(PreverificationUtils.getErrorText(iPreverificationErrorArray[n]));
            ++n;
        }
        MTJCore.throwCoreException(4, -999, stringBuffer.toString());
    }

    private void preverifyLibraries(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        IProject iProject = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_47) + iProject);
        }
        if (iProject != null && iProject.isAccessible()) {
            iProgressMonitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_48) + iProject.getName());
            buildInfo.setCurrentResourceDelta(null);
            if (buildInfo.getBuildKind() != 6) {
                buildInfo.setCurrentResourceDelta(this.getDelta(iProject));
            }
            ResourceDeltaBuilder resourceDeltaBuilder = new ResourceDeltaBuilder(buildInfo);
            resourceDeltaBuilder.preverifyLibraries(iProgressMonitor);
            iProgressMonitor.worked(1);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_49) + iProject);
        }
    }

    private void preverifyProject(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        IProject iProject = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_50) + iProject);
        }
        if (iProject != null && iProject.isAccessible()) {
            iProgressMonitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_51) + iProject.getName());
            buildInfo.setCurrentResourceDelta(null);
            if (buildInfo.getBuildKind() != 6) {
                buildInfo.setCurrentResourceDelta(this.getDelta(iProject));
            }
            ResourceDeltaBuilder resourceDeltaBuilder = new ResourceDeltaBuilder(buildInfo);
            resourceDeltaBuilder.build(iProgressMonitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_52) + iProject);
        }
    }

    private void setResourcesAsDerived(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        iFolder.refreshLocal(2, iProgressMonitor);
        MTJCore.setResourcesAsDerived((IContainer)iFolder);
    }

    private void updateJADVersion(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_53);
        }
        IApplicationDescriptor iApplicationDescriptor = buildInfo.getMidletSuite().getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = (ColonDelimitedProperties)iApplicationDescriptor.getManifestProperties();
        String string = colonDelimitedProperties.getProperty("MIDlet-Version", "0.0.0");
        Version version = new Version(string);
        int n = version.getMajor();
        int n2 = version.getMinor();
        int n3 = version.getMicro();
        if (n3 >= 99) {
            n3 = 0;
            ++n2;
        } else {
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append(".").append(n2).append(".").append(n3);
        colonDelimitedProperties.setProperty("MIDlet-Version", stringBuffer.toString());
        try {
            iApplicationDescriptor.store();
        }
        catch (IOException iOException) {
            MTJCore.throwCoreException(4, 999, iOException);
        }
        PreverificationBuilder.generateDeployedManifest(buildInfo.getMidletSuite(), iProgressMonitor);
        buildInfo.getMidletSuite().getApplicationDescriptorFile().refreshLocal(1, iProgressMonitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_57);
        }
    }

    private void writeJADFile(BuildInfo buildInfo, de.schlichtherle.io.File file, IFolder iFolder, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_58) + file + BuilderMessages.PreverificationBuilder_59 + iFolder);
        }
        DeployedJADWriter deployedJADWriter = new DeployedJADWriter(buildInfo.getMidletSuite(), iFolder, new File(file.getAbsolutePath()));
        try {
            deployedJADWriter.writeDeployedJAD(bl, iProgressMonitor);
        }
        catch (IOException iOException) {
            MTJCore.throwCoreException(4, 999, iOException);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(BuilderMessages.PreverificationBuilder_60);
        }
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl;
        IJavaProject iJavaProject;
        this.clearPreprocessorMarkers();
        IProject iProject = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_61) + iProject);
        }
        IJavaProject iJavaProject2 = iJavaProject = JavaCore.create((IProject)iProject);
        IJavaProject[] iJavaProjectArray = this.getRequiredProjects(iJavaProject2, iProgressMonitor);
        iProgressMonitor.beginTask(BuilderMessages.PreverificationBuilder_62, iJavaProjectArray.length + 1);
        BuildInfo buildInfo = new BuildInfo(n, map, iJavaProject2);
        boolean bl2 = bl = PreferenceAccessor.instance.getAutoversionPackage(iProject) && buildInfo.isBuildArgumentTrue(ARG_UPDATE_VERSION);
        if (bl) {
            this.updateJADVersion(buildInfo, iProgressMonitor);
        } else {
            PreverificationBuilder.generateDeployedManifest(buildInfo.getMidletSuite(), iProgressMonitor);
        }
        try {
            IFolder iFolder;
            this.preverifyProject(buildInfo, iProgressMonitor);
            IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
            int n2 = iJavaProjectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                iFolder = iJavaProjectArray2[n3];
                iJavaProject2 = iFolder;
                if (iJavaProject2 != null) {
                    buildInfo.setCurrentJavaProject(iJavaProject2);
                    this.preverifyProject(buildInfo, iProgressMonitor);
                }
                ++n3;
            }
            if (buildInfo.isClasspathChanged() && buildInfo.areLibrariesPreverified()) {
                iFolder = buildInfo.getVerifiedLibsFolder(iProgressMonitor);
                Utils.clearContainer((IContainer)iFolder, iProgressMonitor);
                buildInfo.setCurrentJavaProject(iJavaProject);
                this.preverifyLibraries(buildInfo, iProgressMonitor);
                IJavaProject[] iJavaProjectArray3 = iJavaProjectArray;
                int n4 = iJavaProjectArray.length;
                n2 = 0;
                while (n2 < n4) {
                    IJavaProject iJavaProject3;
                    iJavaProject2 = iJavaProject3 = iJavaProjectArray3[n2];
                    buildInfo.setCurrentJavaProject(iJavaProject2);
                    this.preverifyLibraries(buildInfo, iProgressMonitor);
                    ++n2;
                }
            }
            iFolder = new IProject[iJavaProjectArray.length];
            int n5 = 0;
            while (n5 < iJavaProjectArray.length) {
                iFolder[n5] = iJavaProjectArray[n5].getProject();
                ++n5;
            }
            if (buildInfo.isPackageDirty()) {
                try {
                    de.schlichtherle.io.File file = buildInfo.getRuntimeJarFile(iProgressMonitor);
                    de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
                catch (ArchiveException archiveException) {
                    MTJCore.throwCoreException(4, -999, archiveException);
                }
            }
            if (buildInfo.isBuildArgumentTrue(ARG_DO_PACKAGE)) {
                buildInfo.setPackageDirty(true);
                if (buildInfo.isBuildArgumentTrue(ARG_DO_OBFUSCATION)) {
                    this.doObfuscation(buildInfo, iProgressMonitor);
                } else {
                    this.copyRuntimeJarToDeploymentFolder(buildInfo, iProgressMonitor);
                }
            }
            if (buildInfo.isPackageDirty()) {
                PreverificationBuilder.generateDeployedManifest(buildInfo.getMidletSuite(), iProgressMonitor);
                IFolder iFolder2 = PreverificationBuilder.getDeploymentFolder(iProject, iProgressMonitor);
                iFolder2.refreshLocal(2, iProgressMonitor);
                this.setResourcesAsDerived(buildInfo.getVerifiedClassesFolder(iProgressMonitor), iProgressMonitor);
                this.setResourcesAsDerived(buildInfo.getVerifiedLibsFolder(iProgressMonitor), iProgressMonitor);
                this.setResourcesAsDerived(buildInfo.getRuntimeFolder(iProgressMonitor), iProgressMonitor);
            }
            try {
                de.schlichtherle.io.File file = buildInfo.getRuntimeJarFile(iProgressMonitor);
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                this.writeJADFile(buildInfo, file, buildInfo.getRuntimeFolder(iProgressMonitor), true, iProgressMonitor);
                this.getProject().getFolder(".mtj.tmp").refreshLocal(2, iProgressMonitor);
            }
            catch (ArchiveException archiveException) {
                MTJCore.throwCoreException(4, -999, archiveException);
            }
            iProgressMonitor.done();
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_63) + iProject);
            }
            return iFolder;
        }
        catch (PreverifierNotFoundException preverifierNotFoundException) {
            this.createNoPreverifierFoundMarker();
            return null;
        }
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_64) + iProject);
        }
        super.clean(iProgressMonitor);
        PreverificationBuilder.cleanProject(iProject, false, iProgressMonitor);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(JavaCore.create((IProject)this.getProject()));
        PreverificationBuilder.generateDeployedManifest(iMidletSuiteProject, iProgressMonitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_65) + iProject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredProjectsCPEntryVisitor
    extends AbstractClasspathEntryVisitor {
        private ArrayList<IJavaProject> requiredProjects = new ArrayList();

        private RequiredProjectsCPEntryVisitor() {
        }

        public ArrayList<IJavaProject> getRequiredProjects() {
            return this.requiredProjects;
        }

        @Override
        public boolean visitProject(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IJavaProject iJavaProject2, IProgressMonitor iProgressMonitor) throws CoreException {
            boolean bl = iClasspathEntry.isExported();
            if (bl) {
                this.requiredProjects.add(iJavaProject2);
            }
            return bl;
        }
    }
}

