/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.classpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.externallibrary.classpath.ExternalLibraryClasspathContainer;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;

public class ExternalLibraryClasspathContainerInitializer
extends ClasspathContainerInitializer {
    String description = null;

    public boolean canUpdateClasspathContainer(IPath iPath, IJavaProject iJavaProject) {
        return false;
    }

    public Object getComparisonID(IPath iPath, IJavaProject iJavaProject) {
        if (iPath == null) {
            return null;
        }
        return iPath.toString();
    }

    public String getDescription(IPath iPath, IJavaProject iJavaProject) {
        if (this.description != null) {
            return this.description;
        }
        return super.getDescription(iPath, iJavaProject);
    }

    public void initialize(IPath iPath, IJavaProject iJavaProject) throws CoreException {
        if (this.isMidletLibraryContainer(iPath)) {
            String string = iPath.segment(1);
            IExternalLibrary iExternalLibrary = ExternalLibraryManager.getInstance().getMidletLibrary(string);
            if (iExternalLibrary != null) {
                ExternalLibraryClasspathContainer externalLibraryClasspathContainer = new ExternalLibraryClasspathContainer(iExternalLibrary);
                this.description = String.valueOf(string) + " [" + iExternalLibrary.getVersion().toString() + "]";
                JavaCore.setClasspathContainer((IPath)iPath, (IJavaProject[])new IJavaProject[]{iJavaProject}, (IClasspathContainer[])new IClasspathContainer[]{externalLibraryClasspathContainer}, null);
            } else {
                MTJCore.log(4, "Could not load " + iPath.toString(), null);
            }
        }
    }

    private boolean isMidletLibraryContainer(IPath iPath) {
        return iPath != null && iPath.segmentCount() == 2 && "org.eclipse.mtj.core.EXTERNAL_LIBRARY".equals(iPath.segment(0));
    }
}

