/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.launching.midp.EmulatorRunner;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDevice;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

public class EmulatorLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final String DEVICE_COMMAND = "-Xdevice:";
    private static final String LIST_INSTALLED_MIDLET_COMMAND = "-Xjam:list";
    private static final IStatus NO_MIDLET_STATUS = new Status(4, "org.eclipse.mtj.core", 100, "", null);
    private static final String REMOVE_INSTALLED_MIDLET_COMMAND = "-Xjam:remove=";

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        IDevice iDevice;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if ((iDevice = this.getDevice(iLaunchConfiguration)) == null) {
            MTJCore.throwCoreException(4, -999, "Device is unspecified or unavailable");
        }
        iProgressMonitor.beginTask(NLS.bind((String)Messages.launchdelegate_launching, (Object[])new Object[]{iLaunchConfiguration.getName()}), 3);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        iProgressMonitor.subTask(Messages.launchdelegate_verifying_attrs);
        IVMRunner iVMRunner = this.getVMRunner(iLaunchConfiguration, iDevice, string);
        VMRunnerConfiguration vMRunnerConfiguration = this.getVMRunnerConfiguration(iLaunchConfiguration, iDevice, string);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.subTask(Messages.launchdelegate_source_locator);
        this.setDefaultSourceLocator(iLaunch, iLaunchConfiguration);
        iProgressMonitor.worked(1);
        ((EmulatorRunner)iVMRunner).run(vMRunnerConfiguration, iLaunchConfiguration, iLaunch, iProgressMonitor);
        if (!iProgressMonitor.isCanceled()) {
            iProgressMonitor.done();
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = super.preLaunchCheck(iLaunchConfiguration, string, iProgressMonitor);
        if (bl) {
            bl = this.verifyEmulationSettings(iLaunchConfiguration, string, iProgressMonitor);
        }
        return bl;
    }

    private void checkAndRemoveInstalledMidlet(IApplicationDescriptor iApplicationDescriptor, IMIDPDevice iMIDPDevice) throws CoreException {
        if (!(iMIDPDevice instanceof JavaEmulatorDevice)) {
            String string = iApplicationDescriptor.getManifestProperties().getProperty("MIDlet-Name");
            String string2 = iApplicationDescriptor.getManifestProperties().getProperty("MIDlet-Vendor");
            AbstractMIDPDevice abstractMIDPDevice = (AbstractMIDPDevice)iMIDPDevice;
            File file = abstractMIDPDevice.getExecutable();
            String[] stringArray = new String[]{DEVICE_COMMAND + abstractMIDPDevice.getName(), LIST_INSTALLED_MIDLET_COMMAND};
            String[] stringArray2 = this.populateCommandLine(file, stringArray);
            File file2 = file.getParentFile();
            String string3 = Utils.getStandardOutput("get installed MIDlet Suite", stringArray2, file2);
            String string4 = "\\[\\d+\\]";
            String[] stringArray3 = string3.split(string4);
            int n = 0;
            boolean bl = false;
            int n2 = 1;
            while (n2 < stringArray3.length) {
                String string5 = stringArray3[n2];
                if (string5.trim().length() > 0) {
                    ++n;
                    ColonDelimitedProperties colonDelimitedProperties = this.parseMidetSuiteInfo(string5);
                    String string6 = colonDelimitedProperties.getProperty("Name");
                    String string7 = colonDelimitedProperties.getProperty("Vendor");
                    if (string.equals(string6) && string2.equals(string7)) {
                        bl = true;
                        break;
                    }
                }
                ++n2;
            }
            if (bl) {
                stringArray = new String[]{DEVICE_COMMAND + abstractMIDPDevice.getName(), REMOVE_INSTALLED_MIDLET_COMMAND + n};
                stringArray2 = this.populateCommandLine(file, stringArray);
                Utils.getStandardOutput("remove MIDlet Suite", stringArray2, file2);
            }
        }
    }

    private IDevice getDevice(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IDevice iDevice = null;
        if (iLaunchConfiguration.getAttribute("mtj.use_project_device", true)) {
            iDevice = this.getMidletSuite(iLaunchConfiguration).getMTJRuntime().getActiveMTJRuntime().getDevice();
        } else {
            String string = iLaunchConfiguration.getAttribute("mtj.emulated_device_group", "");
            String string2 = iLaunchConfiguration.getAttribute("mtj.emulated_device", "");
            try {
                iDevice = MTJCore.getDeviceRegistry().getDevice(string, string2);
            }
            catch (PersistenceException persistenceException) {
                MTJCore.throwCoreException(4, -999, persistenceException);
            }
        }
        return iDevice;
    }

    private IMidletSuiteProject getMidletSuite(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IJavaProject iJavaProject = this.getJavaProject(iLaunchConfiguration);
        return MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
    }

    private ColonDelimitedProperties parseMidetSuiteInfo(String string) {
        ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
        StringReader stringReader = new StringReader(string);
        try {
            colonDelimitedProperties.load(stringReader);
        }
        catch (Exception exception) {
            MTJCore.log(2, "Error parsing installed apps", exception);
            MTJCore.log(2, string);
        }
        return colonDelimitedProperties;
    }

    private String[] populateCommandLine(File file, String[] stringArray) {
        boolean bl = Platform.getOS().equals("win32");
        String string = bl ? file.getName() : file.getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>((Collection)Arrays.asList(stringArray));
        arrayList.add(0, string);
        if (bl) {
            arrayList.add(0, "/c");
            arrayList.add(0, "cmd");
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        return stringArray2;
    }

    private boolean promptWhetherToContinue(IStatus iStatus) throws CoreException {
        Boolean bl = (Boolean)MTJCore.statusPrompt(iStatus, (Object)this);
        return bl != null ? bl : false;
    }

    private boolean verifyEmulationSettings(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IMidletSuiteProject iMidletSuiteProject;
        IApplicationDescriptor iApplicationDescriptor;
        IJavaProject iJavaProject;
        Status status;
        boolean bl = true;
        if ("debug".equals(string) && !(bl = this.promptWhetherToContinue((IStatus)(status = new Status(1, "org.eclipse.mtj.core", 104, "", null))))) {
            return bl;
        }
        boolean bl2 = iLaunchConfiguration.getAttribute("mtj.do_ota", false);
        if (bl2 && (iJavaProject = this.getJavaProject(iLaunchConfiguration)) != null && (iApplicationDescriptor = (iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject)).getApplicationDescriptor()) != null) {
            boolean bl3 = bl = iApplicationDescriptor.getMidletCount() > 0;
            if (!bl && !(bl = this.promptWhetherToContinue(NO_MIDLET_STATUS))) {
                return bl;
            }
            this.checkAndRemoveInstalledMidlet(iApplicationDescriptor, (IMIDPDevice)iMidletSuiteProject.getMTJRuntime().getActiveMTJRuntime().getDevice());
        }
        return bl;
    }

    protected IVMRunner getVMRunner(ILaunchConfiguration iLaunchConfiguration, IDevice iDevice, String string) throws CoreException {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuite(iLaunchConfiguration);
        return new EmulatorRunner(iMidletSuiteProject, iDevice, string);
    }

    protected VMRunnerConfiguration getVMRunnerConfiguration(ILaunchConfiguration iLaunchConfiguration, IDevice iDevice, String string) throws CoreException {
        File file = this.verifyWorkingDirectory(iLaunchConfiguration);
        String string2 = null;
        if (file != null) {
            string2 = file.getAbsolutePath();
        }
        VMRunnerConfiguration vMRunnerConfiguration = new VMRunnerConfiguration(iDevice.getName(), new String[0]);
        vMRunnerConfiguration.setVMArguments(new String[0]);
        vMRunnerConfiguration.setWorkingDirectory(string2);
        vMRunnerConfiguration.setVMSpecificAttributesMap(new HashMap());
        return vMRunnerConfiguration;
    }
}

