/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp.ota;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.Utils;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTAHandler
extends AbstractHttpHandler {
    private static final String[] KNOWN_MIME_TYPES = new String[]{"jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive"};
    private static Map<String, String> mimeTypeMap;
    private static final long serialVersionUID = 1L;

    private static Map<String, String> getMimeTypeMap() {
        if (mimeTypeMap == null) {
            mimeTypeMap = new HashMap<String, String>();
            int n = 0;
            while (n < KNOWN_MIME_TYPES.length) {
                mimeTypeMap.put(KNOWN_MIME_TYPES[n++], KNOWN_MIME_TYPES[n++]);
            }
        }
        return mimeTypeMap;
    }

    public String getName() {
        return "MTJ Over the Air Handler";
    }

    public void handle(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (string3 != null && string4 != null) {
            try {
                this.handle(string3, string4, string2, httpRequest, httpResponse);
            }
            catch (CoreException coreException) {
                throw new IOException(coreException.getMessage());
            }
        }
    }

    private String getContentEncoding(IFile iFile) {
        return iFile.getFileExtension().equals("jad") ? "UTF-8" : null;
    }

    private String getContentType(IFile iFile) {
        String string = OTAHandler.getMimeTypeMap().get(iFile.getFileExtension());
        return string != null ? string : "application/octet-stream";
    }

    private IJavaProject getJavaProject(String string) {
        IJavaProject iJavaProject = null;
        IWorkspaceRoot iWorkspaceRoot = MTJCore.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject != null) {
            iJavaProject = JavaCore.create((IProject)iProject);
        }
        return iJavaProject;
    }

    private void handle(IJavaProject iJavaProject, String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws CoreException, IOException {
        IFile iFile;
        String string3 = MTJCore.getDeploymentDirectoryName();
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        string3 = String.valueOf(string3) + File.separator + iMidletSuiteProject.getMTJRuntime().getActiveMTJRuntime().getName();
        IFolder iFolder = iJavaProject.getProject().getFolder(string3);
        if (iFolder.exists() && (iFile = iFolder.getFile(string)).exists()) {
            this.sendFile(iFile, httpResponse);
        }
    }

    private void handle(String string, String string2, String string3, HttpRequest httpRequest, HttpResponse httpResponse) throws CoreException, IOException {
        IJavaProject iJavaProject = this.getJavaProject(string);
        if (iJavaProject != null) {
            this.handle(iJavaProject, string2, string3, httpRequest, httpResponse);
        }
    }

    private void sendFile(IFile iFile, HttpResponse httpResponse) throws CoreException, IOException {
        String string = this.getContentType(iFile);
        String string2 = this.getContentEncoding(iFile);
        File file = iFile.getLocation().toFile();
        httpResponse.setCharacterEncoding(string2, true);
        httpResponse.setContentType(string);
        httpResponse.setContentLength((int)file.length());
        InputStream inputStream = iFile.getContents();
        OutputStream outputStream = httpResponse.getOutputStream();
        Utils.copyInputToOutput(inputStream, outputStream);
        outputStream.close();
        inputStream.close();
        httpResponse.commit();
    }
}

