/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.packaging.midp;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.sign.SignatureUtils;
import org.eclipse.mtj.internal.core.project.midp.IJadSignature;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;

public class DeployedJADWriter {
    private IMidletSuiteProject midletSuite;
    private IFolder deploymentFolder;
    private File deployedJarFile;

    public DeployedJADWriter(IMidletSuiteProject iMidletSuiteProject, IFolder iFolder, File file) {
        this.midletSuite = iMidletSuiteProject;
        this.deploymentFolder = iFolder;
        this.deployedJarFile = file;
    }

    public void writeDeployedJAD(boolean bl, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        IJadSignature iJadSignature;
        IApplicationDescriptor iApplicationDescriptor = this.midletSuite.getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = (ColonDelimitedProperties)iApplicationDescriptor.getManifestProperties();
        colonDelimitedProperties.setProperty("MIDlet-Jar-Size", Long.valueOf(this.deployedJarFile.length()).toString());
        if (bl) {
            colonDelimitedProperties.setProperty("MIDlet-Jar-URL", this.deployedJarFile.getName());
        }
        this.writeJad(iApplicationDescriptor);
        if (!bl && (iJadSignature = SignatureUtils.getSignatureObject(this.midletSuite)) != null) {
            this.signJad(iJadSignature, this.deployedJarFile, colonDelimitedProperties);
            this.writeJad(iApplicationDescriptor);
        }
    }

    private void signJad(IJadSignature iJadSignature, File file, ColonDelimitedProperties colonDelimitedProperties) throws CoreException {
        iJadSignature.computeSignature(file);
        colonDelimitedProperties.setProperty("MIDlet-Jar-RSA-SHA1", iJadSignature.getJarSignatureString());
        String[] stringArray = iJadSignature.getCertificateStrings();
        int n = 1;
        while (n <= stringArray.length) {
            colonDelimitedProperties.setProperty("MIDlet-Certificate-1-" + n, stringArray[n - 1]);
            ++n;
        }
    }

    private void writeJad(IApplicationDescriptor iApplicationDescriptor) throws IOException {
        IFile iFile = this.deploymentFolder.getFile(this.midletSuite.getJadFileName());
        iApplicationDescriptor.store(iFile.getLocation().toFile());
    }
}

