/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IBundleReferencePersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.api.APIType;
import org.eclipse.mtj.internal.core.build.preverifier.builder.PreverificationBuilder;
import org.eclipse.mtj.internal.core.launching.midp.LaunchingUtils;
import org.eclipse.mtj.internal.core.launching.midp.ota.OTAServer;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMIDPDevice
implements IMIDPDevice,
IBundleReferencePersistable {
    protected String bundle;
    protected IDeviceClasspath deviceClasspath;
    protected boolean debugServer;
    protected String description;
    protected Properties deviceProperties;
    protected File executable;
    protected String groupName;
    protected String launchCommandTemplate;
    protected String name;
    protected IPreverifier preverifier;
    protected String[] protectionDomains;

    public boolean equals(AbstractMIDPDevice abstractMIDPDevice) {
        return this.deviceClasspath.equals(abstractMIDPDevice.deviceClasspath) && this.executable.equals(abstractMIDPDevice.executable) && this.name.equals(abstractMIDPDevice.name) && this.groupName.equals(abstractMIDPDevice.groupName);
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public IDeviceClasspath getClasspath() {
        return this.deviceClasspath;
    }

    @Override
    public ILibrary getConfigurationLibrary() {
        return this.getLibraryWithType(APIType.CONFIGURATION);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Properties getDeviceProperties() {
        return this.deviceProperties;
    }

    public File getExecutable() {
        return this.executable;
    }

    @Override
    public String getSDKName() {
        return this.groupName;
    }

    public String getLaunchCommandTemplate() {
        return this.launchCommandTemplate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPreverifier getPreverifier() {
        return this.preverifier;
    }

    @Override
    public ILibrary getProfileLibrary() {
        return this.getLibraryWithType(APIType.PROFILE);
    }

    @Override
    public String[] getProtectionDomains() {
        return this.protectionDomains;
    }

    @Override
    public boolean isDebugServer() {
        return this.debugServer;
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.deviceClasspath = (DeviceClasspath)iPersistenceProvider.loadPersistable("classpath");
        this.debugServer = iPersistenceProvider.loadBoolean("debugServer");
        this.description = iPersistenceProvider.loadString("description");
        this.deviceProperties = iPersistenceProvider.loadProperties("deviceProperties");
        this.name = iPersistenceProvider.loadString("name");
        this.protectionDomains = new String[iPersistenceProvider.loadInteger("protectionDomainsCount")];
        int n = 0;
        while (n < this.protectionDomains.length) {
            this.protectionDomains[n] = iPersistenceProvider.loadString("protectionDomain" + n).trim();
            ++n;
        }
        this.groupName = iPersistenceProvider.loadString("groupName");
        this.preverifier = (IPreverifier)iPersistenceProvider.loadPersistable("preverifier");
        this.launchCommandTemplate = iPersistenceProvider.loadString("rawLaunchCommand");
        String string = iPersistenceProvider.loadString("executable");
        if (string != null && string.trim().length() > 0) {
            this.executable = new File(string);
        }
    }

    @Override
    public void setBundle(String string) {
        this.bundle = string;
    }

    public void setClasspath(IDeviceClasspath iDeviceClasspath) {
        this.deviceClasspath = iDeviceClasspath;
    }

    public void setDebugServer(boolean bl) {
        this.debugServer = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDeviceProperties(Properties properties) {
        this.deviceProperties = properties;
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setLaunchCommandTemplate(String string) {
        this.launchCommandTemplate = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setPreverifier(IPreverifier iPreverifier) {
        this.preverifier = iPreverifier;
    }

    public void setProtectionDomains(String[] stringArray) {
        this.protectionDomains = stringArray;
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].trim();
            ++n;
        }
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storePersistable("classpath", this.deviceClasspath);
        iPersistenceProvider.storeBoolean("debugServer", this.debugServer);
        iPersistenceProvider.storeString("description", this.description);
        iPersistenceProvider.storeProperties("deviceProperties", this.deviceProperties);
        iPersistenceProvider.storeString("name", this.name);
        iPersistenceProvider.storeInteger("protectionDomainsCount", this.protectionDomains.length);
        int n = 0;
        while (n < this.protectionDomains.length) {
            iPersistenceProvider.storeString("protectionDomain" + n, this.protectionDomains[n]);
            ++n;
        }
        iPersistenceProvider.storeString("groupName", this.groupName);
        iPersistenceProvider.storePersistable("preverifier", this.preverifier);
        iPersistenceProvider.storeString("rawLaunchCommand", this.launchCommandTemplate);
        if (this.executable != null) {
            iPersistenceProvider.storeString("executable", this.executable.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getSDKName());
        stringBuffer.append("/").append(this.getName());
        return stringBuffer.toString();
    }

    private ILibrary getLibraryWithType(APIType aPIType) {
        ILibrary[] iLibraryArray;
        ILibrary iLibrary = null;
        IDeviceClasspath iDeviceClasspath = this.getClasspath();
        ILibrary[] iLibraryArray2 = iLibraryArray = iDeviceClasspath.getEntries();
        int n = iLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILibrary iLibrary2 = iLibraryArray2[n2];
            if (iLibrary2.getAPI(aPIType) != null) {
                iLibrary = iLibrary2;
                break;
            }
            ++n2;
        }
        return iLibrary;
    }

    protected void addLaunchConfigurationValue(Map<String, String> map, String string, ILaunchConfiguration iLaunchConfiguration, String string2) throws CoreException {
        String string3 = iLaunchConfiguration.getAttribute(string2, null);
        if (string3 != null) {
            map.put(string, string3);
        }
    }

    protected File copyForLaunch(IMidletSuiteProject iMidletSuiteProject, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        try {
            if (bl) {
                IFolder iFolder = LaunchingUtils.getEmulationFolder(iMidletSuiteProject);
                File file = LaunchingUtils.makeJadLaunchBaseDir(iMidletSuiteProject);
                File file2 = iFolder.getFile(iMidletSuiteProject.getJadFileName()).getLocation().toFile();
                File file3 = iFolder.getFile(iMidletSuiteProject.getJarFilename()).getLocation().toFile();
                File file4 = new File(file, iMidletSuiteProject.getJadFileName());
                File file5 = new File(file, iMidletSuiteProject.getJarFilename());
                Utils.copyFile(file2, file4, null);
                Utils.copyFile(file3, file5, null);
                LaunchingUtils.getProjectTempFolder(iMidletSuiteProject).refreshLocal(2, iProgressMonitor);
                return file;
            }
            File file = null;
            IFolder iFolder = LaunchingUtils.getEmulationFolder(iMidletSuiteProject);
            File file6 = iFolder.getLocation().toFile();
            String string = iMidletSuiteProject.getProject().getName().replace(' ', '_');
            file = TemporaryFileManager.instance.createTempDirectory(string, ".launch");
            Utils.copyDirectory(file6, file, null);
            return file;
        }
        catch (IOException iOException) {
            MTJCore.throwCoreException(4, -999, iOException);
            return null;
        }
    }

    protected File getJadForLaunch(IMidletSuiteProject iMidletSuiteProject, File file, IProgressMonitor iProgressMonitor) {
        return new File(file, iMidletSuiteProject.getJadFileName());
    }

    protected String getOTAURL(ILaunchConfiguration iLaunchConfiguration, IMidletSuiteProject iMidletSuiteProject) throws CoreException {
        try {
            OTAServer.getInstance().start();
        }
        catch (Exception exception) {
            MTJCore.log(2, "Failed to launch OTA Server", exception);
        }
        String string = iMidletSuiteProject.getProject().getName();
        String string2 = iMidletSuiteProject.getJadFileName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://localhost:").append(OTAServer.getPort()).append("/ota/").append(this.urlEncoded(string)).append('/').append(this.urlEncoded(string2));
        return stringBuffer.toString();
    }

    protected String getProjectClasspathString(IMTJProject iMTJProject, File file, IProgressMonitor iProgressMonitor) throws CoreException {
        de.schlichtherle.io.File file2 = PreverificationBuilder.getRuntimeJar(iMTJProject.getProject(), iProgressMonitor);
        return new File(file, file2.getName()).getAbsolutePath();
    }

    protected String getSpecifiedJadURL(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("mtj.specified_jad_url", null);
    }

    protected boolean shouldDirectLaunchJAD(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("mtj.do_jad_launch", false);
    }

    protected boolean shouldDoOTA(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("mtj.do_ota", true);
    }

    protected String urlEncoded(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return string2;
    }
}

