/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;

public class DeviceClasspath
implements IDeviceClasspath {
    private ArrayList<IPersistable> entries = new ArrayList();

    public void addEntry(ILibrary iLibrary) {
        this.entries.add(iLibrary);
    }

    public IClasspathEntry[] asClasspathEntries() {
        ILibrary[] iLibraryArray = this.getEntries();
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[iLibraryArray.length];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            iClasspathEntryArray[n] = iLibraryArray[n].toClasspathEntry();
            ++n;
        }
        return iClasspathEntryArray;
    }

    public File[] asFileArray() {
        ILibrary[] iLibraryArray = this.getEntries();
        File[] fileArray = new File[iLibraryArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n] = iLibraryArray[n].toFile();
            ++n;
        }
        return fileArray;
    }

    public URL[] asURLArray() {
        ILibrary[] iLibraryArray = this.getEntries();
        URL[] uRLArray = new URL[iLibraryArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            uRLArray[n] = iLibraryArray[n].toURL();
            ++n;
        }
        return uRLArray;
    }

    public boolean equals(IDeviceClasspath iDeviceClasspath) {
        ILibrary[] iLibraryArray;
        ILibrary[] iLibraryArray2 = this.getEntries();
        boolean bl = iLibraryArray2.length == (iLibraryArray = iDeviceClasspath.getEntries()).length;
        int n = 0;
        while (bl && n < iLibraryArray2.length) {
            bl = iLibraryArray2[n].equals(iLibraryArray[n]);
            ++n;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DeviceClasspath) {
            bl = this.equals((IDeviceClasspath)object);
        }
        return bl;
    }

    public ILibrary[] getEntries() {
        return this.entries.toArray(new ILibrary[this.entries.size()]);
    }

    public int hashCode() {
        ILibrary[] iLibraryArray = this.getEntries();
        int n = iLibraryArray.length << 24;
        ILibrary[] iLibraryArray2 = iLibraryArray;
        int n2 = iLibraryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ILibrary iLibrary = iLibraryArray2[n3];
            n ^= iLibrary.hashCode();
            ++n3;
        }
        return n;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.entries.clear();
        int n = iPersistenceProvider.loadInteger("entryCount");
        int n2 = 0;
        while (n2 < n) {
            this.entries.add(iPersistenceProvider.loadPersistable("entry" + n2));
            ++n2;
        }
    }

    public void removeEntry(ILibrary iLibrary) {
        this.entries.remove(iLibrary);
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeInteger("entryCount", this.entries.size());
        int n = 0;
        for (ILibrary iLibrary : this.entries) {
            iPersistenceProvider.storePersistable("entry" + n++, iLibrary);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        ILibrary[] iLibraryArray = this.getEntries();
        int n = 0;
        while (n < iLibraryArray.length) {
            if (n != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iLibraryArray[n].toFile());
            ++n;
        }
        return stringBuffer.toString();
    }
}

