/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceFinder;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.sdk.device.DeviceImporterElement;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceFinder
implements IDeviceFinder {
    private static Map<String, IDeviceImporter> deviceImportersMap;
    private static DeviceFinder finder;

    static {
        finder = null;
    }

    public static synchronized IDeviceFinder getInstance() {
        if (finder == null) {
            finder = new DeviceFinder();
        }
        return finder;
    }

    private DeviceFinder() {
        deviceImportersMap = Collections.synchronizedMap(new HashMap());
        try {
            this.readDeviceImporters();
        }
        catch (CoreException coreException) {
            MTJCore.log(4, Messages.DeviceFinder_0, coreException);
        }
    }

    @Override
    public synchronized List<IDevice> findDevices(File file, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        try {
            iProgressMonitor.beginTask(Messages.DeviceFinder_1, -1);
            Iterator<Map.Entry<String, IDeviceImporter>> iterator = deviceImportersMap.entrySet().iterator();
            while (iterator.hasNext()) {
                List<IDevice> list = this.searchDevicesInDirectory(file, iterator.next().getValue(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (list == null) continue;
                arrayList.addAll(list);
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return arrayList;
    }

    @Override
    public synchronized List<IDevice> findDevices(String string, File file, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        try {
            List<IDevice> list;
            IDeviceImporter iDeviceImporter;
            iProgressMonitor.beginTask(Messages.DeviceFinder_1, -1);
            if (string != null && (iDeviceImporter = deviceImportersMap.get(string)) != null && (list = this.searchDevicesInDirectory(file, iDeviceImporter, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1))) != null) {
                arrayList.addAll(list);
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return arrayList;
    }

    private void readDeviceImporters() throws CoreException {
        IExtensionRegistry iExtensionRegistry;
        IConfigurationElement[] iConfigurationElementArray;
        String string;
        if (deviceImportersMap != null && (string = MTJCore.getDefault().getBundle().getSymbolicName()) != null && (iConfigurationElementArray = (iExtensionRegistry = Platform.getExtensionRegistry()).getConfigurationElementsFor(string, "deviceimporter")).length >= 0) {
            DeviceImporterElement[] deviceImporterElementArray = new DeviceImporterElement[iConfigurationElementArray.length];
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                deviceImporterElementArray[n] = new DeviceImporterElement(iConfigurationElementArray[n]);
                ++n;
            }
            Arrays.sort(deviceImporterElementArray, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    DeviceImporterElement deviceImporterElement = (DeviceImporterElement)object;
                    DeviceImporterElement deviceImporterElement2 = (DeviceImporterElement)object2;
                    return deviceImporterElement.getPriority() - deviceImporterElement2.getPriority();
                }
            });
            n = 0;
            while (n < deviceImporterElementArray.length) {
                deviceImportersMap.put(deviceImporterElementArray[n].getId(), deviceImporterElementArray[n].getDeviceImporter());
                ++n;
            }
        }
    }

    private List<IDevice> searchDevicesInDirectory(File file, IDeviceImporter iDeviceImporter, IProgressMonitor iProgressMonitor) throws InterruptedException, CoreException {
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        ArrayList<IDevice> arrayList = null;
        try {
            if (file.canRead()) {
                File[] fileArray;
                arrayList = new ArrayList<IDevice>();
                iProgressMonitor.setTaskName(NLS.bind((String)Messages.DeviceFinder_2, (Object)file));
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                List<IDevice> list = iDeviceImporter.importDevices(file, (IProgressMonitor)subProgressMonitor);
                if (list != null) {
                    arrayList.addAll(list);
                }
                if ((fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                })) != null) {
                    File[] fileArray2 = fileArray;
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file2 = fileArray2[n2];
                        List<IDevice> list2 = this.searchDevicesInDirectory(file2, iDeviceImporter, iProgressMonitor);
                        if (list2 != null) {
                            arrayList.addAll(list2);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            MTJCore.log(4, NLS.bind((String)Messages.DeviceFinder_3, (Object)file.getPath()), securityException);
        }
        iProgressMonitor.worked(1);
        return arrayList;
    }
}

