/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp.library;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.mtj.core.sdk.device.midp.library.api.API;
import org.eclipse.mtj.core.sdk.device.midp.library.api.APIType;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.APIManifestAttributes;
import org.osgi.framework.Version;

public class APIRegistry {
    public static API[] getAPIs(File file) {
        Object object;
        HashMap<String, Object> hashMap;
        block16: {
            hashMap = new HashMap<String, Object>();
            JarFile jarFile = null;
            try {
                try {
                    jarFile = new JarFile(file);
                    if (jarFile != null && (object = APIRegistry.createAPIFromManifest(jarFile)) != null) {
                        hashMap.put(((API)object).getIdentifier(), object);
                    }
                }
                catch (IOException iOException) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (hashMap.size() == 0) {
            object = APIRegistry.createUnknownAPI(file);
            hashMap.put(((API)object).getIdentifier(), object);
        }
        object = hashMap.values();
        return object.toArray(new API[object.size()]);
    }

    private static API createAPIFromManifest(JarFile jarFile) throws IOException {
        Attributes attributes;
        String string;
        API aPI = null;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (string = (attributes = manifest.getMainAttributes()).getValue(APIManifestAttributes.API.toString())) != null) {
            aPI = new API();
            aPI.setIdentifier(string);
            aPI.setName(attributes.getValue(APIManifestAttributes.API_NAME.toString()));
            aPI.setType(APIRegistry.getTypeFromManifest(attributes));
            aPI.setVersion(APIRegistry.getVersionFromManifest(attributes));
        }
        return aPI;
    }

    private static API createUnknownAPI(File file) {
        API aPI = new API();
        aPI.setIdentifier(file.getName());
        aPI.setName("Unknown Library");
        aPI.setType(APIType.UNKNOWN);
        aPI.setVersion(new Version("1.0"));
        return aPI;
    }

    private static APIType getTypeFromManifest(Attributes attributes) {
        APIType aPIType = APIType.UNKNOWN;
        String string = attributes.getValue(APIManifestAttributes.API_TYPE.toString());
        if (string == null || string.equalsIgnoreCase(APIType.OPTIONAL.toString())) {
            aPIType = APIType.OPTIONAL;
        } else if (string.equalsIgnoreCase(APIType.PROFILE.toString())) {
            aPIType = APIType.PROFILE;
        } else if (string.equalsIgnoreCase(APIType.CONFIGURATION.toString())) {
            aPIType = APIType.CONFIGURATION;
        }
        return aPIType;
    }

    private static Version getVersionFromManifest(Attributes attributes) {
        Version version = null;
        String string = attributes.getValue(APIManifestAttributes.API_VERSION.toString());
        version = string != null ? new Version(string) : new Version("0.0.0");
        return version;
    }

    private APIRegistry() {
    }
}

