/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp.library;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.api.API;
import org.eclipse.mtj.core.sdk.device.midp.library.api.APIType;

public class Library
implements ILibrary {
    private static IAccessRule[] NO_ACCESS_RULES = new IAccessRule[0];
    private API[] apis;
    private URL javadocURL;
    private File libraryFile;
    private IPath sourceAttachmentPath;
    private IPath sourceAttachmentRootPath;
    private IAccessRule[] accessRules;

    public Library() {
        this.accessRules = NO_ACCESS_RULES;
    }

    public Library(API[] aPIArray, URL uRL, File file, IPath iPath, IPath iPath2, IAccessRule[] iAccessRuleArray) {
        this.apis = aPIArray;
        this.javadocURL = uRL;
        this.libraryFile = file;
        this.sourceAttachmentPath = iPath;
        this.sourceAttachmentRootPath = iPath2;
        this.accessRules = iAccessRuleArray;
    }

    public boolean equals(Library library) {
        return this.libraryFile.equals(library.libraryFile);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Library) {
            bl = this.equals((Library)object);
        }
        return bl;
    }

    public API getAPI(APIType aPIType) {
        API aPI = null;
        int n = 0;
        while (n < this.apis.length) {
            if (this.apis[n].getType() == aPIType) {
                aPI = this.apis[n];
                break;
            }
            ++n;
        }
        return aPI;
    }

    public API[] getAPIs() {
        return this.apis;
    }

    public API getConfiguration() {
        return this.getAPI(APIType.CONFIGURATION);
    }

    public URL getJavadocURL() {
        return this.javadocURL;
    }

    public File getLibraryFile() {
        return this.libraryFile;
    }

    public API getProfile() {
        return this.getAPI(APIType.PROFILE);
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public boolean hasConfiguration() {
        return this.getConfiguration() != null;
    }

    public int hashCode() {
        return this.libraryFile.hashCode();
    }

    public boolean hasProfile() {
        return this.getProfile() != null;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String string;
        String string2;
        this.libraryFile = new File(iPersistenceProvider.loadString("file"));
        int n = iPersistenceProvider.loadInteger("apiCount");
        this.apis = new API[n];
        int n2 = 0;
        while (n2 < this.apis.length) {
            this.apis[n2] = (API)iPersistenceProvider.loadPersistable("entry" + n2);
            ++n2;
        }
        String string3 = iPersistenceProvider.loadString("javadocURL");
        if (string3 != null) {
            try {
                this.javadocURL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                MTJCore.log(2, "Error loading javadoc url " + string3, malformedURLException);
            }
        }
        if ((string2 = iPersistenceProvider.loadString("sourceAttachmentPath")) != null) {
            this.sourceAttachmentPath = new Path(string2);
        }
        if ((string = iPersistenceProvider.loadString("sourceAttachmentRootPath")) != null) {
            this.sourceAttachmentRootPath = new Path(string);
        }
    }

    public void setAccessRules(IAccessRule[] iAccessRuleArray) {
        this.accessRules = iAccessRuleArray;
    }

    public void setApis(API[] aPIArray) {
        this.apis = aPIArray;
    }

    public void setJavadocURL(URL uRL) {
        this.javadocURL = uRL;
    }

    public void setLibraryFile(File file) {
        this.libraryFile = file;
    }

    public void setSourceAttachmentPath(IPath iPath) {
        this.sourceAttachmentPath = iPath;
    }

    public void setSourceAttachmentRootPath(IPath iPath) {
        this.sourceAttachmentRootPath = iPath;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString("file", this.libraryFile.toString());
        iPersistenceProvider.storeInteger("apiCount", this.apis.length);
        int n = 0;
        while (n < this.apis.length) {
            iPersistenceProvider.storePersistable("entry" + n, this.apis[n]);
            ++n;
        }
        if (this.javadocURL != null) {
            iPersistenceProvider.storeString("javadocURL", this.javadocURL.toString());
        }
        if (this.sourceAttachmentPath != null) {
            iPersistenceProvider.storeString("sourceAttachmentPath", this.sourceAttachmentPath.toString());
        }
        if (this.sourceAttachmentRootPath != null) {
            iPersistenceProvider.storeString("sourceAttachmentRootPath", this.sourceAttachmentRootPath.toString());
        }
    }

    public IClasspathEntry toClasspathEntry() {
        Path path = new Path(this.libraryFile.toString());
        IClasspathAttribute[] iClasspathAttributeArray = this.getClasspathAttributes();
        return JavaCore.newLibraryEntry((IPath)path, (IPath)this.sourceAttachmentPath, (IPath)this.sourceAttachmentRootPath, (IAccessRule[])(this.accessRules == null ? NO_ACCESS_RULES : this.accessRules), (IClasspathAttribute[])iClasspathAttributeArray, (boolean)false);
    }

    public File toFile() {
        return this.libraryFile;
    }

    public String toString() {
        return this.libraryFile.toString();
    }

    public URL toURL() {
        URL uRL = null;
        try {
            uRL = this.libraryFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            MTJCore.log(4, malformedURLException);
        }
        return uRL;
    }

    private IClasspathAttribute[] getClasspathAttributes() {
        ArrayList<IClasspathAttribute> arrayList = new ArrayList<IClasspathAttribute>();
        IClasspathAttribute iClasspathAttribute = this.getJavadocAttribute();
        if (iClasspathAttribute != null) {
            arrayList.add(iClasspathAttribute);
        }
        return arrayList.toArray(new IClasspathAttribute[arrayList.size()]);
    }

    private IClasspathAttribute getJavadocAttribute() {
        IClasspathAttribute iClasspathAttribute = null;
        if (this.javadocURL != null) {
            iClasspathAttribute = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)this.javadocURL.toString());
        }
        return iClasspathAttribute;
    }
}

