/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.core.symbol.ISymbolSetChangeListener;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistry;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.symbol.ISymbolSetConstants;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.util.migration.SymbolDefinitionsMigration;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolSetRegistry
implements ISymbolSetRegistry,
ISymbolSetConstants {
    private static final SymbolSetRegistry instance = new SymbolSetRegistry();
    private static final String FILENAME = "symbolDefinitions.xml";
    private Map<String, IPersistable> registryMap;
    List<ISymbolSetChangeListener> listeners = new ArrayList<ISymbolSetChangeListener>();

    private SymbolSetRegistry() {
    }

    public static ISymbolSetRegistry getInstance() {
        return instance;
    }

    @Override
    public void addSymbolSet(ISymbolSet iSymbolSet) throws PersistenceException {
        String string = iSymbolSet.getName();
        if (string == null) {
            throw new IllegalStateException(Messages.SymbolDefinitionSetRegistry_addDefinitionSet_no_name_exception);
        }
        this.getRegistryMap().put(iSymbolSet.getName(), iSymbolSet);
        this.notifyListeners();
    }

    @Override
    public void addSymbolSetChangeListener(ISymbolSetChangeListener iSymbolSetChangeListener) {
        this.listeners.add(iSymbolSetChangeListener);
    }

    @Override
    public ISymbolSet getSymbolSet(String string) throws PersistenceException {
        return (ISymbolSet)this.getRegistryMap().get(string);
    }

    @Override
    public void removeSymbolSet(String string) {
        this.registryMap.remove(string);
        this.notifyListeners();
    }

    @Override
    public void removeSymbolSetChangeListener(ISymbolSetChangeListener iSymbolSetChangeListener) {
        this.listeners.remove(iSymbolSetChangeListener);
    }

    @Override
    public void clear() throws PersistenceException {
        this.getRegistryMap().clear();
    }

    @Override
    public String[] getAllSymbolSetNames() throws PersistenceException {
        Set<String> set = this.registryMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public ISymbolSet[] getAllSymbolSets() throws PersistenceException {
        Collection<IPersistable> collection = this.getRegistryMap().values();
        return collection.toArray(new SymbolSet[collection.size()]);
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String string;
        if (this.registryMap != null && (string = iPersistenceProvider.loadString("mtjKeys")) != null && string.length() > 0) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                ISymbolSet iSymbolSet = (ISymbolSet)iPersistenceProvider.loadPersistable(string2);
                this.registryMap.put(iSymbolSet.getName(), iSymbolSet);
                ++n2;
            }
        }
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<IPersistable> iterator = this.getRegistryMap().values().iterator();
        while (iterator.hasNext()) {
            SymbolSet symbolSet = (SymbolSet)iterator.next();
            String string = symbolSet.getStorableName();
            iPersistenceProvider.storePersistable(string, symbolSet);
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        iPersistenceProvider.storeString("mtjKeys", stringBuffer.toString());
    }

    private synchronized Map<String, IPersistable> getRegistryMap() throws PersistenceException {
        if (this.registryMap == null) {
            this.registryMap = new HashMap<String, IPersistable>();
            this.load();
        }
        return this.registryMap;
    }

    private File getStoreFile() {
        IPath iPath = MTJCore.getDefault().getStateLocation();
        IPath iPath2 = iPath.append(FILENAME);
        return iPath2.toFile();
    }

    private void notifyListeners() {
        for (ISymbolSetChangeListener iSymbolSetChangeListener : this.listeners) {
            iSymbolSetChangeListener.symbolSetChanged();
        }
    }

    @Override
    public void load() throws PersistenceException {
        File file;
        if (this.registryMap != null) {
            this.registryMap.clear();
        }
        if ((file = this.getStoreFile()).exists()) {
            try {
                Document document = XMLUtils.readDocument(file);
                SymbolDefinitionsMigration symbolDefinitionsMigration = new SymbolDefinitionsMigration();
                symbolDefinitionsMigration.migrate(document);
                if (symbolDefinitionsMigration.isMigrated()) {
                    try {
                        XMLUtils.writeDocument(file, document);
                    }
                    catch (TransformerException transformerException) {
                        transformerException.printStackTrace();
                    }
                    document = XMLUtils.readDocument(file);
                }
                XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider(document);
                this.loadUsing(xMLPersistenceProvider);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PersistenceException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new PersistenceException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider("symbolDefinitionsRegistry");
        this.storeUsing(xMLPersistenceProvider);
        XMLUtils.writeDocument(this.getStoreFile(), xMLPersistenceProvider.getDocument());
    }

    @Override
    public void addSymbolSet(List<ISymbolSet> list) throws PersistenceException {
        for (ISymbolSet iSymbolSet : list) {
            this.registryMap.put(iSymbolSet.getName(), iSymbolSet);
        }
        this.notifyListeners();
    }

    public void addNewSymbolSet(ISymbolSet iSymbolSet) throws PersistenceException {
        this.registryMap.put(iSymbolSet.getName(), iSymbolSet);
        this.notifyListeners();
    }
}

