/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.api.API;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class DeviceTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String TEXT_UNKNOWN = "";
    private static final int COL_CHECKBOX = 0;
    private static final int COL_GROUP_NAME = 1;
    private static final int COL_NAME = 2;
    private static final int COL_CONFIGURATION = 3;
    private static final int COL_PROFILE = 4;

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        String string = TEXT_UNKNOWN;
        IDevice iDevice = (IDevice)object;
        switch (n) {
            case 0: {
                string = TEXT_UNKNOWN;
                break;
            }
            case 2: {
                string = iDevice.getName();
                break;
            }
            case 1: {
                string = iDevice.getSDKName();
                break;
            }
            case 3: {
                string = this.getConfigurationText((IMIDPDevice)iDevice);
                break;
            }
            case 4: {
                string = this.getProfileText((IMIDPDevice)iDevice);
            }
        }
        return string;
    }

    private String getConfigurationText(IMIDPDevice iMIDPDevice) {
        API aPI;
        String string = TEXT_UNKNOWN;
        ILibrary iLibrary = iMIDPDevice.getConfigurationLibrary();
        if (iLibrary != null && (aPI = iLibrary.getConfiguration()) != null) {
            string = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{aPI.getVersion().getMajor(), aPI.getVersion().getMinor()});
        }
        return string;
    }

    private String getProfileText(IMIDPDevice iMIDPDevice) {
        API aPI;
        String string = TEXT_UNKNOWN;
        ILibrary iLibrary = iMIDPDevice.getProfileLibrary();
        if (iLibrary != null && (aPI = iLibrary.getProfile()) != null) {
            string = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{aPI.getVersion().getMajor(), aPI.getVersion().getMinor()});
        }
        return string;
    }
}

