/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.pages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentRange;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.XMLSourcePage;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nSourceOutlinePage;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.L10nContentProvider;

public class L10nSourcePage
extends XMLSourcePage {
    public L10nSourcePage(MTJFormEditor mTJFormEditor, String string, String string2) {
        super(mTJFormEditor, string, string2);
    }

    protected ISortableContentOutlinePage createOutlinePage() {
        L10nSourceOutlinePage l10nSourceOutlinePage = new L10nSourceOutlinePage((MTJFormEditor)this.getEditor(), (IEditingModel)this.getInputContext().getModel(), (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createDefaultOutlineComparator(), this.createOutlineComparator());
        this.fOutlinePage = l10nSourceOutlinePage;
        this.fOutlineSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                L10nSourcePage.this.updateSelection(selectionChangedEvent);
            }
        };
        this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
        this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)l10nSourceOutlinePage);
        this.fEditorSelectionChangedListener = new MTJSourcePage.MTJSourcePageChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        return this.fOutlinePage;
    }

    public ViewerComparator createOutlineComparator() {
        return null;
    }

    public ITreeContentProvider createOutlineContentProvider() {
        return new L10nContentProvider();
    }

    public ILabelProvider createOutlineLabelProvider() {
        return MTJUIPlugin.getDefault().getLabelProvider();
    }

    public IDocumentRange getRangeElement(int n, boolean bl) {
        L10nLocales l10nLocales = ((L10nModel)this.getInputContext().getModel()).getLocales();
        return this.findNode((IDocumentElementNode)l10nLocales, n, bl);
    }

    public boolean isQuickOutlineEnabled() {
        return true;
    }

    public void updateSelection(Object object) {
        if (object instanceof IDocumentElementNode && !((IDocumentElementNode)object).isErrorNode()) {
            this.setSelectedObject(object);
            this.setHighlightRange((IDocumentRange)((IDocumentElementNode)object), true);
            this.setSelectedRange((IDocumentRange)((IDocumentElementNode)object), false);
        }
    }

    protected IDocumentRange findRange() {
        Object object = this.getSelection();
        if (object instanceof IDocumentElementNode) {
            return (IDocumentElementNode)object;
        }
        return null;
    }

    protected void initializeEditor() {
        super.initializeEditor();
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected void setPartName(String string) {
        super.setPartName(MTJUIMessages.L10nSourcePage_source_partName);
    }

    protected void synchronizeOutlinePage(int n) {
        IDocumentRange iDocumentRange = this.getRangeElement(n, true);
        this.updateHighlightRange(iDocumentRange);
        if (iDocumentRange instanceof IDocumentAttributeNode) {
            iDocumentRange = ((IDocumentAttributeNode)iDocumentRange).getEnclosingElement();
        }
        this.updateOutlinePageSelection(iDocumentRange);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        try {
            L10nModel l10nModel = (L10nModel)this.getInputContext().getModel();
            l10nModel.validate();
            L10nApi.syncronizeApi((L10nModel)l10nModel);
        }
        catch (CoreException coreException) {
            MTJCore.log((int)4, (Throwable)coreException);
        }
    }
}

