/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrarySpecification;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.Configuration;
import org.eclipse.mtj.internal.ui.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PreverificationPreferencePage
extends PreferencePage
implements IEmbeddableWorkbenchPreferencePage {
    private static final String[] BUTTON_TEXTS = new String[]{MTJUIMessages.PreverificationPreferencePage_use_jad_settings_label_text, MTJUIMessages.PreverificationPreferencePage_use_project_settings_label_text, MTJUIMessages.PreverificationPreferencePage_use_specific_config_label_text};
    private static final String[] CONFIG_FILE_LOCATIONS = new String[]{"jad", "platform", "specified"};
    private Combo configCombo;
    private ILibrarySpecification[] configSpecs;
    private FileFieldEditor defaultPreverifierField;
    private boolean embeddedInProperties;
    private Button[] preverificationRadios;

    public PreverificationPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public PreverificationPreferencePage(boolean bl, IPreferenceStore iPreferenceStore) {
        this.embeddedInProperties = bl;
        this.setPreferenceStore(iPreferenceStore);
        this.configSpecs = Configuration.values();
    }

    public void doBuild(final IProject[] iProjectArray) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    int n = 0;
                    while (n < iProjectArray.length) {
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, -1);
                        iProjectArray[n].build(6, (IProgressMonitor)subProgressMonitor);
                        subProgressMonitor.done();
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJCore.log((int)2, (String)MTJUIMessages.PreverificationPreferencePage_error_build_suite, (Throwable)invocationTargetException.getCause());
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void performApply() {
        super.performApply();
    }

    public void performDefaults() {
        this.setControlsFromDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        this.setPreferencesFromControls();
        if (!this.embeddedInProperties) {
            this.buildSuites();
        }
        return super.performOk();
    }

    private void addConfigurationControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(MTJUIMessages.PreverificationPreferencePage_preverifyConfigGroup_label_text);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.preverificationRadios = new Button[BUTTON_TEXTS.length];
        int n = 0;
        while (n < BUTTON_TEXTS.length) {
            this.preverificationRadios[n] = new Button((Composite)group, 16);
            this.preverificationRadios[n].setText(BUTTON_TEXTS[n]);
            if (CONFIG_FILE_LOCATIONS[n].equals("specified")) {
                this.addSpecificConfigurationControls(group);
            }
            ++n;
        }
    }

    private void addDefaultPreverifierControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(MTJUIMessages.PreverificationPreferencePage_defaultPreverifierGroup_label_text);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(MTJUIMessages.PreverificationPreferencePage_defaultPreverifierTip_label_text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 10;
        label.setLayoutData((Object)gridData);
        this.defaultPreverifierField = new FileFieldEditor("default_preverifier", MTJUIMessages.PreverificationPreferencePage_defaultPreverifierField_label_text, (Composite)group);
        String[] stringArray = null;
        if (Platform.getOS().equals("win32")) {
            stringArray = new String[]{"*.exe"};
        }
        this.defaultPreverifierField.setFileExtensions(stringArray);
        this.defaultPreverifierField.setPreferenceStore(this.getPreferenceStore());
    }

    private void addSpecificConfigurationControls(Group group) {
        this.configCombo = new Combo((Composite)group, 8);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 15;
        this.configCombo.setLayoutData((Object)gridData);
        String[] stringArray = new String[this.configSpecs.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.configSpecs[n].getName();
            ++n;
        }
        this.configCombo.setItems(stringArray);
    }

    private void buildSuites() {
        IWorkspaceRoot iWorkspaceRoot = MTJCore.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            try {
                if (iProject.isOpen() && iProject.hasNature("org.eclipse.mtj.core.nature") && !this.usesProjectSpecificPreverification(iProject)) {
                    arrayList.add(iProject);
                }
            }
            catch (CoreException coreException) {
                MTJCore.log((int)4, (String)MTJUIMessages.PreverificationPreferencePage_error_build_midlet_suite, (Throwable)coreException);
            }
            ++n;
        }
        IProject[] iProjectArray2 = arrayList.toArray(new IProject[arrayList.size()]);
        if (iProjectArray2.length > 0) {
            this.doBuild(iProjectArray2);
        }
    }

    private void setControlsFromDefaults() {
        if (this.preverificationRadios != null) {
            String string;
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            String string2 = iPreferenceStore.getDefaultString("preverify_config_location");
            int n = 0;
            while (n < this.preverificationRadios.length) {
                string = CONFIG_FILE_LOCATIONS[n];
                this.preverificationRadios[n].setSelection(string.equals(string2));
                ++n;
            }
            n = 0;
            string = iPreferenceStore.getDefaultString("preverify_config_value");
            int n2 = 0;
            while (n2 < this.configSpecs.length) {
                ILibrarySpecification iLibrarySpecification = this.configSpecs[n2];
                if (iLibrarySpecification.getIdentifier().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.configCombo.select(n);
        }
        if (this.defaultPreverifierField != null) {
            this.defaultPreverifierField.loadDefault();
        }
    }

    private void setControlsFromPreferences() {
        if (this.preverificationRadios != null) {
            String string;
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            String string2 = iPreferenceStore.getString("preverify_config_location");
            int n = 0;
            while (n < this.preverificationRadios.length) {
                string = CONFIG_FILE_LOCATIONS[n];
                this.preverificationRadios[n].setSelection(string.equals(string2));
                ++n;
            }
            n = 0;
            string = iPreferenceStore.getString("preverify_config_value");
            int n2 = 0;
            while (n2 < this.configSpecs.length) {
                ILibrarySpecification iLibrarySpecification = this.configSpecs[n2];
                if (iLibrarySpecification.getIdentifier().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.configCombo.select(n);
        }
        if (this.defaultPreverifierField != null) {
            this.defaultPreverifierField.load();
        }
    }

    private void setDefaultPreverifier() {
        if (!this.defaultPreverifierField.getStringValue().equals(this.getPreferenceStore().getString("default_preverifier"))) {
            File file = new File(this.defaultPreverifierField.getStringValue());
            IPreverifier iPreverifier = null;
            try {
                iPreverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)file);
            }
            catch (CoreException coreException) {
                MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.PreverificationPreferencePage_invalid_preverifier_dialog_title, MTJUIMessages.PreverificationPreferencePage_invalid_preverifier_dialog_message, coreException);
                MTJCore.log((int)4, (String)NLS.bind((String)MTJUIMessages.PreverificationPreferencePage_device_store_error, (Object[])new String[]{((Object)((Object)coreException)).getClass().getName(), coreException.getMessage()}), (Throwable)coreException);
            }
            MTJCore.getDeviceRegistry().setDefaultPreverifer(iPreverifier);
            try {
                MTJCore.getDeviceRegistry().store();
            }
            catch (Exception exception) {
                MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.PreverificationPreferencePage_error_store_preverifier_dialog_title, MTJUIMessages.PreverificationPreferencePage_error_store_preverifier_dialog_message, exception);
                MTJCore.log((int)4, (String)NLS.bind((String)MTJUIMessages.PreverificationPreferencePage_device_store_error, (Object[])new String[]{exception.getClass().getName(), exception.getMessage()}), (Throwable)exception);
            }
        }
    }

    private void setPreferencesFromControls() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = 0;
        while (n < this.preverificationRadios.length) {
            if (this.preverificationRadios[n].getSelection()) {
                iPreferenceStore.setValue("preverify_config_location", CONFIG_FILE_LOCATIONS[n]);
                break;
            }
            ++n;
        }
        n = this.configCombo.getSelectionIndex();
        iPreferenceStore.setValue("preverify_config_value", this.configSpecs[n].getIdentifier());
        if (this.defaultPreverifierField != null) {
            this.setDefaultPreverifier();
            this.defaultPreverifierField.store();
        }
    }

    private boolean usesProjectSpecificPreverification(IProject iProject) {
        ProjectScope projectScope = new ProjectScope(iProject);
        IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.eclipse.mtj.core");
        return iEclipsePreferences.getBoolean("pkg_use_project", false);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.addConfigurationControls(composite2);
        if (!this.embeddedInProperties) {
            this.addDefaultPreverifierControls(composite2);
        } else {
            this.noDefaultAndApplyButton();
        }
        this.setControlsFromPreferences();
        return composite2;
    }
}

