/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.templates.midlets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateBuilderException;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateObject;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletTemplateBuilder {
    private MIDletTemplateObject template;
    private Map<String, String> dictionary;

    public MidletTemplateBuilder(MIDletTemplateObject mIDletTemplateObject, Map<String, String> map) {
        this.template = mIDletTemplateObject;
        this.dictionary = map;
    }

    public IType build(IPackageFragmentRoot iPackageFragmentRoot, String string, String string2) throws MIDletTemplateBuilderException {
        try {
            Map<String, Object> map = null;
            Object object = null;
            File file = FileLocator.getBundleFile((Bundle)this.template.getBundle());
            if (!file.isDirectory()) {
                object = new ZipFile(file);
                map = this.getTemplates((ZipFile)object);
            } else {
                object = file;
                map = this.getTemplates((File)object);
            }
            return this.build(iPackageFragmentRoot, string, string2, object, map);
        }
        catch (Exception exception) {
            throw new MIDletTemplateBuilderException(String.valueOf(MTJUIMessages.MidletTemplateBuilder_UnableToBuildTemplate) + exception.getMessage());
        }
    }

    private IType build(IPackageFragmentRoot iPackageFragmentRoot, String string, String string2, Object object, Map<String, Object> map) throws MIDletTemplateBuilderException {
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        IType iType = null;
        try {
            IPackageFragment iPackageFragment = iPackageFragmentRoot.createPackageFragment(string, true, (IProgressMonitor)nullProgressMonitor);
            for (String object22 : map.keySet()) {
                ZipFile zipFile;
                Object object2;
                boolean bl = false;
                String string3 = null;
                String string4 = NLS.bind((String)"{0}.java", (Object)object22.replace(".template", ""));
                if (string4.equalsIgnoreCase("$class_name$.java")) {
                    string4 = NLS.bind((String)"{0}.java", (Object)string2);
                    bl = true;
                }
                if ((object2 = map.get(object22)) instanceof ZipEntry) {
                    zipFile = (ZipFile)object;
                    string3 = this.processTemplate(zipFile.getInputStream((ZipEntry)object2), string, string2);
                } else {
                    string3 = this.processTemplate(new FileInputStream((File)object2), string, string2);
                }
                zipFile = iPackageFragment.createCompilationUnit(string4, string3, true, (IProgressMonitor)nullProgressMonitor);
                if (!bl) continue;
                iType = zipFile.getType(string2);
            }
            IProject iProject = iPackageFragmentRoot.getJavaProject().getProject();
            File file = new File(iProject.getLocation().toOSString());
            if (object instanceof ZipFile) {
                this.copyResources((ZipFile)object, file);
            } else {
                this.copyResources((File)object, file);
            }
            iProject.refreshLocal(2, (IProgressMonitor)nullProgressMonitor);
            return iType;
        }
        catch (Exception exception) {
            throw new MIDletTemplateBuilderException(String.valueOf(MTJUIMessages.MidletTemplateBuilder_UnableToGenerateClasses) + exception.getMessage());
        }
    }

    private void copyFile(File file, File file2) throws IOException {
        File file3 = null;
        if (file.isDirectory()) {
            File[] fileArray;
            file3 = new File(file2, file.getName());
            if (!file3.exists() && !file3.mkdir()) {
                return;
            }
            File[] fileArray2 = fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file4 = fileArray2[n2];
                this.copyFile(file4, file3);
                ++n2;
            }
        } else {
            file3 = new File(file2, file.getName());
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file3);
                fileInputStream = new FileInputStream(file);
                this.copyStreams(fileInputStream, fileOutputStream);
            }
            finally {
                fileOutputStream.close();
                fileInputStream.close();
            }
        }
    }

    private void copyResources(File file, File file2) throws IOException {
        String string = NLS.bind((String)"templates/{0}/resources", (Object)this.template.getId());
        File file3 = new File(file, string);
        if (file3.exists() && file3.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file3.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file4 = fileArray2[n2];
                this.copyFile(file4, file2);
                ++n2;
            }
        }
    }

    private void copyResources(ZipFile zipFile, File file) throws IOException {
        String string = NLS.bind((String)"templates/{0}/resources/.*", (Object)this.template.getId());
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!Pattern.matches(string, zipEntry.getName())) continue;
            IPath iPath = new Path(zipEntry.getName()).removeFirstSegments(3);
            File file2 = new File(file, iPath.toString());
            this.createFileFromZipFile(file2, zipFile, zipEntry);
        }
    }

    private void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = -1;
        while ((n = inputStream.read()) != -1) {
            outputStream.write(n);
        }
    }

    private void createFileFromZipFile(File file, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        this.copyStreams(inputStream, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        inputStream.close();
    }

    private Map<String, Object> getTemplates(File file) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = NLS.bind((String)"templates/{0}/java", (Object)this.template.getId());
        File file2 = new File(file, string);
        if (file2.exists() && file2.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file2.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray2[n2];
                if (file3.isFile() && Pattern.matches(".+[.template]", file3.getName())) {
                    hashMap.put(file3.getName(), file3);
                }
                ++n2;
            }
        }
        return hashMap;
    }

    private Map<String, Object> getTemplates(ZipFile zipFile) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = NLS.bind((String)"templates/{0}/java/.+[.]template", (Object)this.template.getId());
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!Pattern.matches(string, zipEntry.getName())) continue;
            Path path = new Path(zipEntry.getName());
            hashMap.put(path.lastSegment(), zipEntry);
        }
        return hashMap;
    }

    private String processTemplate(InputStream inputStream, String string, String string2) throws IOException, CoreException {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = null;
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        stringBuffer = new StringBuffer();
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(NLS.bind((String)"package {0};\n", (Object)string));
        }
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string3).append("\n");
        }
        bufferedReader.close();
        String string4 = stringBuffer.toString();
        string4 = string4.replace("$class_name$", string2);
        for (String string5 : this.dictionary.keySet()) {
            string4 = string4.replace(string5, this.dictionary.get(string5));
        }
        return string4;
    }
}

