/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.libraries;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.mtj.internal.ui.util.PixelConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LibraryInfoBlock
implements ISelectionChangedListener {
    private Device device;
    private String fontName;
    private int height;
    private Composite libraryInfoComposite;

    public Control createControl(Composite composite) {
        if (composite == null) {
            return null;
        }
        this.libraryInfoComposite = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(12);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(25);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.libraryInfoComposite.setLayout((Layout)gridLayout);
        this.libraryInfoComposite.setLayoutData((Object)gridData);
        this.libraryInfoComposite.setData(null);
        this.device = this.libraryInfoComposite.getFont().getDevice();
        this.fontName = this.libraryInfoComposite.getFont().getFontData()[0].getName();
        this.height = this.libraryInfoComposite.getFont().getFontData()[0].getHeight();
        return this.libraryInfoComposite;
    }

    public Control getControl() {
        return this.libraryInfoComposite;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelection() instanceof StructuredSelection) {
            this.handlePostSelectionChange((StructuredSelection)selectionChangedEvent.getSelection());
        } else {
            this.handlePostSelectionChange(StructuredSelection.EMPTY);
        }
    }

    private void createLinkItem(Composite composite, String string, String string2, Listener listener) {
        Label label = new Label(composite, 1);
        label.setText(string);
        label.setFont(new Font(this.device, this.fontName, this.height, 1));
        Link link = new Link(composite, 1);
        link.setText(NLS.bind((String)MTJUIMessages.LibraryInfoBlock_libraryLicenseURI_href, (Object)string2));
        link.addListener(13, listener);
    }

    private void createTextItem(Composite composite, String string, String string2) {
        Label label = new Label(composite, 1);
        label.setText(string);
        label.setFont(new Font(this.device, this.fontName, this.height, 1));
        Text text = new Text(composite, 73);
        text.setText(string2);
    }

    private void handlePostSelectionChange(StructuredSelection structuredSelection) {
        if (this.libraryInfoComposite == null) {
            return;
        }
        Composite composite = (Composite)this.libraryInfoComposite.getData();
        if (composite != null && composite.getParent() != null) {
            composite.getParent().dispose();
        }
        PixelConverter pixelConverter = new PixelConverter((Control)this.libraryInfoComposite);
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(this.libraryInfoComposite, 512);
        scrolledPageContent.getVerticalBar().setIncrement(5);
        GridData gridData = new GridData(1808);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(12);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(25);
        scrolledPageContent.setLayoutData(gridData);
        composite = scrolledPageContent.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.rightMargin = 0;
        composite.setLayout((Layout)tableWrapLayout);
        gridData = new GridData(1808);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(12);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(25);
        composite.setLayoutData((Object)gridData);
        this.libraryInfoComposite.setData((Object)composite);
        IExternalLibrary iExternalLibrary = (IExternalLibrary)structuredSelection.getFirstElement();
        if (iExternalLibrary != null) {
            this.createTextItem(composite, MTJUIMessages.LibraryInfoBlock_libraryNameLabel, iExternalLibrary.getName());
            this.createTextItem(composite, MTJUIMessages.LibraryInfoBlock_libraryVersionLabel, iExternalLibrary.getVersion().toString());
            this.createTextItem(composite, MTJUIMessages.LibraryInfoBlock_libraryDescriptionLabel, iExternalLibrary.getDescription());
            this.createLinkItem(composite, MTJUIMessages.LibraryInfoBlock_libraryLicenseURILabel, iExternalLibrary.getLicence().getUri().toASCIIString(), new Listener(){

                public void handleEvent(Event event) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.text));
                    }
                    catch (PartInitException partInitException) {
                        partInitException.printStackTrace();
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            });
            this.createTextItem(composite, MTJUIMessages.LibraryInfoBlock_protection_domain_label, iExternalLibrary.getSecurity().getProtectionDomain().getProtectionDomainType().toString().toLowerCase());
            this.createTextItem(composite, MTJUIMessages.LibraryInfoBlock_permissions_label, iExternalLibrary.getSecurity().getPermissionList().toString());
        }
        this.libraryInfoComposite.layout(true);
    }
}

