/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.templates.midlets;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateObject;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateRegistry;
import org.eclipse.mtj.internal.ui.wizards.templates.TemplateWizardPageDelegate;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class MidletTemplateListWizardPage
extends NewTypeWizardPage {
    public static final String MIDLET_TEMPLATE_WIZARD_PAGE_1 = "MidletTemplateListWizardPage";
    private ScrolledFormText descriptionText;
    private TableViewer viewer;
    protected MIDletTemplateObject template;

    public MidletTemplateListWizardPage() {
        super(true, MIDLET_TEMPLATE_WIZARD_PAGE_1);
        this.setTitle(MTJUIMessages.MidletTemplateWizardPage1_Page1Title);
        this.setDescription(MTJUIMessages.MidletTemplateWizardPage1_Page1Description);
    }

    public boolean canFlipToNextPage() {
        return !this.viewer.getSelection().isEmpty();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTemplatesList(composite2);
        this.createDetails(composite2);
        this.setControl((Control)composite2);
    }

    private void createDetails(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.MidletTemplateWizardPage1_DescriptionLabel);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final FormToolkit formToolkit = new FormToolkit(composite.getDisplay());
        int n = formToolkit.getBorderStyle() == 2048 ? 0 : 2048;
        Composite composite2 = new Composite(composite, n);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 1;
        fillLayout.marginHeight = 1;
        composite2.setLayout((Layout)fillLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionText = new ScrolledFormText(composite2, 768, false);
        if (n == 0) {
            this.descriptionText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            formToolkit.paintBordersFor(composite2);
        }
        FormText formText = formToolkit.createFormText((Composite)this.descriptionText, false);
        this.descriptionText.setFormText(formText);
        this.descriptionText.setExpandHorizontal(true);
        this.descriptionText.setExpandVertical(true);
        this.descriptionText.setBackground(formToolkit.getColors().getBackground());
        this.descriptionText.setForeground(formToolkit.getColors().getForeground());
        formText.marginWidth = 2;
        formText.marginHeight = 2;
        formText.setHyperlinkSettings((HyperlinkSettings)formToolkit.getHyperlinkGroup());
        this.descriptionText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (formToolkit != null) {
                    formToolkit.dispose();
                }
            }
        });
        this.updateDetails(this.getCurrentTemplate(this.viewer));
    }

    private void createTemplatesList(Composite composite) {
        GridData gridData = null;
        final Button button = new Button(composite, 32);
        button.setText("Create MIDlet using a template.");
        button.setSelection(true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                MidletTemplateListWizardPage.this.viewer.getControl().setEnabled(bl);
                MidletTemplateListWizardPage.this.viewer.setSelection(null);
                MidletTemplateListWizardPage.this.descriptionText.setText("");
                MidletTemplateListWizardPage.this.descriptionText.setEnabled(bl);
                MidletTemplateListWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.MidletTemplateWizardPage1_AvailableTemplates);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2560);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        gridData = new GridData(768);
        gridData.heightHint = 100;
        scrolledComposite.setLayoutData((Object)gridData);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        Table table = new Table((Composite)scrolledComposite, 4);
        gridData = new GridData(768);
        table.setLayoutData((Object)gridData);
        scrolledComposite.setContent((Control)table);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object object, int n) {
                return MTJUIPluginImages.DESC_TEMPLATE_OBJ.createImage();
            }

            public String getColumnText(Object object, int n) {
                if (object instanceof MIDletTemplateObject) {
                    return ((MIDletTemplateObject)object).getName();
                }
                return null;
            }

            public boolean isLabelProperty(Object object, String string) {
                return false;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                Collection<MIDletTemplateObject> collection = null;
                MIDletTemplateRegistry mIDletTemplateRegistry = null;
                if (!(object instanceof MIDletTemplateRegistry)) {
                    return new Object[0];
                }
                mIDletTemplateRegistry = (MIDletTemplateRegistry)object;
                collection = mIDletTemplateRegistry.getTemplates();
                return collection.toArray(new MIDletTemplateObject[collection.size()]);
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.viewer.setInput((Object)MIDletTemplateRegistry.getInstance());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                MidletTemplateListWizardPage.this.template = MidletTemplateListWizardPage.this.getCurrentTemplate(MidletTemplateListWizardPage.this.viewer);
                if (MidletTemplateListWizardPage.this.template == null) {
                    return;
                }
                MidletTemplateListWizardPage.this.updateDetails(MidletTemplateListWizardPage.this.template);
                final IWizardPage iWizardPage = MidletTemplateListWizardPage.this.getWizard().getPage("TemplateCustomPage");
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            TemplateWizardPageDelegate templateWizardPageDelegate = (TemplateWizardPageDelegate)iWizardPage;
                            templateWizardPageDelegate.setTitle((this).MidletTemplateListWizardPage.this.template.getName());
                            templateWizardPageDelegate.setDescription((this).MidletTemplateListWizardPage.this.template.getOverview());
                            templateWizardPageDelegate.setPage((this).MidletTemplateListWizardPage.this.template.getPage());
                            templateWizardPageDelegate.getWizard().getContainer().updateButtons();
                        }
                        catch (CoreException coreException) {
                            MessageDialog.openError((Shell)MidletTemplateListWizardPage.this.getShell(), (String)MTJUIMessages.MidletTemplateWizardPage1_UnableToBuildUi, (String)coreException.getMessage());
                        }
                    }
                });
            }
        });
    }

    public MIDletTemplateObject getSelectedTemplate() {
        return this.getCurrentTemplate(this.viewer);
    }

    private MIDletTemplateObject getCurrentTemplate(TableViewer tableViewer) {
        IStructuredSelection iStructuredSelection = null;
        ISelection iSelection = tableViewer.getSelection();
        if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        iStructuredSelection = (IStructuredSelection)iSelection;
        return (MIDletTemplateObject)iStructuredSelection.getFirstElement();
    }

    private void updateDetails(MIDletTemplateObject mIDletTemplateObject) {
        if (mIDletTemplateObject == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<p>");
        stringBuffer.append(mIDletTemplateObject.getDescription());
        stringBuffer.append("</p>");
        String[] stringArray = mIDletTemplateObject.getPermissions();
        stringBuffer.append("<p indent='10'><b>");
        stringBuffer.append(MTJUIMessages.MidletTemplateWizardPage1_PermissionsLabel);
        stringBuffer.append("</b></p>");
        if (stringArray == null || stringArray.length < 1) {
            stringBuffer.append("<li bindent='10'>");
            stringBuffer.append(MTJUIMessages.MidletTemplateWizardPage1_PermissionsNone);
            stringBuffer.append("</li>");
        } else {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                stringBuffer.append("<li bindent='10'>");
                stringBuffer.append(string);
                stringBuffer.append("</li>");
                ++n2;
            }
        }
        this.descriptionText.setText(stringBuffer.toString());
    }
}

