/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.jad;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADAttributesRegistry;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.preferences.ExtendedStringFieldEditor;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.ListDescriptorPropertyDescription;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class JADPropertiesEditorPage
extends AbstractJADEditorPage
implements IPropertyChangeListener {
    private Constructor<?> comboEditorConstructor;
    private Class<?> comboFieldEditorClass;
    private DescriptorPropertyDescription[] descriptors;
    protected FieldEditor[] fieldEditors;

    public JADPropertiesEditorPage(JADFormEditor jADFormEditor, String string, String string2) {
        super(jADFormEditor, string, string2);
    }

    public JADPropertiesEditorPage(String string, String string2) {
        super(string, string2);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.setTaskName(this.getTitle());
        FieldEditor[] fieldEditorArray = this.fieldEditors;
        int n = this.fieldEditors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor fieldEditor = fieldEditorArray[n2];
            fieldEditor.store();
            ++n2;
        }
        this.setDirty(false);
    }

    public void editorInputChanged() {
        this.updateEditComponents();
    }

    public DescriptorPropertyDescription[] getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.doGetDescriptors();
        }
        return this.descriptors;
    }

    public boolean isManagingProperty(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.getDescriptors().length) {
            DescriptorPropertyDescription descriptorPropertyDescription = this.getDescriptors()[n];
            if (string.equals(descriptorPropertyDescription.getPropertyName())) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_value")) {
            this.setDirty(true);
        }
    }

    public void setFocus() {
        if (this.fieldEditors.length > 0) {
            this.fieldEditors[0].setFocus();
        }
    }

    private FieldEditor createComboFieldEditor(FormToolkit formToolkit, Composite composite, DescriptorPropertyDescription descriptorPropertyDescription) {
        if (this.comboFieldEditorClass == null) {
            this.initializeComboFieldEditorSupport();
        }
        ListDescriptorPropertyDescription listDescriptorPropertyDescription = (ListDescriptorPropertyDescription)descriptorPropertyDescription;
        FieldEditor fieldEditor = null;
        try {
            fieldEditor = (FieldEditor)this.comboEditorConstructor.newInstance(new Object[]{listDescriptorPropertyDescription.getPropertyName(), listDescriptorPropertyDescription.getDisplayName(), listDescriptorPropertyDescription.getNamesAndValues(), composite});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MTJCore.log((int)4, (Throwable)illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            MTJCore.log((int)4, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            MTJCore.log((int)4, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJCore.log((int)4, (Throwable)invocationTargetException);
        }
        return fieldEditor;
    }

    private IntegerFieldEditor createIntegerFieldEditor(FormToolkit formToolkit, Composite composite, DescriptorPropertyDescription descriptorPropertyDescription) {
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(descriptorPropertyDescription.getPropertyName(), descriptorPropertyDescription.getDisplayName(), composite);
        formToolkit.adapt((Control)integerFieldEditor.getTextControl(composite), true, true);
        return integerFieldEditor;
    }

    private ExtendedStringFieldEditor createStringFieldEditor(FormToolkit formToolkit, Composite composite, DescriptorPropertyDescription descriptorPropertyDescription) {
        ExtendedStringFieldEditor extendedStringFieldEditor = new ExtendedStringFieldEditor(descriptorPropertyDescription.getPropertyName(), descriptorPropertyDescription.getDisplayName(), composite);
        formToolkit.adapt((Control)extendedStringFieldEditor.getTextControl(composite), true, true);
        return extendedStringFieldEditor;
    }

    private void initializeComboFieldEditorSupport() {
        String[] stringArray = new String[]{"org.eclipse.jdt.internal.debug.ui.launcher.ComboFieldEditor", "org.eclipse.jface.preference.ComboFieldEditor"};
        int n = 0;
        while (this.comboFieldEditorClass == null && n < stringArray.length) {
            String string = stringArray[n];
            try {
                this.comboFieldEditorClass = Class.forName(string);
                this.comboEditorConstructor = this.comboFieldEditorClass.getConstructors()[0];
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                MTJCore.log((int)4, (Throwable)securityException);
            }
            ++n;
        }
    }

    private void updateEditComponents() {
        if (this.fieldEditors != null) {
            IManifestPreferenceStore iManifestPreferenceStore = this.getPreferenceStore();
            FieldEditor[] fieldEditorArray = this.fieldEditors;
            int n = this.fieldEditors.length;
            int n2 = 0;
            while (n2 < n) {
                FieldEditor fieldEditor = fieldEditorArray[n2];
                fieldEditor.setPreferenceStore((IPreferenceStore)iManifestPreferenceStore);
                fieldEditor.load();
                ++n2;
            }
        }
    }

    protected abstract void addContextHelp(Composite var1);

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = iManagedForm.getForm().getBody();
        composite.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 1));
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        composite2.setLayoutData((Object)new TableWrapData(256));
        Section section = this.createStaticBasicSection(formToolkit, composite2, this.getSectionTitle(), this.getSectionDescription());
        Composite composite3 = this.createStaticSectionClient(formToolkit, (Composite)section);
        composite3.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        this.createSectionContent(iManagedForm, composite3, this);
        section.setClient((Control)composite3);
    }

    protected void createSectionContent(IManagedForm iManagedForm, Composite composite, IPropertyChangeListener iPropertyChangeListener) {
        Control[] controlArray;
        Control control;
        FormToolkit formToolkit = iManagedForm.getToolkit();
        composite.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        new Label(composite, 0);
        new Label(composite, 0);
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = this.getDescriptors();
        this.fieldEditors = new FieldEditor[descriptorPropertyDescriptionArray.length];
        int n = 0;
        while (n < descriptorPropertyDescriptionArray.length) {
            switch (descriptorPropertyDescriptionArray[n].getDataType()) {
                case 3: {
                    this.fieldEditors[n] = this.createIntegerFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n]);
                    break;
                }
                case 4: {
                    this.fieldEditors[n] = this.createComboFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n]);
                    break;
                }
                default: {
                    this.fieldEditors[n] = this.createStringFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n]);
                }
            }
            control = this.fieldEditors[n].getLabelControl(composite);
            formToolkit.adapt(control, false, false);
            this.fieldEditors[n].setPropertyChangeListener(iPropertyChangeListener);
            ++n;
        }
        Control[] controlArray2 = controlArray = composite.getChildren();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            control = controlArray2[n3];
            if (control instanceof Combo) {
                formToolkit.adapt(control, false, false);
            }
            ++n3;
        }
        this.updateEditComponents();
        this.addContextHelp(composite);
    }

    protected DescriptorPropertyDescription[] doGetDescriptors() {
        return JADAttributesRegistry.getJADAttrDescriptorsByPage(this.getId());
    }

    protected abstract String getSectionDescription();

    protected abstract String getSectionTitle();

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.updateEditComponents();
        this.setDirty(false);
    }
}

