/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.mpowerplayer;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.library.api.API;
import org.eclipse.mtj.core.sdk.device.midp.library.api.APIType;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.Configuration;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.Profile;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.Messages;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.MpowerplayerDevice;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.MpowerplayerPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpowerplayerDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String MACOSX_OS_NAME = "Mac OS X";
    private static String osName = System.getProperty("os.name");
    private static final String PLAYER_JAR_NAME = "player.jar";
    private static final String PLAYER_MACOSX_PREVERIFIER = "/osx/preverify";
    private static final String PLAYER_MAIN_CLASS = "com.mpp.player.PowerPlayerApp";
    private static final String PROPS_FILE = "mpowerplayer.properties";

    public List<IDevice> importDevices(File file, IProgressMonitor iProgressMonitor) {
        ArrayList<IDevice> arrayList = null;
        try {
            IDevice iDevice;
            File file2 = new File(file, PLAYER_JAR_NAME);
            if (file2.exists() && this.hasMainClassAttribute(file2, PLAYER_MAIN_CLASS) && (iDevice = this.createDevice(file2)) != null) {
                arrayList = new ArrayList<IDevice>(1);
                arrayList.add(iDevice);
            }
        }
        catch (Exception exception) {
            MTJCore.log((int)2, (String)Messages.MpowerplayerDeviceImporter_import_error, (Throwable)exception);
        }
        return arrayList;
    }

    private void addMplayerDeviceLibraries(File file, IDeviceClasspath iDeviceClasspath, ILibraryImporter iLibraryImporter) {
        String[] stringArray;
        String string = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mpproot", file.getParent());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray2 = stringArray = string.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            ILibrary iLibrary = iLibraryImporter.createLibraryFor(new File(string2));
            API aPI = iLibrary.getAPI(APIType.UNKNOWN);
            if (aPI != null) {
                if (aPI.getIdentifier().equalsIgnoreCase("cldc-1.1.jar")) {
                    aPI.setIdentifier(Configuration.CLDC_11.getIdentifier());
                    aPI.setType(APIType.CONFIGURATION);
                    aPI.setName(Configuration.CLDC_11.getName());
                    aPI.setVersion(Configuration.CLDC_11.getVersion());
                } else if (aPI.getIdentifier().equalsIgnoreCase("midp-2.0.jar")) {
                    aPI.setIdentifier(Profile.MIDP_20.getIdentifier());
                    aPI.setType(APIType.PROFILE);
                    aPI.setName(Profile.MIDP_20.getName());
                    aPI.setVersion(Profile.MIDP_20.getVersion());
                }
            }
            iDeviceClasspath.addEntry(iLibrary);
            ++n2;
        }
    }

    private IDevice createDevice(File file) {
        MpowerplayerDevice mpowerplayerDevice = new MpowerplayerDevice();
        mpowerplayerDevice.setBundle(MpowerplayerPlugin.getDefault().getBundle().getSymbolicName());
        mpowerplayerDevice.setClasspath(this.getDeviceClasspath(file));
        mpowerplayerDevice.setDebugServer(this.isDebugServer());
        mpowerplayerDevice.setDescription("Mpowerplayer Device");
        mpowerplayerDevice.setDeviceProperties(new Properties());
        mpowerplayerDevice.setGroupName("Mpowerplayer");
        mpowerplayerDevice.setName("Mpowerplayer");
        mpowerplayerDevice.setPreverifier(this.getPreverifier(file));
        mpowerplayerDevice.setProtectionDomains(new String[0]);
        mpowerplayerDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        mpowerplayerDevice.setMppRoot(file.getParentFile());
        return mpowerplayerDevice;
    }

    private File findEmbeddedPreverifyExtecutable(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isDirectory() || string.equals("preverify");
            }
        });
        File file2 = null;
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file3 = fileArray2[n2];
            if (!file3.isDirectory()) {
                file2 = file3;
                break;
            }
            file2 = this.findEmbeddedPreverifyExtecutable(file3);
            ++n2;
        }
        return file2;
    }

    private IDeviceClasspath getDeviceClasspath(File file) {
        IDeviceClasspath iDeviceClasspath = MTJCore.createNewDeviceClasspath();
        ILibraryImporter iLibraryImporter = MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei");
        this.addMplayerDeviceLibraries(file, iDeviceClasspath, iLibraryImporter);
        return iDeviceClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return MpowerplayerPlugin.getDefault().getBundle().getEntry(PROPS_FILE);
    }

    protected IPreverifier getPreverifier(File file) {
        File file2;
        File file3;
        IPreverifier iPreverifier = super.getPreverifier(file);
        if (osName.equals(MACOSX_OS_NAME) && (file3 = this.findEmbeddedPreverifyExtecutable(file2 = new File(String.valueOf(file.getParentFile().getPath()) + PLAYER_MACOSX_PREVERIFIER))) != null) {
            try {
                iPreverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)file3);
            }
            catch (CoreException coreException) {
                MTJCore.log((int)2, (String)Messages.MpowerplayerDeviceImporter_preverifier_import_error, (Throwable)coreException);
            }
        }
        return iPreverifier;
    }
}

