/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.ArchiveEntryMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import java.io.File;
import javax.swing.Icon;

public class RfsEntry
implements ArchiveEntry {
    private final String entryName;
    private final File file;

    public RfsEntry(File file) {
        this(file, RfsEntry.getName(file));
    }

    public RfsEntry(File file, String entryName) {
        if (entryName == null || file == null) {
            throw new NullPointerException();
        }
        this.entryName = entryName;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static String getName(File file) {
        String entryName = file.getPath().replace(File.separatorChar, '/');
        if (file.isDirectory()) {
            return entryName + '/';
        }
        return entryName;
    }

    public String getName() {
        return this.entryName;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long getSize() {
        return this.file.length();
    }

    public long getTime() {
        return this.file.lastModified();
    }

    public void setTime(long time) {
        this.file.setLastModified(time);
    }

    public Icon getOpenIcon() {
        return null;
    }

    public Icon getClosedIcon() {
        return null;
    }

    public ArchiveEntryMetaData getMetaData() {
        return null;
    }

    public void setMetaData(ArchiveEntryMetaData metaData) {
    }
}

