/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSpecManipulator {
    private IProject project;
    private IProjectDescription projectDescription;
    private boolean updated;
    private ArrayList<ICommand> commands;

    public BuildSpecManipulator(IProject iProject) throws CoreException {
        this.project = iProject;
        this.projectDescription = iProject.getDescription();
    }

    public void addBuilderAfter(String string, String string2, Map<?, ?> map) throws CoreException {
        ArrayList<ICommand> arrayList = this.getCommands();
        ICommand iCommand = this.newCommand(string2, map);
        int n = this.indexOf(string);
        if (n == -1 || n == arrayList.size() - 1) {
            arrayList.add(iCommand);
        } else {
            arrayList.add(n + 1, iCommand);
        }
        this.updated = true;
    }

    public void addBuilderBefore(String string, String string2, Map<?, ?> map) throws CoreException {
        ArrayList<ICommand> arrayList = this.getCommands();
        ICommand iCommand = this.newCommand(string2, map);
        int n = this.indexOf(string);
        if (n == -1 || arrayList.size() == 0) {
            arrayList.add(iCommand);
        } else {
            arrayList.add(n, iCommand);
        }
        this.updated = true;
    }

    public void commitChanges(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.updated) {
            IProjectDescription iProjectDescription = this.project.getDescription();
            ICommand[] iCommandArray = this.commands.toArray(new ICommand[this.commands.size()]);
            iProjectDescription.setBuildSpec(iCommandArray);
            this.project.setDescription(iProjectDescription, iProgressMonitor);
            this.updated = false;
        }
    }

    public boolean hasArguments(String string) throws CoreException {
        boolean bl = false;
        int n = this.indexOf(string);
        if (n != -1) {
            ICommand iCommand = this.getCommands().get(n);
            Map map = iCommand.getArguments();
            bl = map != null && map.size() > 0;
        }
        return bl;
    }

    public boolean hasBuilder(String string) throws CoreException {
        return this.indexOf(string) != -1;
    }

    public int indexOf(String string) throws CoreException {
        int n = -1;
        ArrayList<ICommand> arrayList = this.getCommands();
        if (arrayList.size() > 0) {
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ICommand iCommand = arrayList.get(n2);
                if (iCommand.getBuilderName().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    public void replaceBuilder(String string, Map<?, ?> map) throws CoreException {
        ArrayList<ICommand> arrayList = this.getCommands();
        ICommand iCommand = this.newCommand(string, map);
        int n = this.indexOf(string);
        if (n != -1) {
            arrayList.set(n, iCommand);
            this.updated = true;
        }
    }

    public void removeBuilder(String string) throws CoreException {
        int n = this.indexOf(string);
        if (n != -1) {
            this.getCommands().remove(n);
            this.updated = true;
        }
    }

    private ICommand newCommand(String string, Map<?, ?> map) {
        ICommand iCommand = this.projectDescription.newCommand();
        iCommand.setBuilderName(string);
        if (map != null) {
            iCommand.setArguments(map);
        }
        return iCommand;
    }

    private ArrayList<ICommand> getCommands() throws CoreException {
        if (this.commands == null) {
            ICommand[] iCommandArray = this.projectDescription.getBuildSpec();
            this.commands = new ArrayList(Arrays.asList(iCommandArray));
        }
        return this.commands;
    }
}

