/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.IPreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationError;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocationType;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorType;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierParameters;
import org.eclipse.mtj.internal.core.util.EnvironmentVariables;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardPreverifier
implements IPreverifier {
    private BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    private static final int MAX_COMMAND_LENGTH = 2000;
    private static final String PREV_ERR_REGEX = "^Error preverifying class (\\S*)$";
    private static final Pattern PREV_ERR_PATTERN = Pattern.compile("^Error preverifying class (\\S*)$", 8);
    private StandardPreverifierParameters parameters;
    private File preverifierExecutable;
    public static final String BUILD_ARG_PREVERIFY_TARGET = "preverifyTargetProject";
    public static final String BUILD_ARG_PREVERIFY_LIBS = "preverifyLibraries";
    public static final String BUILD_ARG_PREVERIFY_CLASSES = "preverifyClasses";

    public static String extractClassName(IJavaProject iJavaProject, IResource iResource) throws JavaModelException {
        IPath iPath = StandardPreverifier.extractResourcePath(iJavaProject, iResource);
        return iPath == null ? null : iPath.removeFileExtension().toString().replace('/', '.');
    }

    public static IPath extractResourcePath(IJavaProject iJavaProject, IResource iResource) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray;
        IPath iPath = null;
        IPath iPath2 = iJavaProject.getOutputLocation().makeAbsolute();
        IPath iPath3 = iResource.getFullPath();
        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
            if (iClasspathEntry.getEntryKind() == 3) {
                IPath iPath4 = iClasspathEntry.getOutputLocation();
                IPath iPath5 = iPath4 = iPath4 == null ? iPath2 : iPath4.makeAbsolute();
                if (iPath4.isPrefixOf(iPath3)) {
                    iPath = iPath3.removeFirstSegments(iPath4.segmentCount());
                }
            }
            ++n2;
        }
        return iPath;
    }

    public StandardPreverifierParameters getParameters() {
        return this.parameters;
    }

    @Override
    public File getPreverifierExecutable() {
        return this.preverifierExecutable;
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String string = iPersistenceProvider.loadString("preverifierExecutable");
        this.preverifierExecutable = new File(string);
        this.parameters = (StandardPreverifierParameters)iPersistenceProvider.loadPersistable("parameters");
    }

    @Override
    public IPreverificationError[] preverify(IMTJProject iMTJProject, IResource[] iResourceArray, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        String[] stringArray;
        ArrayList arrayList = new ArrayList();
        this.ensureFolderExists(iFolder, iProgressMonitor);
        File file = iFolder.getLocation().toFile();
        ArrayList<String> arrayList2 = this.constructCommandLine(iMTJProject, file, iProgressMonitor);
        ArrayList<String> arrayList3 = new ArrayList<String>(arrayList2);
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray = iResourceArray2[n2];
            switch (stringArray.getType()) {
                case 2: 
                case 4: {
                    arrayList3.add(stringArray.getLocation().toOSString());
                    break;
                }
                case 1: {
                    if (stringArray.getName().endsWith(".class")) {
                        this.addClassTarget(arrayList3, (IResource)stringArray);
                        break;
                    }
                    if (!stringArray.getName().endsWith(".jar")) break;
                    arrayList3.add(stringArray.getLocation().toOSString());
                }
            }
            if (this.commandLength(arrayList3) > 2000) {
                String[] stringArray2 = arrayList3.toArray(new String[arrayList3.size()]);
                IPreverificationError[] iPreverificationErrorArray = this.runPreverifier(stringArray2, null, iProgressMonitor);
                arrayList.addAll(Arrays.asList(iPreverificationErrorArray));
                arrayList3 = new ArrayList<String>(arrayList2);
            }
            ++n2;
        }
        if (arrayList3.size() != arrayList2.size()) {
            stringArray = arrayList3.toArray(new String[arrayList3.size()]);
            IPreverificationError[] iPreverificationErrorArray = this.runPreverifier(stringArray, null, iProgressMonitor);
            arrayList.addAll(Arrays.asList(iPreverificationErrorArray));
        }
        return arrayList.toArray(new IPreverificationError[arrayList.size()]);
    }

    @Override
    public IPreverificationError[] preverifyJarFile(IMTJProject iMTJProject, File file, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        File file2 = TemporaryFileManager.instance.createTempDirectory(String.valueOf(file.getName().replace('.', '_')) + "_", ".tmp");
        file2.mkdirs();
        Utils.extractArchive(file, file2);
        File file3 = TemporaryFileManager.instance.createTempDirectory(String.valueOf(file.getName().replace('.', '_')) + "_", ".tmp");
        file3.mkdirs();
        ArrayList<String> arrayList = this.constructCommandLine(iMTJProject, file3, iProgressMonitor);
        arrayList.add(file2.toString());
        String[] stringArray = this.getEnvironment(file);
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        IPreverificationError[] iPreverificationErrorArray = this.runPreverifier(stringArray2, stringArray, iProgressMonitor);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || !file.getName().endsWith(".class");
            }
        };
        Utils.copy(file2, file3, fileFilter);
        File file4 = new File(iFolder.getLocation().toFile(), file.getName());
        Utils.createArchive(file4, file3);
        return iPreverificationErrorArray;
    }

    public void setParameters(StandardPreverifierParameters standardPreverifierParameters) {
        this.parameters = standardPreverifierParameters;
    }

    public void setPreverifierExecutable(File file) {
        this.preverifierExecutable = file;
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString("preverifierExecutable", this.preverifierExecutable.toString());
        iPersistenceProvider.storePersistable("parameters", this.parameters);
    }

    private void addClasspath(ArrayList<String> arrayList, IMTJProject iMTJProject, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = this.getFullClasspath(iMTJProject);
        arrayList.add("-classpath");
        arrayList.add(string);
    }

    private void addClassTarget(List<String> list, IResource iResource) throws JavaModelException {
        IProject iProject = iResource.getProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        String string = StandardPreverifier.extractClassName(iJavaProject, iResource);
        if (string != null) {
            list.add(string);
        }
    }

    private void addOptions(ArrayList<String> arrayList, String[] stringArray, File file) {
        arrayList.add("-d");
        arrayList.add(file.toString());
    }

    private int commandLength(ArrayList<String> arrayList) {
        int n = 0;
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            n += string.toString().length();
            if (!iterator.hasNext()) continue;
            ++n;
        }
        return n;
    }

    private ArrayList<String> constructCommandLine(IMTJProject iMTJProject, File file, IProgressMonitor iProgressMonitor) throws CoreException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.preverifierExecutable.toString());
        String[] stringArray2 = stringArray = this.getCLDCConfigurationParameters(iMTJProject);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            arrayList.add(string);
            ++n2;
        }
        this.addClasspath(arrayList, iMTJProject, iProgressMonitor);
        this.addOptions(arrayList, stringArray, file);
        return arrayList;
    }

    private void ensureFolderExists(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iFolder.exists()) {
            iFolder.create(true, true, iProgressMonitor);
        }
    }

    private String[] getEnvironment(File file) throws CoreException {
        String[] stringArray = null;
        if (file != null && !this.isJarExecutableOnPath()) {
            IVMInstall iVMInstall = this.searchForVMInstallWithJar();
            if (iVMInstall == null) {
                IStatus iStatus = MTJCore.newStatus(4, 102, "Could not find jar tool executable.");
                MTJCore.statusPrompt(iStatus, this);
            } else {
                String string = new File(iVMInstall.getInstallLocation(), "bin").toString();
                stringArray = this.getEnvironmentWithAugmentedPath(string);
            }
        }
        return stringArray;
    }

    private String[] getEnvironmentWithAugmentedPath(String string) throws CoreException {
        String[] stringArray = null;
        try {
            EnvironmentVariables environmentVariables = new EnvironmentVariables();
            String string2 = environmentVariables.getVariable("PATH");
            string2 = String.valueOf(string2) + File.pathSeparator + string;
            environmentVariables.setVariable("PATH", string2);
            stringArray = environmentVariables.convertToStrings();
        }
        catch (IOException iOException) {
            MTJCore.throwCoreException(4, -999, iOException);
        }
        return stringArray;
    }

    private String getFullClasspath(IMTJProject iMTJProject) throws CoreException {
        IJavaProject iJavaProject = iMTJProject.getJavaProject();
        String[] stringArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)iJavaProject);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getJarExecutable() {
        String string = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        string = string2.indexOf("windows 9") > -1 || string2.indexOf("nt") > -1 || string2.indexOf("windows 2000") > -1 || string2.indexOf("windows xp") > -1 ? "jar.exe" : "jar";
        return string;
    }

    private boolean installContainsJarExecutable(IVMInstall iVMInstall) {
        File file;
        boolean bl = false;
        File file2 = iVMInstall.getInstallLocation();
        if (file2 != null && (file = new File(file2, "bin")).exists()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().startsWith("jar");
                }
            });
            bl = fileArray != null && fileArray.length > 0;
        }
        return bl;
    }

    private boolean isJarExecutableOnPath() throws CoreException {
        boolean bl = false;
        String string = this.getJarExecutable();
        try {
            EnvironmentVariables environmentVariables = new EnvironmentVariables();
            String string2 = environmentVariables.getVariable("PATH");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File file2 = new File(file, string);
                if (!file2.exists()) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            MTJCore.throwCoreException(4, -999, iOException);
        }
        return bl;
    }

    private IVMInstall searchForVMInstallWithJar() {
        IVMInstall iVMInstall = null;
        IVMInstall iVMInstall2 = JavaRuntime.getDefaultVMInstall();
        if (this.installContainsJarExecutable(iVMInstall2)) {
            iVMInstall = iVMInstall2;
        } else {
            IVMInstall[] iVMInstallArray;
            IVMInstallType iVMInstallType = iVMInstall2.getVMInstallType();
            IVMInstall[] iVMInstallArray2 = iVMInstallArray = iVMInstallType.getVMInstalls();
            int n = iVMInstallArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall iVMInstall3 = iVMInstallArray2[n2];
                iVMInstall2 = iVMInstall3;
                if (this.installContainsJarExecutable(iVMInstall2)) {
                    iVMInstall = iVMInstall2;
                    break;
                }
                ++n2;
            }
        }
        return iVMInstall;
    }

    protected String[] getCLDCConfigurationParameters(IMTJProject iMTJProject) throws CoreException {
        IProject iProject = iMTJProject.getProject();
        Version version = PreferenceAccessor.instance.getPreverificationConfigurationVersion(iProject);
        return this.isCLDC1_0(version) ? this.parameters.cldc10 : this.parameters.cldc11;
    }

    protected void handleErrorReceived(String string, List<IPreverificationError> list) {
        Matcher matcher = PREV_ERR_PATTERN.matcher(string = string.trim());
        if (matcher.find()) {
            if (matcher.groupCount() > 0) {
                Object object;
                Object object2;
                final String string2 = matcher.group(1);
                String string3 = "Error preverifying class";
                if (matcher.end() < string.length()) {
                    object2 = new StringBuffer(string3);
                    ((StringBuffer)object2).append(": ");
                    object = string.substring(matcher.end());
                    object = ((String)object).trim();
                    ((StringBuffer)object2).append((String)object);
                    string3 = ((StringBuffer)object2).toString();
                }
                object2 = new IClassErrorInformation(){

                    public String getName() {
                        return string2;
                    }

                    public String getSourceFile() {
                        return null;
                    }
                };
                object = new PreverificationErrorLocation(PreverificationErrorLocationType.UNKNOWN_LOCATION, (IClassErrorInformation)object2);
                PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.UNKNOWN_ERROR, (IPreverificationErrorLocation)object, string);
                list.add(preverificationError);
            }
        } else {
            MTJCore.log(2, string);
        }
    }

    protected boolean isCLDC1_0(Version version) {
        return version.getMajor() == 1 && version.getMinor() == 0;
    }

    protected IPreverificationError[] runPreverifier(String[] stringArray, String[] stringArray2, IProgressMonitor iProgressMonitor) throws CoreException {
        final ArrayList arrayList = new ArrayList();
        IProcess iProcess = Utils.launchApplication(stringArray, null, stringArray2, "Preverifier", "CLDC Preverifier");
        IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            this.consoleProxy.traceln("======================== Launching Preverification =========================");
            this.consoleProxy.addConsoleStreamListener(IBuildConsoleProxy.Stream.ERROR, iStreamsProxy.getErrorStreamMonitor());
            this.consoleProxy.addConsoleStreamListener(IBuildConsoleProxy.Stream.OUTPUT, iStreamsProxy.getOutputStreamMonitor());
        }
        iStreamsProxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
                StandardPreverifier.this.handleErrorReceived(string, arrayList);
            }
        });
        while (!iProgressMonitor.isCanceled() && !iProcess.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            this.consoleProxy.traceln("======================== Preverification exited with code: " + iProcess.getExitValue());
        }
        return arrayList.toArray(new IPreverificationError[arrayList.size()]);
    }
}

