/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.IPreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationUtils;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuildInfo;
import org.eclipse.mtj.internal.core.build.preverifier.builder.PreverificationBuilder;
import org.eclipse.mtj.internal.core.util.AbstractClasspathEntryVisitor;
import org.eclipse.mtj.internal.core.util.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.internal.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceDeltaBuilder {
    private static final String MANIFEST_FILE_NAME = "META-INF" + File.separator + "MANIFEST.MF";
    private BuildInfo buildInfo;
    private BuildLoggingConfiguration buildLoggingConfig;
    private BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    private List<IResource> removedClasses;
    private IWorkspaceRoot workspaceRoot;

    public ResourceDeltaBuilder(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        this.buildLoggingConfig = BuildLoggingConfiguration.getInstance();
        this.workspaceRoot = MTJCore.getWorkspace().getRoot();
    }

    private void addFileToRuntimeJar(IPath iPath, IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File((File)this.buildInfo.getRuntimeJarFile(iProgressMonitor), iPath.toString());
        file.copyFrom(iFile.getLocation().toFile());
    }

    private void attemptLibraryPreverification(IResource iResource, de.schlichtherle.io.File file, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        this.buildInfo.setPackageDirty(true);
        try {
            IPreverificationError[] iPreverificationErrorArray = this.buildInfo.getMidletSuite().preverifyJarFile((File)file, iFolder, iProgressMonitor);
            if (iPreverificationErrorArray.length > 0) {
                this.createJarErrorMarker(iResource, file, iPreverificationErrorArray);
            } else {
                de.schlichtherle.io.File file2 = new de.schlichtherle.io.File(iFolder.getLocation().toString());
                if (file.isFile() || file.isArchive()) {
                    file2 = new de.schlichtherle.io.File((File)file2, file.getName());
                }
                FileFilter fileFilter = new FileFilter(){

                    public boolean accept(File file) {
                        String string = file.getPath();
                        return !string.toUpperCase().endsWith(MANIFEST_FILE_NAME);
                    }
                };
                this.copyAll(fileFilter, file2, this.buildInfo.getRuntimeJarFile(iProgressMonitor));
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file2);
            }
        }
        catch (IOException iOException) {
            MTJCore.throwCoreException(4, -999, iOException);
        }
    }

    private void clearContainer(BuildInfo buildInfo, IContainer iContainer, IProgressMonitor iProgressMonitor) throws CoreException {
        Utils.clearContainer(iContainer, iProgressMonitor);
        buildInfo.setPackageDirty(true);
    }

    private void collectClassesAndResources(List<IResource> list, List<IResource> list2, IResource iResource, IPath[] iPathArray) throws CoreException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.collectClassesAndResources; resource = " + iResource);
        }
        if (iResource.getType() == 1) {
            if (!this.isLibraryResource(iPathArray, iResource)) {
                IFile iFile = (IFile)iResource;
                if ("class".equals(iFile.getFileExtension())) {
                    list.add(iResource);
                } else {
                    list2.add(iResource);
                }
            }
        } else {
            IResource[] iResourceArray;
            IContainer iContainer = (IContainer)iResource;
            IResource[] iResourceArray2 = iResourceArray = iContainer.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource2 = iResourceArray2[n2];
                this.collectClassesAndResources(list, list2, iResource2, iPathArray);
                ++n2;
            }
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.collectClassesAndResources");
        }
    }

    private IPath[] collectLibraryFolderPaths(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.collectLibraryFolderPaths");
        }
        LibraryCollectionVisitor libraryCollectionVisitor = new LibraryCollectionVisitor();
        libraryCollectionVisitor.getRunner().run(this.buildInfo.getCurrentJavaProject(), libraryCollectionVisitor, iProgressMonitor);
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        for (IClasspathEntry iClasspathEntry : libraryCollectionVisitor.getLibraryEntries()) {
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(Utils.getResolvedClasspathEntryFile(iClasspathEntry));
            if (!file.isDirectory()) continue;
            arrayList.add(iClasspathEntry.getPath().makeAbsolute());
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.collectLibraryFolderPaths");
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private void copyAll(FileFilter fileFilter, de.schlichtherle.io.File file, de.schlichtherle.io.File file2) throws IOException {
        if (file.isFile() && !file.isArchive()) {
            file2.copyFrom((File)file);
        } else {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles(fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray2[n2];
                this.copyAll(fileFilter, new de.schlichtherle.io.File(file3), new de.schlichtherle.io.File((File)file2, file3.getName()));
                ++n2;
            }
        }
    }

    private void createErrorMarkerFor(IPreverificationError iPreverificationError) throws JavaModelException, CoreException {
        IResource iResource;
        IMarker iMarker = null;
        IClassErrorInformation iClassErrorInformation = ((IPreverificationErrorLocation)iPreverificationError.getLocation()).getClassInformation();
        String string = iClassErrorInformation == null ? "" : iClassErrorInformation.getName().replace('/', '.');
        String string2 = PreverificationUtils.getErrorText(iPreverificationError);
        IType iType = this.buildInfo.getCurrentJavaProject().findType(string);
        if (iType != null && (iResource = iType.getResource()) != null) {
            iMarker = iResource.createMarker("org.eclipse.jdt.core.problem");
            iMarker.setAttribute("message", (Object)string2);
            iMarker.setAttribute("severity", 2);
            int n = ((IPreverificationErrorLocation)iPreverificationError.getLocation()).getLineNumber();
            if (n != -1) {
                iMarker.setAttribute("lineNumber", n);
            }
            this.setMarkerRangeAttributes(iMarker, iPreverificationError, iType);
        }
        if (iMarker == null) {
            this.createProjectLevelPreverifyMarker(string, string2);
        }
    }

    private void createJarErrorMarker(IResource iResource, de.schlichtherle.io.File file, IPreverificationError[] iPreverificationErrorArray) throws CoreException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("Preverification errors:\n");
        IPreverificationError[] iPreverificationErrorArray2 = iPreverificationErrorArray;
        int n = iPreverificationErrorArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iPreverificationErrorArray2[n2];
            stringBuffer.append(PreverificationUtils.getErrorText((IPreverificationError)object)).append("\n");
            ++n2;
        }
        object = iResource.createMarker("org.eclipse.jdt.core.problem");
        object.setAttribute("message", (Object)stringBuffer.toString());
        object.setAttribute("severity", 2);
    }

    private void createProjectLevelPreverifyMarker(String string, String string2) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer("Type ");
        stringBuffer.append(string).append(" ").append(string2);
        IProject iProject = this.buildInfo.getCurrentJavaProject().getProject();
        IMarker iMarker = iProject.createMarker("org.eclipse.jdt.core.problem");
        iMarker.setAttribute("message", (Object)stringBuffer.toString());
        iMarker.setAttribute("severity", 2);
    }

    private boolean doClassesRequirePreverification(de.schlichtherle.io.File file, de.schlichtherle.io.File file2) {
        boolean bl = false;
        if (file.isDirectory()) {
            if (!file2.exists()) {
                bl = true;
            } else {
                File[] fileArray;
                File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().endsWith(".class");
                    }
                });
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file3 = fileArray2[n2];
                    de.schlichtherle.io.File file4 = new de.schlichtherle.io.File(file3);
                    de.schlichtherle.io.File file5 = new de.schlichtherle.io.File((File)file2, file3.getName());
                    bl = this.doClassesRequirePreverification(file4, file5);
                    if (!bl) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            bl = this.isSourceNewerThanTarget(file, file2);
        }
        return bl;
    }

    private IPath[] getOutputLocations(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        OutputLocationsCollectionVisitor outputLocationsCollectionVisitor = new OutputLocationsCollectionVisitor();
        outputLocationsCollectionVisitor.getRunner().run(iJavaProject, outputLocationsCollectionVisitor, iProgressMonitor);
        Set<IPath> set = outputLocationsCollectionVisitor.getOutputLocations();
        return set.toArray(new IPath[set.size()]);
    }

    private void handleClassAddsAndChanges(List<IResource> list, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.handleClassAddsAndChanges; classFiles count = " + list.size());
        }
        if (list.size() > 0) {
            IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
            try {
                IPreverificationError iPreverificationError;
                IFolder iFolder = this.buildInfo.getVerifiedClassesFolder(iProgressMonitor);
                IPreverificationError[] iPreverificationErrorArray = this.buildInfo.getMidletSuite().preverify(iResourceArray, iFolder, iProgressMonitor);
                iFolder.refreshLocal(2, iProgressMonitor);
                IPreverificationError[] iPreverificationErrorArray2 = iPreverificationErrorArray;
                int n = iPreverificationErrorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    iPreverificationError = iPreverificationErrorArray2[n2];
                    this.createErrorMarkerFor(iPreverificationError);
                    ++n2;
                }
                iPreverificationErrorArray2 = iResourceArray;
                n = iResourceArray.length;
                n2 = 0;
                while (n2 < n) {
                    iPreverificationError = iPreverificationErrorArray2[n2];
                    IFile iFile = (IFile)iPreverificationError;
                    IPath iPath = Utils.extractsSourceFolderRelativePath(this.buildInfo.getCurrentJavaProject(), (IResource)iFile);
                    IFile iFile2 = iFolder.getFile(iPath);
                    if (iFile2.exists()) {
                        this.addFileToRuntimeJar(iPath, iFile2, iProgressMonitor);
                    }
                    ++n2;
                }
                this.buildInfo.setPackageDirty(true);
            }
            catch (IOException iOException) {
                MTJCore.throwCoreException(4, -999, iOException);
            }
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.handleClassAddsAndChanges");
        }
    }

    private void handleNonClassAddOrChange(IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath;
        if (iFile.exists() && this.buildInfo.getResourceFilter().shouldBeIncluded(iFile) && (iPath = Utils.extractsSourceFolderRelativePath(this.buildInfo.getCurrentJavaProject(), (IResource)iFile)) != null) {
            this.addFileToRuntimeJar(iPath, iFile, iProgressMonitor);
            this.buildInfo.setPackageDirty(true);
        }
    }

    private void handleNonClassAddsAndChanges(List<IResource> list, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.handleResourceAddsAndChanges; resource count = " + list.size());
        }
        if (list.size() > 0) {
            for (IFile iFile : list) {
                this.handleNonClassAddOrChange(iFile, iProgressMonitor);
            }
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.handleResourceAddsAndChanges");
        }
    }

    private void handleNullDelta(IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.handleNullDelta");
        }
        IPath[] iPathArray = this.getOutputLocations(this.buildInfo.getCurrentJavaProject(), iProgressMonitor);
        IPath[] iPathArray2 = this.collectLibraryFolderPaths(iProgressMonitor);
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        ArrayList<IResource> arrayList2 = new ArrayList<IResource>();
        IPath[] iPathArray3 = iPathArray;
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath iPath = iPathArray3[n2];
            IResource iResource = this.workspaceRoot.findMember(iPath.makeAbsolute());
            if (iResource != null) {
                this.collectClassesAndResources(arrayList, arrayList2, iResource, iPathArray2);
            }
            ++n2;
        }
        this.handleClassAddsAndChanges(arrayList, iProgressMonitor);
        this.handleNonClassAddsAndChanges(arrayList2, iProgressMonitor);
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.handleNullDelta");
        }
    }

    private void handleRemoves(List<IResource> list, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.handleRemoves; resource count = " + list.size());
        }
        if (list.size() > 0) {
            IFolder iFolder = this.buildInfo.getVerifiedClassesFolder(iProgressMonitor);
            for (IResource iResource : list) {
                this.removeVerifiedResource(this.buildInfo.getCurrentJavaProject(), iFolder, iResource, iProgressMonitor);
            }
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.handleRemoves");
        }
    }

    private void handleResourceDelta(IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.handleResourceDelta");
        }
        ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor(iProgressMonitor);
        this.buildInfo.getCurrentResourceDelta().accept((IResourceDeltaVisitor)resourceDeltaVisitor, false);
        if (this.buildInfo.areClassesPreverified()) {
            this.handleRemoves(resourceDeltaVisitor.getRemovedClasses(), iProgressMonitor);
            this.handleClassAddsAndChanges(resourceDeltaVisitor.getAddedOrChangedClasses(), iProgressMonitor);
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.handleResourceDelta");
        }
    }

    private boolean isLibraryResource(IPath[] iPathArray, IResource iResource) {
        boolean bl = false;
        IPath[] iPathArray2 = iPathArray;
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath iPath = iPathArray2[n2];
            if (iPath.isPrefixOf(iResource.getFullPath())) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private boolean isSourceNewerThanTarget(de.schlichtherle.io.File file, de.schlichtherle.io.File file2) {
        return !file2.exists() || file2.lastModified() < file.lastModified();
    }

    private void removeFileFromRuntimeJar(IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iPath != null) {
            de.schlichtherle.io.File file = new de.schlichtherle.io.File((File)this.buildInfo.getRuntimeJarFile(iProgressMonitor), iPath.toString());
            file.delete();
        }
    }

    private void removeVerifiedResource(IJavaProject iJavaProject, IFolder iFolder, IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath = Utils.extractsSourceFolderRelativePath(iJavaProject, iResource);
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.deleteVerifiedResource; resource = " + iResource + "; pathToResource = " + iPath);
        }
        if (iPath != null) {
            IResource iResource2 = iFolder.findMember(iPath);
            if (iResource2 != null && iResource2.exists()) {
                iResource2.delete(true, iProgressMonitor);
            }
            this.removeFileFromRuntimeJar(iPath, iProgressMonitor);
            this.buildInfo.setPackageDirty(true);
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.deleteVerifiedResource");
        }
    }

    private void setMarkerRangeAttributes(IMarker iMarker, IPreverificationError iPreverificationError, IType iType) throws CoreException {
        int n = 1;
        int n2 = 1;
        switch (((IPreverificationErrorLocation)iPreverificationError.getLocation()).getLocationType().getTypeCode()) {
            case 0: {
                ISourceRange iSourceRange = iType.getNameRange();
                n = iSourceRange.getOffset();
                n2 = n + iSourceRange.getLength();
            }
        }
        iMarker.setAttribute("charStart", n);
        iMarker.setAttribute("charEnd", n2);
    }

    void build(IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        IResourceDelta iResourceDelta;
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.build");
        }
        if (this.buildInfo.getBuildKind() == 6 && this.buildInfo.isCurrentProjectMidletSuite()) {
            if (this.buildInfo.areClassesPreverified()) {
                if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
                    this.consoleProxy.traceln("> ResourceDeltaBuilder.build; clearing " + this.buildInfo.getVerifiedClassesFolder(iProgressMonitor));
                }
                this.clearContainer(this.buildInfo, (IContainer)this.buildInfo.getVerifiedClassesFolder(iProgressMonitor), iProgressMonitor);
            }
            if (this.buildInfo.areLibrariesPreverified()) {
                if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
                    this.consoleProxy.traceln("> ResourceDeltaBuilder.build; clearing " + this.buildInfo.getVerifiedLibsFolder(iProgressMonitor));
                }
                this.clearContainer(this.buildInfo, (IContainer)this.buildInfo.getVerifiedLibsFolder(iProgressMonitor), iProgressMonitor);
            }
        }
        if ((iResourceDelta = this.buildInfo.getCurrentResourceDelta()) == null) {
            this.buildInfo.setClasspathChanged(true);
            this.handleNullDelta(iProgressMonitor);
        } else {
            this.handleResourceDelta(iProgressMonitor);
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.build");
        }
    }

    void preverifyLibraries(IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        IFolder iFolder = this.buildInfo.getVerifiedClassesFolder(iProgressMonitor);
        IFolder iFolder2 = this.buildInfo.getVerifiedLibsFolder(iProgressMonitor);
        LibraryCollectionVisitor libraryCollectionVisitor = new LibraryCollectionVisitor();
        libraryCollectionVisitor.getRunner().run(this.buildInfo.getCurrentJavaProject(), libraryCollectionVisitor, iProgressMonitor);
        ArrayList<IClasspathEntry> arrayList = libraryCollectionVisitor.getLibraryEntries();
        for (IClasspathEntry iClasspathEntry : arrayList) {
            Object object = Utils.getResolvedClasspathEntry(iClasspathEntry);
            IResource iResource = object instanceof IResource ? (IResource)object : this.buildInfo.getCurrentJavaProject().getProject();
            IPath iPath = iClasspathEntry.getPath().makeAbsolute();
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(Utils.getResolvedClasspathEntryFile(iClasspathEntry));
            if (file == null || this.buildInfo.hasLibraryBeenPreverified(file)) continue;
            this.buildInfo.addPreverifiedLibrary(file);
            IFolder iFolder3 = null;
            IFolder iFolder4 = null;
            if (file.isDirectory() && !file.isArchive()) {
                iFolder3 = iFolder;
                iFolder4 = iFolder;
            } else {
                iFolder3 = iFolder2.getFile(iPath.lastSegment());
                iFolder4 = iFolder2;
            }
            de.schlichtherle.io.File file2 = new de.schlichtherle.io.File(iFolder3.getLocation().toFile());
            boolean bl = false;
            bl = file.isDirectory() ? this.doClassesRequirePreverification(file, file2) : this.isSourceNewerThanTarget(file, file2);
            if (!bl) continue;
            this.attemptLibraryPreverification(iResource, file, iFolder4, iProgressMonitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryCollectionVisitor
    extends FilteringClasspathEntryVisitor {
        private ArrayList<IClasspathEntry> libraryEntries = new ArrayList();

        private LibraryCollectionVisitor() {
        }

        public ArrayList<IClasspathEntry> getLibraryEntries() {
            return this.libraryEntries;
        }

        @Override
        public void visitLibraryEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            if (this.isLibraryExported(iClasspathEntry)) {
                this.libraryEntries.add(iClasspathEntry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputLocationsCollectionVisitor
    extends AbstractClasspathEntryVisitor {
        private Set<IPath> outputLocations = new HashSet<IPath>();

        private OutputLocationsCollectionVisitor() {
        }

        public Set<IPath> getOutputLocations() {
            return this.outputLocations;
        }

        @Override
        public void visitSourceEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            IPath iPath = iClasspathEntry.getOutputLocation();
            if (iPath == null) {
                iPath = iJavaProject.getOutputLocation();
            }
            this.outputLocations.add(iPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private List<IResource> addedOrChangedClasses;
        private IFile jadFile;
        private IPath[] libraryPaths;
        private IProgressMonitor monitor;

        ResourceDeltaVisitor(IProgressMonitor iProgressMonitor) throws CoreException {
            this.monitor = iProgressMonitor;
            this.addedOrChangedClasses = new ArrayList<IResource>();
            ResourceDeltaBuilder.this.removedClasses = new ArrayList();
            this.jadFile = ResourceDeltaBuilder.this.buildInfo.getMidletSuite().getApplicationDescriptorFile();
            this.libraryPaths = ResourceDeltaBuilder.this.collectLibraryFolderPaths(iProgressMonitor);
        }

        public List<IResource> getAddedOrChangedClasses() {
            return this.addedOrChangedClasses;
        }

        public List<IResource> getRemovedClasses() {
            return ResourceDeltaBuilder.this.removedClasses;
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            if (iResource.getType() == 1) {
                if (iResource.getName().equals(".classpath")) {
                    ResourceDeltaBuilder.this.buildInfo.setClasspathChanged(true);
                } else if (iResource.equals((Object)this.jadFile)) {
                    PreverificationBuilder.generateDeployedManifest(ResourceDeltaBuilder.this.buildInfo.getMidletSuite(), this.monitor);
                    ResourceDeltaBuilder.this.buildInfo.setPackageDirty(true);
                } else {
                    String string = iResource.getFileExtension();
                    if (string != null && string.equals("class")) {
                        this.handleClassDelta(iResourceDelta, iResource);
                    } else {
                        this.handleNonClassResource(iResourceDelta, iResource);
                    }
                }
            }
            return true;
        }

        private void handleClassDelta(IResourceDelta iResourceDelta, IResource iResource) {
            if (!ResourceDeltaBuilder.this.isLibraryResource(this.libraryPaths, iResource)) {
                switch (iResourceDelta.getKind()) {
                    case 1: 
                    case 4: {
                        if (!ResourceDeltaBuilder.this.buildInfo.isOutputResource(iResource)) break;
                        this.addedOrChangedClasses.add(iResource);
                        break;
                    }
                    case 2: {
                        ResourceDeltaBuilder.this.removedClasses.add(iResource);
                    }
                }
            }
        }

        private void handleNonClassResource(IResourceDelta iResourceDelta, IResource iResource) throws CoreException {
            if (iResource.getType() == 1) {
                IFile iFile = (IFile)iResource;
                switch (iResourceDelta.getKind()) {
                    case 1: 
                    case 4: {
                        ResourceDeltaBuilder.this.handleNonClassAddOrChange(iFile, this.monitor);
                        break;
                    }
                    case 2: {
                        IPath iPath = Utils.extractsSourceFolderRelativePath(ResourceDeltaBuilder.this.buildInfo.getCurrentJavaProject(), iResource);
                        ResourceDeltaBuilder.this.removeFileFromRuntimeJar(iPath, this.monitor);
                        ResourceDeltaBuilder.this.removeVerifiedResource(ResourceDeltaBuilder.this.buildInfo.getCurrentJavaProject(), ResourceDeltaBuilder.this.buildInfo.getVerifiedClassesFolder(this.monitor), (IResource)iFile, this.monitor);
                    }
                }
            }
        }
    }
}

