/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.sign;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.sign.JadSignature;
import org.eclipse.mtj.internal.core.build.sign.KeyChainSet;
import org.eclipse.mtj.internal.core.build.sign.SignaturePasswords;
import org.eclipse.mtj.internal.core.project.midp.IJadSignature;

public class SignatureUtils {
    public static IJadSignature getSignatureObject(IMidletSuiteProject iMidletSuiteProject) throws CoreException {
        ISignatureProperties iSignatureProperties = iMidletSuiteProject.getSignatureProperties();
        return SignatureUtils.getSignatureObject(iMidletSuiteProject, iSignatureProperties);
    }

    public static IJadSignature getSignatureObject(IMidletSuiteProject iMidletSuiteProject, ISignatureProperties iSignatureProperties) throws CoreException {
        JadSignature jadSignature;
        block27: {
            FileInputStream fileInputStream;
            block26: {
                Object object;
                if (!iSignatureProperties.getSignProject()) {
                    return null;
                }
                if (iSignatureProperties.getAbsoluteKeyStorePath(iMidletSuiteProject.getProject()) == null) {
                    MTJCore.log(4, Messages.SignatureUtils_noKeystoreConfigured);
                    return null;
                }
                if (iSignatureProperties.getKeyAlias() == null) {
                    MTJCore.log(4, Messages.SignatureUtils_noAliasSelected);
                    return null;
                }
                jadSignature = null;
                fileInputStream = null;
                String string = null;
                String string2 = null;
                switch (iSignatureProperties.getPasswordStorageMethod()) {
                    case 1: 
                    case 2: {
                        string = iSignatureProperties.getKeyStorePassword();
                        string2 = iSignatureProperties.getKeyPassword();
                        break;
                    }
                    default: {
                        if (iMidletSuiteProject == null) break;
                        string = iMidletSuiteProject.getTempKeystorePassword();
                        string2 = iMidletSuiteProject.getTempKeyPassword();
                    }
                }
                boolean bl = false;
                if (string == null || string2 == null) {
                    object = new Status(1, "org.eclipse.mtj.core", 103, Messages.SignatureUtils_passwordDialogTitle, null);
                    SignaturePasswords signaturePasswords = (SignaturePasswords)MTJCore.statusPrompt((IStatus)object, new Object[]{iMidletSuiteProject.getProject(), string, string2});
                    if (signaturePasswords == null) {
                        return null;
                    }
                    string = signaturePasswords.getKeystorePassword();
                    string2 = signaturePasswords.getKeyPassword();
                    bl = true;
                }
                try {
                    try {
                        fileInputStream = new FileInputStream(iSignatureProperties.getAbsoluteKeyStorePath(iMidletSuiteProject.getProject()));
                        object = KeyChainSet.getInstance(fileInputStream, iSignatureProperties.getKeyStoreType(), iSignatureProperties.getKeyStoreProvider(), string, iSignatureProperties.getKeyAlias(), string2);
                        jadSignature = new JadSignature((KeyChainSet)object);
                        jadSignature.checkKeyChainSet();
                        if (!bl) break block26;
                        switch (iSignatureProperties.getPasswordStorageMethod()) {
                            case 1: 
                            case 2: {
                                iSignatureProperties.setKeyPassword(string2);
                                iSignatureProperties.setKeyStorePassword(string);
                                if (iMidletSuiteProject != null) {
                                    iMidletSuiteProject.saveMetaData();
                                }
                                break;
                            }
                            default: {
                                if (iMidletSuiteProject != null) {
                                    iMidletSuiteProject.setTempKeystorePassword(string);
                                    iMidletSuiteProject.setTempKeyPassword(string2);
                                }
                                break;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        MTJCore.throwCoreException(4, 99999, iOException);
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return jadSignature;
    }
}

