/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;

public abstract class JavaEmulatorDeviceImporter
implements IDeviceImporter {
    private static final String ATTR_MAIN_CLASS = "Main-Class";
    protected Properties deviceProperties;

    private Properties readDeviceProperties() {
        Properties properties;
        block15: {
            properties = new Properties();
            InputStream inputStream = null;
            try {
                try {
                    URL uRL = this.getDevicePropertiesURL();
                    inputStream = uRL.openStream();
                    if (inputStream != null) {
                        properties.load(inputStream);
                    }
                }
                catch (IOException iOException) {
                    MTJCore.log(4, Messages.JavaEmulatorDeviceImporter_0, iOException);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    protected Properties getDeviceProperties() {
        if (this.deviceProperties == null) {
            this.deviceProperties = this.readDeviceProperties();
        }
        return this.deviceProperties;
    }

    protected abstract URL getDevicePropertiesURL();

    protected String getLaunchCommand() {
        return this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.LAUNCH_COMMAND.toString(), "");
    }

    protected IPreverifier getPreverifier(File file) {
        return null;
    }

    protected boolean hasMainClassAttribute(File file, String string) throws IOException {
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        String string2 = attributes.getValue(ATTR_MAIN_CLASS);
        return string2 != null && string2.trim().equals(string);
    }

    protected boolean isDebugServer() {
        return this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.DEBUG_SERVER.toString(), Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
    }
}

