/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp.library;

import java.io.File;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.library.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.library.api.API;
import org.eclipse.mtj.internal.core.sdk.device.JavadocDetector;
import org.eclipse.mtj.internal.core.sdk.device.midp.library.APIRegistry;

public class UEILibraryImporter
implements ILibraryImporter {
    public static final String ID = "UEI_LIBRARY_IMPORTER";
    JavadocDetector javadocDetector;

    public ILibrary createLibraryFor(File file) {
        API[] aPIArray = APIRegistry.getAPIs(file);
        ILibrary iLibrary = MTJCore.createNewLibrary();
        iLibrary.setApis(aPIArray);
        iLibrary.setLibraryFile(file);
        if (this.javadocDetector != null) {
            iLibrary.setJavadocURL(this.javadocDetector.detectJavadoc(iLibrary));
        }
        return iLibrary;
    }

    public ILibrary createLibraryFor(File file, IAccessRule[] iAccessRuleArray) {
        API[] aPIArray = APIRegistry.getAPIs(file);
        ILibrary iLibrary = MTJCore.createNewLibrary();
        iLibrary.setAccessRules(iAccessRuleArray);
        iLibrary.setApis(aPIArray);
        iLibrary.setLibraryFile(file);
        return iLibrary;
    }

    public void setJavadocDetector(JavadocDetector javadocDetector) {
        this.javadocDetector = javadocDetector;
    }
}

