/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sign;

import com.ibm.icu.text.SimpleDateFormat;
import de.schlichtherle.io.FileInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyPairInfo;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKeyStoreManager
implements IKeyStoreManager {
    private static final String FILE = "-file";
    private static final String SIGALG_VALUE = "SHA1withRSA";
    private static final String SIGALG = "-sigalg";
    private static final String KEYPASS = "-keypass";
    private static final String DNAME = "-dname";
    private static final String ALIAS = "-alias";
    private static final String KEYALG_VALUE = "RSA";
    private static final String KEYALG = "-keyalg";
    private static final String STORETYPE = "-storetype";
    private static final String COM_SUN_CRYPTO_PROVIER_NAME = "com.sun.crypto.provier.{0}";
    private static final String PROVIDER = "-provider";
    private static final String NEW = "-new";
    private static final String STOREPASS = "-storepass";
    private static final String KEYSTORE = "-keystore";
    private static final String STOREPASSWD = "-storepasswd";
    private static final String KEYTOOL = "keytool";
    private File ksFile;
    private String ksPassword;
    private String ksType;
    private String ksProvider;

    public DefaultKeyStoreManager(File file, String string) {
        if (file == null) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_keyStoreNotNull);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_invalidKeystoreFile);
        }
        if (string == null) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_keystorePasswordNotNull);
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_keystorePasswordEmpty);
        }
        this.ksType = KeyStore.getDefaultType();
        this.ksFile = file;
        this.ksPassword = string;
    }

    @Override
    public void setProvider(String string) {
        if (string != null && string.length() > 0) {
            this.ksProvider = string;
        }
    }

    @Override
    public void setKeystoreType(String string) {
        if (string != null && string.length() > 0) {
            this.ksType = string;
        }
    }

    @Override
    public List<String> getPrivateKeysAliases() throws KeyStoreManagerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            KeyStore keyStore = this.openKeyStore();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) continue;
                arrayList.add(string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            String string = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToAccessKeystoreContent, (Object)keyStoreException.getMessage());
            throw new KeyStoreManagerException(string);
        }
        return arrayList;
    }

    @Override
    public String getCertificateInformation(String string) throws KeyStoreManagerException {
        String string2 = null;
        try {
            KeyStore keyStore = this.openKeyStore();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (!string3.equals(string)) continue;
                Certificate certificate = keyStore.getCertificate(string);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
                String string4 = this.buildFingerPrint(certificate.getEncoded());
                string2 = NLS.bind((String)Messages.DefaultKeyStoreManager_certificateInfoFormat, (Object)simpleDateFormat.format(keyStore.getCreationDate(string)), (Object)string4);
                break;
            }
        }
        catch (KeyStoreException keyStoreException) {
            String string5 = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToAccessKeystoreContent, (Object)keyStoreException.getMessage());
            throw new KeyStoreManagerException(string5);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            String string6 = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToGetEncodedCertificate, (Object)certificateEncodingException.getMessage());
            throw new KeyStoreManagerException(string6);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string7 = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToCreateMD5Fingerprint, (Object)noSuchAlgorithmException.getMessage());
            throw new KeyStoreManagerException(string7);
        }
        return string2;
    }

    @Override
    public void changeKeystorePassword(String string) throws KeyStoreManagerException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(KEYTOOL);
        linkedList.add(STOREPASSWD);
        linkedList.add(KEYSTORE);
        linkedList.add(this.ksFile.getAbsolutePath());
        linkedList.add(STOREPASS);
        linkedList.add(this.ksPassword);
        linkedList.add(NEW);
        linkedList.add(string);
        if (this.ksProvider != null) {
            linkedList.add(PROVIDER);
            linkedList.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            linkedList.add(STORETYPE);
            linkedList.add(this.ksType);
        }
        this.keytool(linkedList.toArray(new String[0]));
        this.ksPassword = string;
    }

    @Override
    public void generateKeyPair(KeyPairInfo keyPairInfo) throws KeyStoreManagerException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(KEYTOOL);
        linkedList.add("-genkey");
        linkedList.add(KEYALG);
        linkedList.add(KEYALG_VALUE);
        linkedList.add(KEYSTORE);
        linkedList.add(this.ksFile.getAbsolutePath());
        linkedList.add(STOREPASS);
        linkedList.add(this.ksPassword);
        linkedList.add(ALIAS);
        linkedList.add(keyPairInfo.getAlias());
        linkedList.add(DNAME);
        linkedList.add(keyPairInfo.toString());
        linkedList.add(KEYPASS);
        linkedList.add(keyPairInfo.getPassword());
        if (this.ksProvider != null) {
            linkedList.add(PROVIDER);
            linkedList.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            linkedList.add(STORETYPE);
            linkedList.add(this.ksType);
        }
        this.keytool(linkedList.toArray(new String[0]));
    }

    @Override
    public void deleteKeyPair(String string) throws KeyStoreManagerException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(KEYTOOL);
        linkedList.add("-delete");
        linkedList.add(KEYSTORE);
        linkedList.add(this.ksFile.getAbsolutePath());
        linkedList.add(STOREPASS);
        linkedList.add(this.ksPassword);
        linkedList.add(ALIAS);
        linkedList.add(string);
        if (this.ksProvider != null) {
            linkedList.add(PROVIDER);
            linkedList.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            linkedList.add(STORETYPE);
            linkedList.add(this.ksType);
        }
        this.keytool(linkedList.toArray(new String[0]));
    }

    @Override
    public void generateCSR(String string, String string2, String string3) throws KeyStoreManagerException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(KEYTOOL);
        linkedList.add("-certreq");
        linkedList.add(SIGALG);
        linkedList.add(SIGALG_VALUE);
        linkedList.add(KEYSTORE);
        linkedList.add(this.ksFile.getAbsolutePath());
        linkedList.add(STOREPASS);
        linkedList.add(this.ksPassword);
        linkedList.add(ALIAS);
        linkedList.add(string);
        linkedList.add(KEYPASS);
        linkedList.add(string2);
        linkedList.add(FILE);
        linkedList.add(string3);
        if (this.ksProvider != null) {
            linkedList.add(PROVIDER);
            linkedList.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            linkedList.add(STORETYPE);
            linkedList.add(this.ksType);
        }
        this.keytool(linkedList.toArray(new String[0]));
    }

    @Override
    public void importCertificate(String string, String string2, String string3) throws KeyStoreManagerException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(KEYTOOL);
        linkedList.add("-import");
        linkedList.add("-noprompt");
        linkedList.add("-trustcacerts");
        linkedList.add(KEYSTORE);
        linkedList.add(this.ksFile.getAbsolutePath());
        linkedList.add(STOREPASS);
        linkedList.add(this.ksPassword);
        linkedList.add(ALIAS);
        linkedList.add(string);
        linkedList.add(KEYPASS);
        linkedList.add(string2);
        linkedList.add(FILE);
        linkedList.add(string3);
        if (this.ksProvider != null) {
            linkedList.add(PROVIDER);
            linkedList.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            linkedList.add(STORETYPE);
            linkedList.add(this.ksType);
        }
        this.keytool(linkedList.toArray(new String[0]));
    }

    private void keytool(String[] stringArray) throws KeyStoreManagerException {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            while (true) {
                try {
                    int n = process.waitFor();
                    if (n != 0) {
                        String string = this.getProcessErrorMessage(process);
                        throw new KeyStoreManagerException(string);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new KeyStoreManagerException(iOException.getMessage());
        }
    }

    private String getProcessErrorMessage(Process process) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer stringBuffer = new StringBuffer();
        String string = Messages.DefaultKeyStoreManager_22;
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2.trim());
            if (string2 != null) continue;
        }
        Pattern pattern = Pattern.compile("[keytool error:].*[:]");
        String[] stringArray = pattern.split(stringBuffer.toString());
        if (stringArray.length == 2) {
            string = stringArray[1];
        }
        return string;
    }

    private String buildFingerPrint(byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray2;
        StringBuffer stringBuffer = new StringBuffer();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray3 = byArray2 = messageDigest.digest(byArray);
        int n = byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            byte by = byArray3[n2];
            if (stringBuffer.length() > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append((string = Integer.toHexString(by & 0xFF).toUpperCase()).length() > 1 ? string : NLS.bind((String)"0{0}", (Object)string));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private KeyStore openKeyStore() throws KeyStoreManagerException {
        KeyStore keyStore = null;
        try {
            keyStore = this.ksProvider != null ? KeyStore.getInstance(this.ksType, this.ksProvider) : KeyStore.getInstance(this.ksType);
            keyStore.load((InputStream)new FileInputStream(this.ksFile), this.ksPassword.toCharArray());
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToOpenKeystore, (Object)exception.getMessage());
            throw new KeyStoreManagerException(string);
        }
        return keyStore;
    }
}

