/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.symbol.ISymbolSetConstants;
import org.eclipse.mtj.internal.core.symbol.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolSet
implements ISymbolSet,
ISymbolSetConstants {
    private String name = "";
    private HashMap<String, ISymbol> symbols = new HashMap();

    @Override
    public ISymbol add(String string) {
        Symbol symbol = new Symbol(string, "true");
        this.symbols.put(string, symbol);
        return symbol;
    }

    @Override
    public ISymbol add(String string, String string2) {
        Symbol symbol = new Symbol(string, string2);
        this.symbols.put(string, symbol);
        return symbol;
    }

    @Override
    public ISymbol add(String string, String string2, int n) {
        Symbol symbol = new Symbol(string, string2, n);
        this.symbols.put(string, symbol);
        return symbol;
    }

    @Override
    public boolean contains(String string) {
        return this.symbols.containsKey(string);
    }

    public boolean equals(Object object) {
        return object instanceof SymbolSet && this.equals((SymbolSet)object);
    }

    @Override
    public boolean equals(ISymbolSet iSymbolSet) {
        SymbolSet symbolSet = (SymbolSet)iSymbolSet;
        return this.name.equals(symbolSet.getName()) && this.symbols.equals(symbolSet.symbols);
    }

    public String toString() {
        return this.getSymbolSetString();
    }

    public int hashCode() {
        return this.safeHash(this.name) ^ this.safeHash(this.symbols);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSymbolSetString() {
        Collection<ISymbol> collection = this.symbols.values();
        StringBuffer stringBuffer = new StringBuffer();
        for (ISymbol iSymbol : collection) {
            stringBuffer.append(iSymbol.getName()).append("=").append(iSymbol.getSafeValue()).append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    @Override
    public String getSymbolValue(String string) {
        return this.symbols.get(string).getValue();
    }

    @Override
    public Collection<ISymbol> getSymbols() {
        return this.symbols.values();
    }

    @Override
    public void remove(String string) {
        this.symbols.remove(string);
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setSymbols(Map<String, String> map) {
        this.symbols.clear();
        for (String string : map.keySet()) {
            this.add(string, map.get(string));
        }
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Collection<ISymbol> collection = this.symbols.values();
        return collection.toArray(TArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String[] stringArray;
        this.name = iPersistenceProvider.loadString("mtjName");
        this.symbols.clear();
        String string = iPersistenceProvider.loadString("mtjKeys" + this.getStorableName());
        if (string != null && string.length() > 0) {
            void string4;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            boolean n2 = false;
            while (string4 < n) {
                String string2 = stringArray2[string4];
                String string3 = iPersistenceProvider.loadString(string2);
                this.add(string2, string3);
                ++string4;
            }
        }
        if ((stringArray = iPersistenceProvider.loadProperties("mtjKeys")) != null) {
            for (String string4 : stringArray.keySet()) {
                String string5 = stringArray.getProperty(string4);
                this.add(string4, string5);
            }
        }
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString("mtjName", this.name);
        Iterator<Map.Entry<String, ISymbol>> iterator = this.symbols.entrySet().iterator();
        Properties properties = new Properties();
        while (iterator.hasNext()) {
            Map.Entry<String, ISymbol> entry = iterator.next();
            properties.put(entry.getKey(), entry.getValue().getValue());
        }
        iPersistenceProvider.storeProperties("mtjKeys", properties);
    }

    String getStorableName() {
        return this.name.replaceAll("\\ ", "_");
    }

    private int safeHash(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    @Override
    public void add(Collection<ISymbol> collection) {
        for (ISymbol iSymbol : collection) {
            this.symbols.put(iSymbol.getName(), iSymbol);
        }
    }

    @Override
    public void add(ISymbol iSymbol) {
        this.symbols.put(iSymbol.getName(), iSymbol);
    }

    @Override
    public void remove(Collection<ISymbol> collection) {
        for (ISymbol iSymbol : collection) {
            this.symbols.remove(iSymbol.getName());
        }
    }
}

