/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress,
IThreadListener {
    private ISchedulingRule rule;
    private boolean transfer = false;
    private IWorkspaceRunnable workspaceRunnable;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable iWorkspaceRunnable) {
        this(iWorkspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable iWorkspaceRunnable, ISchedulingRule iSchedulingRule) {
        this.workspaceRunnable = iWorkspaceRunnable;
        this.rule = iSchedulingRule;
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable iWorkspaceRunnable, ISchedulingRule iSchedulingRule, boolean bl) {
        this.workspaceRunnable = iWorkspaceRunnable;
        this.rule = iSchedulingRule;
        this.transfer = bl;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.rule;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            JavaCore.run((IWorkspaceRunnable)this.workspaceRunnable, (ISchedulingRule)this.rule, (IProgressMonitor)iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException(operationCanceledException.getMessage());
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    public void runAsUserJob(String string, final Object object) {
        Job job = new Job(string){

            public boolean belongsTo(Object object2) {
                return object == object2;
            }

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    try {
                        WorkbenchRunnableAdapter.this.run(iProgressMonitor);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getCause();
                        if (throwable instanceof CoreException) {
                            IStatus iStatus = ((CoreException)throwable).getStatus();
                            iProgressMonitor.done();
                            return iStatus;
                        }
                        Status status = new Status(4, "org.eclipse.mtj.ui", throwable.getMessage(), throwable);
                        iProgressMonitor.done();
                        return status;
                    }
                    catch (InterruptedException interruptedException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        iProgressMonitor.done();
                        return iStatus;
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(this.rule);
        job.setUser(true);
        job.schedule();
    }

    public void threadChange(Thread thread) {
        if (this.transfer) {
            Job.getJobManager().transferRule(this.rule, thread);
        }
    }
}

